/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.analysis.dataflow.analysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.Cursor;
import org.openrewrite.Incubating;
import org.openrewrite.Tree;
import org.openrewrite.analysis.dataflow.DataFlowNode;
import org.openrewrite.analysis.dataflow.LocalFlowSpec;
import org.openrewrite.analysis.dataflow.analysis.FlowGraph;
import org.openrewrite.analysis.trait.expr.VarAccess;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;

@Incubating(since="7.24.0")
public class ForwardFlow
extends JavaVisitor<Integer> {
    public static void findSinks(FlowGraph root, LocalFlowSpec<?, ?> spec) {
        Object next;
        VariableNameToFlowGraph variableNameToFlowGraph = ForwardFlow.computeVariableAssignment(root.getCursor(), root, spec);
        if (variableNameToFlowGraph.identifierToFlow.isEmpty()) {
            return;
        }
        Object taintStmt = null;
        Cursor taintStmtCursorParent = null;
        if (variableNameToFlowGraph.currentCursor != null && variableNameToFlowGraph.currentCursor.getValue() instanceof J) {
            taintStmt = variableNameToFlowGraph.currentCursor.getValue();
            taintStmtCursorParent = variableNameToFlowGraph.currentCursor.getParent();
        }
        Iterator<Cursor> remainingPath = variableNameToFlowGraph.remainingCursorPath;
        while (remainingPath.hasNext() && !((next = (taintStmtCursorParent = remainingPath.next()).getValue()) instanceof J.Block)) {
            if (!(next instanceof J)) continue;
            taintStmt = next;
        }
        Analysis analysis = new Analysis(spec, variableNameToFlowGraph.identifierToFlow.copy());
        if (taintStmtCursorParent == null) {
            throw new IllegalStateException("`taintStmtCursorParent` is null. Computing flow starting at " + root.getCursor().getValue());
        }
        if (taintStmt instanceof J.WhileLoop || taintStmt instanceof J.DoWhileLoop || taintStmt instanceof J.ForLoop) {
            Statement body = taintStmt instanceof J.WhileLoop ? ((J.WhileLoop)taintStmt).getBody() : (taintStmt instanceof J.DoWhileLoop ? ((J.DoWhileLoop)taintStmt).getBody() : ((J.ForLoop)taintStmt).getBody());
            analysis.visit((Tree)body, 0, taintStmtCursorParent);
        } else if (taintStmt instanceof J.Try) {
            J.Try _try = (J.Try)taintStmt;
            analysis.visit((Tree)_try.getBody(), 0, taintStmtCursorParent);
            analysis.visit((Tree)_try.getFinally(), 0, taintStmtCursorParent);
        } else {
            assert (taintStmt != null) : "taintStmt is null";
            ForwardFlow.visitBlocksRecursive(root.getCursor().dropParentUntil(J.Block.class::isInstance), taintStmt, analysis);
        }
    }

    private static void visitBlocksRecursive(Cursor blockCursor, Object startStatement, Analysis analysis) {
        boolean seenRoot = false;
        J.Block block = (J.Block)blockCursor.getValue();
        ArrayList<String> declaredVariables = new ArrayList<String>();
        for (Statement statement : block.getStatements()) {
            if (statement instanceof J.VariableDeclarations) {
                J.VariableDeclarations variableDeclarations = (J.VariableDeclarations)statement;
                for (J.VariableDeclarations.NamedVariable variableDeclaration : variableDeclarations.getVariables()) {
                    declaredVariables.add(variableDeclaration.getSimpleName());
                }
            }
            if (seenRoot) {
                analysis.visit((Tree)statement, 0, blockCursor);
            }
            if (statement != startStatement) continue;
            seenRoot = true;
        }
        J.MethodDeclaration parentMethodDeclaration = (J.MethodDeclaration)blockCursor.firstEnclosing(J.MethodDeclaration.class);
        if (parentMethodDeclaration != null && parentMethodDeclaration.getBody() == block) {
            return;
        }
        J.Block parentBlock = (J.Block)blockCursor.getParentOrThrow().firstEnclosing(J.Block.class);
        if (parentBlock != null && parentBlock.getStatements().contains(block) && J.Block.isStaticOrInitBlock((Cursor)blockCursor)) {
            return;
        }
        declaredVariables.forEach(analysis.flowsByIdentifier.peek()::remove);
        J nextStartStatement = (J)blockCursor.getParentOrThrow().firstEnclosing(J.class);
        if (nextStartStatement instanceof J.Block && ((J.Block)nextStartStatement).getStatements().contains(block)) {
            nextStartStatement = block;
        } else if (nextStartStatement == null || !ForwardFlow.getPossibleSubBlock(nextStartStatement).contains(block)) {
            return;
        }
        ForwardFlow.visitBlocksRecursive(blockCursor.dropParentUntil(J.Block.class::isInstance), nextStartStatement, analysis);
    }

    private static Set<Statement> getPossibleSubBlock(J j) {
        if (j instanceof J.If) {
            J.If _if = (J.If)j;
            if (_if.getElsePart() != null) {
                return Stream.of(_if.getThenPart(), _if.getElsePart().getBody()).collect(Collectors.toSet());
            }
            return Collections.singleton(_if.getThenPart());
        }
        if (j instanceof J.WhileLoop) {
            return Collections.singleton(((J.WhileLoop)j).getBody());
        }
        if (j instanceof J.DoWhileLoop) {
            return Collections.singleton(((J.DoWhileLoop)j).getBody());
        }
        if (j instanceof J.ForLoop) {
            return Collections.singleton(((J.ForLoop)j).getBody());
        }
        if (j instanceof J.ForEachLoop) {
            return Collections.singleton(((J.ForEachLoop)j).getBody());
        }
        if (j instanceof J.Try) {
            J.Try _try = (J.Try)j;
            return Stream.concat(Stream.of(_try.getBody(), _try.getFinally()), _try.getCatches().stream().map(J.Try.Catch::getBody)).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    private static VariableNameToFlowGraph computeVariableAssignment(Cursor startCursor, FlowGraph currentFlow, LocalFlowSpec<?, ?> spec) {
        Iterator cursorPath = startCursor.getPathAsCursors();
        Cursor ancestorCursor = null;
        if (cursorPath.hasNext()) {
            ancestorCursor = (Cursor)cursorPath.next();
        }
        IdentifierToFlows identifierToFlow = new IdentifierToFlows();
        FlowGraph nextFlowGraph = currentFlow;
        while (cursorPath.hasNext()) {
            ancestorCursor = (Cursor)cursorPath.next();
            Object ancestor = ancestorCursor.getValue();
            if (ancestor instanceof Expression) {
                Cursor previousCursor = nextFlowGraph.getCursor();
                if (spec.isBarrier((Expression)ancestor, ancestorCursor)) break;
                Cursor methodInvocationCursor = previousCursor.getParentTreeCursor();
                if (methodInvocationCursor.getValue() instanceof J.MethodInvocation) {
                    J.MethodInvocation methodInvocation = (J.MethodInvocation)methodInvocationCursor.getValue();
                    if (methodInvocation.getSelect() != null && methodInvocation.getArguments().contains(previousCursor.getValue())) {
                        Cursor selectCursor = new Cursor(methodInvocationCursor, (Object)methodInvocation.getSelect());
                        if (spec.isFlowStep(DataFlowNode.of(previousCursor), DataFlowNode.of(selectCursor))) {
                            nextFlowGraph = nextFlowGraph.addEdge(selectCursor);
                            Expression unwrappedSelect = methodInvocation.getSelect().unwrap();
                            VariableNameToFlowGraph variableNameToFlowGraph = ForwardFlow.computeVariableAssignment(selectCursor, nextFlowGraph, spec);
                            if (unwrappedSelect instanceof J.Identifier) {
                                String variableName = ((J.Identifier)unwrappedSelect).getSimpleName();
                                variableNameToFlowGraph.identifierToFlow.put(variableName, nextFlowGraph);
                            }
                            return variableNameToFlowGraph;
                        }
                    }
                    if (methodInvocation.getArguments().contains(previousCursor.getValue()) || methodInvocation.getSelect() == previousCursor.getValue()) {
                        for (Expression expr : methodInvocation.getArguments()) {
                            if (expr.equals(previousCursor.getValue())) continue;
                            Cursor argumentCursor = new Cursor(methodInvocationCursor, (Object)expr);
                            if (!spec.isFlowStep(DataFlowNode.of(previousCursor), DataFlowNode.of(argumentCursor))) continue;
                            nextFlowGraph = nextFlowGraph.addEdge(argumentCursor);
                            Expression unwrappedArgument = expr.unwrap();
                            VariableNameToFlowGraph variableNameToFlowGraph = ForwardFlow.computeVariableAssignment(argumentCursor, nextFlowGraph, spec);
                            if (unwrappedArgument instanceof J.Identifier) {
                                String variableName = ((J.Identifier)unwrappedArgument).getSimpleName();
                                variableNameToFlowGraph.identifierToFlow.put(variableName, nextFlowGraph);
                            }
                            return variableNameToFlowGraph;
                        }
                    }
                }
                if (spec.isFlowStep(DataFlowNode.of(previousCursor), DataFlowNode.of(ancestorCursor))) {
                    nextFlowGraph = nextFlowGraph.addEdge(ancestorCursor);
                    J ancestorParent = (J)ancestorCursor.getParentTreeCursor().getValue();
                    if (!(ancestorParent instanceof J.Block) && !(ancestorParent instanceof J.Case)) continue;
                    break;
                }
            }
            if (ancestor instanceof J.Binary || ancestor instanceof J.MethodInvocation) break;
            if (ancestor instanceof J.Ternary) {
                J.Ternary ternary = (J.Ternary)ancestor;
                Object previousCursorValue = nextFlowGraph.getCursor().getValue();
                if (ternary.getTruePart() != previousCursorValue && ternary.getFalsePart() != previousCursorValue) break;
                nextFlowGraph = nextFlowGraph.addEdge(ancestorCursor);
                continue;
            }
            if (ancestor instanceof J.TypeCast || ancestor instanceof J.Parentheses || ancestor instanceof J.ControlParentheses) {
                Cursor parent = ancestorCursor.getParentOrThrow();
                if (parent.getValue() instanceof J.Switch || parent.getValue() instanceof J.SwitchExpression) break;
                nextFlowGraph = nextFlowGraph.addEdge(ancestorCursor);
                continue;
            }
            if (ancestor instanceof J.NewClass) break;
            if (!(ancestor instanceof J.Assignment) && !(ancestor instanceof J.AssignmentOperation) && !(ancestor instanceof J.VariableDeclarations.NamedVariable)) continue;
            Object variable = ancestor instanceof J.Assignment ? ((J.Assignment)ancestor).getVariable() : (ancestor instanceof J.AssignmentOperation ? ((J.AssignmentOperation)ancestor).getVariable() : ((J.VariableDeclarations.NamedVariable)ancestor).getName());
            if (!((variable = variable.unwrap()) instanceof J.Identifier)) continue;
            String nextVariableName = ((J.Identifier)variable).getSimpleName();
            identifierToFlow.put(nextVariableName, nextFlowGraph);
            break;
        }
        return new VariableNameToFlowGraph(identifierToFlow, ancestorCursor, cursorPath);
    }

    private static final class VariableNameToFlowGraph {
        IdentifierToFlows identifierToFlow;
        Cursor currentCursor;
        Iterator<Cursor> remainingCursorPath;

        public VariableNameToFlowGraph(IdentifierToFlows identifierToFlow, Cursor currentCursor, Iterator<Cursor> remainingCursorPath) {
            this.identifierToFlow = identifierToFlow;
            this.currentCursor = currentCursor;
            this.remainingCursorPath = remainingCursorPath;
        }
    }

    static class IdentifierToFlows {
        private final Map<String, Set<FlowGraph>> identifierToFlows;

        public IdentifierToFlows() {
            this(new HashMap<String, Set<FlowGraph>>());
        }

        public void put(String identifier, FlowGraph flow) {
            this.identifierToFlows.computeIfAbsent(identifier, k -> Collections.newSetFromMap(new IdentityHashMap())).add(flow);
        }

        public void putAll(IdentifierToFlows other) {
            other.identifierToFlows.forEach((identifier, flows) -> flows.forEach(flow -> this.put((String)identifier, (FlowGraph)flow)));
        }

        public FlowGraph addForIdentifierVisit(String identifier, Cursor cursor) {
            if (!this.hasFlows(identifier)) {
                throw new IllegalArgumentException("No flows for identifier " + identifier);
            }
            Iterator<FlowGraph> iterator = this.get(identifier).iterator();
            FlowGraph flow = iterator.next();
            FlowGraph newFlowGraph = flow.addEdge(cursor);
            while (iterator.hasNext()) {
                FlowGraph next = iterator.next();
                next.addEdge(newFlowGraph);
            }
            this.identifierToFlows.get(identifier).clear();
            this.put(identifier, newFlowGraph);
            return newFlowGraph;
        }

        public Set<FlowGraph> get(String identifier) {
            return this.identifierToFlows.getOrDefault(identifier, Collections.emptySet());
        }

        public boolean hasFlows(String identifier) {
            return this.identifierToFlows.containsKey(identifier);
        }

        public Set<FlowGraph> remove(String identifier) {
            return this.identifierToFlows.remove(identifier);
        }

        public boolean isEmpty() {
            return this.identifierToFlows.isEmpty();
        }

        public IdentifierToFlows copy() {
            HashMap<String, Set<FlowGraph>> newIdentifierToFlows = new HashMap<String, Set<FlowGraph>>();
            this.identifierToFlows.forEach((identifier, flows) -> newIdentifierToFlows.put((String)identifier, new HashSet(flows)));
            return new IdentifierToFlows(newIdentifierToFlows);
        }

        public IdentifierToFlows(Map<String, Set<FlowGraph>> identifierToFlows) {
            this.identifierToFlows = identifierToFlows;
        }
    }

    private static class Analysis
    extends JavaVisitor<Integer> {
        final LocalFlowSpec<?, ?> localFlowSpec;
        Stack<IdentifierToFlows> flowsByIdentifier = new Stack();

        Analysis(LocalFlowSpec<?, ?> localFlowSpec, IdentifierToFlows initial) {
            this.localFlowSpec = localFlowSpec;
            this.flowsByIdentifier.push(initial);
        }

        public J visitVariable(J.VariableDeclarations.NamedVariable variable, Integer p) {
            this.flowsByIdentifier.peek().remove(variable.getSimpleName());
            return super.visitVariable(variable, (Object)p);
        }

        public J visitLambda(J.Lambda lambda, Integer p) {
            for (J parameter : lambda.getParameters().getParameters()) {
                new JavaIsoVisitor<Integer>(){

                    public J.Identifier visitIdentifier(J.Identifier identifier, Integer integer) {
                        flowsByIdentifier.peek().remove(identifier.getSimpleName());
                        return identifier;
                    }
                }.visit((Tree)parameter, (Object)0);
            }
            return super.visitLambda(lambda, (Object)p);
        }

        public J visitIdentifier(J.Identifier ident, Integer p) {
            if (((Boolean)VarAccess.viewOf(this.getCursor()).map(va -> !va.isRValue()).orSuccess((Object)true)).booleanValue()) {
                return ident;
            }
            J.FieldAccess parentFieldAccess = (J.FieldAccess)this.getCursor().firstEnclosing(J.FieldAccess.class);
            if (parentFieldAccess != null && parentFieldAccess.getName() == ident) {
                return ident;
            }
            if (this.flowsByIdentifier.peek().hasFlows(ident.getSimpleName())) {
                FlowGraph next = this.flowsByIdentifier.peek().addForIdentifierVisit(ident.getSimpleName(), this.getCursor());
                VariableNameToFlowGraph variableNameToFlowGraph = ForwardFlow.computeVariableAssignment(this.getCursor(), next, this.localFlowSpec);
                if (!variableNameToFlowGraph.identifierToFlow.isEmpty()) {
                    this.flowsByIdentifier.peek().putAll(variableNameToFlowGraph.identifierToFlow);
                }
            }
            return ident;
        }

        public J visitBlock(J.Block block, Integer p) {
            this.flowsByIdentifier.push(this.flowsByIdentifier.peek().copy());
            J b = super.visitBlock(block, (Object)p);
            this.flowsByIdentifier.pop();
            return b;
        }

        public J visitAssignment(J.Assignment assignment, Integer integer) {
            J.Assignment a = (J.Assignment)super.visitAssignment(assignment, (Object)integer);
            Expression left = a.getVariable().unwrap();
            if (left instanceof J.Identifier) {
                String variableName = ((J.Identifier)left).getSimpleName();
                if (this.flowsByIdentifier.peek().hasFlows(variableName) && this.flowsByIdentifier.peek().get(variableName).stream().allMatch(v -> v.getCursor().getValue() != a.getAssignment())) {
                    this.flowsByIdentifier.peek().remove(variableName);
                }
            }
            return a;
        }

        public J visitNewClass(J.NewClass newClass, Integer integer) {
            return super.visitNewClass(newClass, (Object)integer);
        }
    }
}

