/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.analysis.trait;

import fj.data.List;
import fj.data.NonEmptyList;
import fj.data.Option;
import fj.data.Validation;
import org.openrewrite.Cursor;
import org.openrewrite.analysis.trait.Top;
import org.openrewrite.analysis.trait.util.TraitErrors;

public interface TraitFactory<T extends Top> {
    public Validation<TraitErrors, T> viewOf(Cursor var1);

    @SafeVarargs
    public static <T extends Top> Validation<TraitErrors, T> findFirstViewOf(Cursor cursor, TraitFactory<? extends T> factory, TraitFactory<? extends T> ... factories) {
        return TraitFactory.findFirstViewOf(cursor, NonEmptyList.nel(factory, (Object[])factories));
    }

    public static <T extends Top> Validation<TraitErrors, T> findFirstViewOf(Cursor cursor, NonEmptyList<TraitFactory<? extends T>> factories) {
        Validation view = ((TraitFactory)factories.head()).viewOf(cursor).map(t -> t);
        Option remainder = NonEmptyList.fromList((List)factories.tail());
        if (remainder.isNone()) {
            return view;
        }
        return view.f().bind(fail -> {
            Validation next = TraitFactory.findFirstViewOf(cursor, (NonEmptyList)remainder.some());
            return next.f().bind(nextFail -> Validation.fail((Object)((TraitErrors)TraitErrors.semigroup.sum(fail, nextFail))));
        });
    }
}

