/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.analysis.trait.util;

import fj.Semigroup;
import fj.data.Validation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.concurrent.Immutable;
import org.openrewrite.Cursor;
import org.openrewrite.analysis.trait.util.TraitError;
import org.openrewrite.analysis.trait.util.TraitErrorsException;

@Immutable
public final class TraitErrors
implements Iterable<TraitError> {
    private final List<TraitError> errors;
    public static Semigroup<TraitErrors> semigroup = Semigroup.semigroupDef((a, b) -> new TraitErrors(Stream.concat(a.errors.stream(), b.errors.stream()).collect(Collectors.toList())));

    private TraitErrors(List<TraitError> errors) {
        this.errors = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(errors, "errors cannot be null")));
    }

    @Override
    public Iterator<TraitError> iterator() {
        return this.errors.iterator();
    }

    public <V> V doThrow() {
        throw new TraitErrorsException(this);
    }

    public String toString() {
        return "TraitErrors: " + this.errors.stream().map(TraitError::getError).collect(Collectors.joining("\n\t- ", "\n\t- ", ""));
    }

    public static TraitErrors fromSingle(TraitError error) {
        return new TraitErrors(Collections.singletonList(error));
    }

    public static TraitErrors fromSingleError(String error) {
        return TraitErrors.fromSingle(new TraitError(error));
    }

    public static <V> Validation<TraitErrors, V> invalidTraitCreationError(String error) {
        return Validation.fail((Object)TraitErrors.fromSingleError(error));
    }

    public static <V> Validation<TraitErrors, V> invalidTraitCreationType(Class<?> traitType, Cursor cursor, Class<?> expectedType) {
        return Validation.fail((Object)TraitErrors.fromSingleError(traitType.getSimpleName() + " must be created from " + expectedType + " but was " + cursor.getValue().getClass()));
    }

    public static <V> Validation<TraitErrors, V> invalidTraitCreationType(Class<?> traitType, Cursor cursor, Class<?> expectedTypeFirst, Class<?> expectedTypeSecond) {
        return Validation.fail((Object)TraitErrors.fromSingleError(traitType.getSimpleName() + " must be created from " + expectedTypeFirst + " or " + expectedTypeSecond + " but was " + cursor.getValue().getClass()));
    }
}

