/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.analysis.dataflow;

import fj.data.Option;
import java.util.Set;
import org.openrewrite.Cursor;
import org.openrewrite.Incubating;
import org.openrewrite.analysis.controlflow.ControlFlow;
import org.openrewrite.analysis.dataflow.DataFlowNode;
import org.openrewrite.analysis.dataflow.DataFlowSpec;
import org.openrewrite.analysis.dataflow.analysis.FlowGraph;
import org.openrewrite.analysis.dataflow.analysis.ForwardFlow;
import org.openrewrite.analysis.dataflow.analysis.SinkFlowSummary;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.tree.Expression;

@Incubating(since="7.24.0")
public class Dataflow {
    @Nullable
    private final DataFlowNode n;

    public Option<SinkFlowSummary> findSinks(DataFlowSpec spec) {
        if (this.n == null) {
            return Option.none();
        }
        if (!spec.isSource(this.n)) {
            return Option.none();
        }
        return ControlFlow.startingAt(this.n.getCursor()).findControlFlow().bind(summary -> {
            Set<Expression> reachable = summary.computeReachableExpressions(spec::isBarrierGuard);
            FlowGraph flow = ForwardFlow.findAllFlows(this.n, spec, FlowGraph.Factory.defaultFactory());
            SinkFlowSummary sinkFlowSummary = SinkFlowSummary.create(flow, spec, reachable);
            return sinkFlowSummary.isNotEmpty() ? Option.some((Object)sinkFlowSummary) : Option.none();
        });
    }

    public static Dataflow startingAt(Cursor start) {
        return Dataflow.startingAt((DataFlowNode)DataFlowNode.of(start).toNull());
    }

    public static Dataflow startingAt(@Nullable DataFlowNode node) {
        return new Dataflow(node);
    }

    private Dataflow(@Nullable DataFlowNode n) {
        this.n = n;
    }
}

