/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.analysis.search;

import org.openrewrite.Incubating;
import org.openrewrite.Tree;
import org.openrewrite.analysis.InvocationMatcher;
import org.openrewrite.internal.LoathingOfOthers;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.marker.SearchResult;

@LoathingOfOthers(value="org.openrewrite.java.MethodMatcher")
@Incubating(since="2.2.4")
public class UsesInvocation<P>
extends JavaIsoVisitor<P> {
    private final InvocationMatcher invocationMatcher;

    public UsesInvocation(InvocationMatcher invocationMatcher) {
        this.invocationMatcher = invocationMatcher;
    }

    public J visit(@Nullable Tree tree, P p) {
        if (tree instanceof JavaSourceFile) {
            JavaSourceFile cu = (JavaSourceFile)tree;
            for (JavaType.Method type : cu.getTypesInUse().getUsedMethods()) {
                if (!this.invocationMatcher.matches(type)) continue;
                return (J)SearchResult.found((Tree)cu);
            }
            return (J)tree;
        }
        return (J)super.visit(tree, p);
    }

    public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, P p) {
        if (this.invocationMatcher.matches((MethodCall)method)) {
            return (J.MethodInvocation)SearchResult.found((Tree)method);
        }
        return super.visitMethodInvocation(method, p);
    }

    public J.MemberReference visitMemberReference(J.MemberReference memberRef, P p) {
        if (this.invocationMatcher.matches((MethodCall)memberRef)) {
            return (J.MemberReference)SearchResult.found((Tree)memberRef);
        }
        return super.visitMemberReference(memberRef, p);
    }

    public J.NewClass visitNewClass(J.NewClass newClass, P p) {
        if (this.invocationMatcher.matches((MethodCall)newClass)) {
            return (J.NewClass)SearchResult.found((Tree)newClass);
        }
        return super.visitNewClass(newClass, p);
    }
}

