/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.analysis.dataflow;

import fj.data.Option;
import java.util.Objects;
import java.util.function.Function;
import org.openrewrite.Cursor;
import org.openrewrite.analysis.dataflow.DataFlowNode;
import org.openrewrite.analysis.trait.expr.Expr;
import org.openrewrite.analysis.trait.variable.Parameter;

class ExpressionDataFlowNode
extends DataFlowNode {
    private final Expr expression;

    ExpressionDataFlowNode(Cursor cursor, Expr expression) {
        super(cursor);
        this.expression = Objects.requireNonNull(expression, "expression");
    }

    @Override
    public Option<Expr> asExpr() {
        return Option.some((Object)this.expression);
    }

    @Override
    public Option<Parameter> asParameter() {
        return Option.none();
    }

    @Override
    <T> T map(Function<Expr, T> whenExpression, Function<Parameter, T> whenParameter) {
        Objects.requireNonNull(whenExpression, "whenExpression");
        Objects.requireNonNull(whenParameter, "whenParameter");
        return whenExpression.apply(this.expression);
    }
}

