/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.analysis.search;

import java.util.function.Predicate;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.analysis.InvocationMatcher;
import org.openrewrite.analysis.dataflow.DataFlowNode;
import org.openrewrite.analysis.dataflow.DataFlowSpec;
import org.openrewrite.analysis.dataflow.TaintFlowSpec;
import org.openrewrite.analysis.dataflow.global.GlobalDataFlow;
import org.openrewrite.analysis.trait.expr.Call;
import org.openrewrite.internal.lang.NonNull;

public final class FindFlowBetweenMethods
extends ScanningRecipe<GlobalDataFlow.Accumulator> {
    @Option(displayName="Start method pattern", description="A method pattern that is used to find matching the start point's method invocations.", example="java.util.List add(..)")
    private final String startMethodPattern;
    @Option(displayName="Match start method on overrides", description="When enabled, find methods that are overrides of the method pattern.", required=false)
    private final @Nullable Boolean startMatchOverrides;
    @Option(displayName="End method pattern", description="A method pattern that is used to find matching the end point's method invocations.", example="java.util.List add(..)")
    private final String endMethodPattern;
    @Option(displayName="Match end method on overrides", description="When enabled, find methods that are overrides of the method pattern.", required=false)
    private final @Nullable Boolean endMatchOverrides;
    @Option(displayName="To target", description="The part of the method flow should traverse to", required=true, valid={"Select", "Arguments", "Both"})
    private final String target;
    @Option(displayName="Show flow", description="When enabled, show the data or taint flow of the method invocation.", valid={"Data", "Taint"}, required=true)
    private final @Nullable String flow;

    public String getDisplayName() {
        return "Finds flow between two methods";
    }

    public String getDescription() {
        return "Takes two patterns for the start/end methods to find flow between.";
    }

    public GlobalDataFlow.Accumulator getInitialValue(ExecutionContext ctx) {
        String flow;
        Predicate<Cursor> sinkMatcher;
        final InvocationMatcher startMatcher = InvocationMatcher.fromMethodMatcher(this.startMethodPattern, this.startMatchOverrides);
        InvocationMatcher endMatcher = InvocationMatcher.fromMethodMatcher(this.endMethodPattern, this.endMatchOverrides);
        InvocationMatcher.AdvancedInvocationMatcher endAdvanced = endMatcher.advanced();
        switch (this.target) {
            case "Select": {
                sinkMatcher = endAdvanced::isSelect;
                break;
            }
            case "Arguments": {
                sinkMatcher = endAdvanced::isAnyArgument;
                break;
            }
            case "Both": {
                sinkMatcher = cursor -> endAdvanced.isAnyArgument((Cursor)cursor) || endAdvanced.isSelect((Cursor)cursor);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown target: " + this.target);
            }
        }
        String string = flow = this.flow == null ? "Data" : this.flow;
        if ("Taint".equals(flow)) {
            return GlobalDataFlow.accumulator(new TaintFlowSpec(){

                @Override
                public boolean isSource(DataFlowNode srcNode) {
                    return FindFlowBetweenMethods.isSource(srcNode, startMatcher);
                }

                @Override
                public boolean isSink(DataFlowNode sinkNode) {
                    return sinkMatcher.test(sinkNode.getCursor());
                }
            });
        }
        return GlobalDataFlow.accumulator(new DataFlowSpec(){

            @Override
            public boolean isSource(DataFlowNode srcNode) {
                return FindFlowBetweenMethods.isSource(srcNode, startMatcher);
            }

            @Override
            public boolean isSink(DataFlowNode sinkNode) {
                return sinkMatcher.test(sinkNode.getCursor());
            }
        });
    }

    private static boolean isSource(DataFlowNode srcNode, InvocationMatcher startMatcher) {
        return srcNode.asExprParent(Call.class).bind(Call::getMethodType).filter(startMatcher::matches).isSome();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(GlobalDataFlow.Accumulator acc) {
        return acc.scanner();
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(GlobalDataFlow.Accumulator acc) {
        return acc.renderer();
    }

    @Generated
    public FindFlowBetweenMethods(String startMethodPattern, @Nullable Boolean startMatchOverrides, String endMethodPattern, @Nullable Boolean endMatchOverrides, String target, @Nullable String flow) {
        this.startMethodPattern = startMethodPattern;
        this.startMatchOverrides = startMatchOverrides;
        this.endMethodPattern = endMethodPattern;
        this.endMatchOverrides = endMatchOverrides;
        this.target = target;
        this.flow = flow;
    }

    @Generated
    public String getStartMethodPattern() {
        return this.startMethodPattern;
    }

    @Generated
    public @Nullable Boolean getStartMatchOverrides() {
        return this.startMatchOverrides;
    }

    @Generated
    public String getEndMethodPattern() {
        return this.endMethodPattern;
    }

    @Generated
    public @Nullable Boolean getEndMatchOverrides() {
        return this.endMatchOverrides;
    }

    @Generated
    public String getTarget() {
        return this.target;
    }

    @Generated
    public @Nullable String getFlow() {
        return this.flow;
    }

    @NonNull
    @Generated
    public String toString() {
        return "FindFlowBetweenMethods(startMethodPattern=" + this.getStartMethodPattern() + ", startMatchOverrides=" + this.getStartMatchOverrides() + ", endMethodPattern=" + this.getEndMethodPattern() + ", endMatchOverrides=" + this.getEndMatchOverrides() + ", target=" + this.getTarget() + ", flow=" + this.getFlow() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindFlowBetweenMethods)) {
            return false;
        }
        FindFlowBetweenMethods other = (FindFlowBetweenMethods)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$startMatchOverrides = this.getStartMatchOverrides();
        Boolean other$startMatchOverrides = other.getStartMatchOverrides();
        if (this$startMatchOverrides == null ? other$startMatchOverrides != null : !((Object)this$startMatchOverrides).equals(other$startMatchOverrides)) {
            return false;
        }
        Boolean this$endMatchOverrides = this.getEndMatchOverrides();
        Boolean other$endMatchOverrides = other.getEndMatchOverrides();
        if (this$endMatchOverrides == null ? other$endMatchOverrides != null : !((Object)this$endMatchOverrides).equals(other$endMatchOverrides)) {
            return false;
        }
        String this$startMethodPattern = this.getStartMethodPattern();
        String other$startMethodPattern = other.getStartMethodPattern();
        if (this$startMethodPattern == null ? other$startMethodPattern != null : !this$startMethodPattern.equals(other$startMethodPattern)) {
            return false;
        }
        String this$endMethodPattern = this.getEndMethodPattern();
        String other$endMethodPattern = other.getEndMethodPattern();
        if (this$endMethodPattern == null ? other$endMethodPattern != null : !this$endMethodPattern.equals(other$endMethodPattern)) {
            return false;
        }
        String this$target = this.getTarget();
        String other$target = other.getTarget();
        if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
            return false;
        }
        String this$flow = this.getFlow();
        String other$flow = other.getFlow();
        return !(this$flow == null ? other$flow != null : !this$flow.equals(other$flow));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof FindFlowBetweenMethods;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $startMatchOverrides = this.getStartMatchOverrides();
        result = result * 59 + ($startMatchOverrides == null ? 43 : ((Object)$startMatchOverrides).hashCode());
        Boolean $endMatchOverrides = this.getEndMatchOverrides();
        result = result * 59 + ($endMatchOverrides == null ? 43 : ((Object)$endMatchOverrides).hashCode());
        String $startMethodPattern = this.getStartMethodPattern();
        result = result * 59 + ($startMethodPattern == null ? 43 : $startMethodPattern.hashCode());
        String $endMethodPattern = this.getEndMethodPattern();
        result = result * 59 + ($endMethodPattern == null ? 43 : $endMethodPattern.hashCode());
        String $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : $target.hashCode());
        String $flow = this.getFlow();
        result = result * 59 + ($flow == null ? 43 : $flow.hashCode());
        return result;
    }
}

