/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.analysis.controlflow;

import fj.data.Option;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.Incubating;
import org.openrewrite.Tree;
import org.openrewrite.analysis.controlflow.ControlFlowIllegalStateException;
import org.openrewrite.analysis.controlflow.ControlFlowNode;
import org.openrewrite.analysis.controlflow.ControlFlowSummary;
import org.openrewrite.analysis.util.CursorUtil;
import org.openrewrite.internal.SelfLoathing;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.VariableNameUtils;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaCoordinates;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

@Incubating(since="7.25.0")
public final class ControlFlow {
    private static final String CONTROL_FLOW_MESSAGE_KEY = "__CONTROL_FLOW_SUMMARY";
    private @Nullable Cursor start;

    public Option<ControlFlowSummary> findControlFlow() {
        if (this.start == null) {
            return Option.none();
        }
        return (Option)this.start.computeMessageIfAbsent(CONTROL_FLOW_MESSAGE_KEY, __ -> {
            ControlFlowSimpleSummary summary = ControlFlow.findControlFlowInternal(this.start, ControlFlowNode.GraphType.METHOD_BODY_OR_STATIC_INITIALIZER_OR_INSTANCE_INITIALIZER);
            return Option.fromNull((Object)ControlFlowSummary.forGraph(summary.start, summary.end));
        });
    }

    private static ControlFlowSimpleSummary findControlFlowInternal(Cursor start, ControlFlowNode.GraphType graphType) {
        ControlFlowNode.Start startNode = ControlFlowNode.Start.create(graphType);
        ControlFlowAnalysis analysis = new ControlFlowAnalysis(startNode, true);
        analysis.visit((Tree)start.getValue(), 1, start.getParentOrThrow());
        ControlFlowNode.End end = (ControlFlowNode.End)analysis.current.iterator().next();
        return new ControlFlowSimpleSummary(startNode, end);
    }

    public static ControlFlow startingAt(Cursor start) {
        return new ControlFlow((Cursor)CursorUtil.findCallableBlockCursor(start).toNull());
    }

    @Generated
    private ControlFlow(@Nullable Cursor start) {
        this.start = start;
    }

    private static final class ControlFlowSimpleSummary {
        private final ControlFlowNode.Start start;
        private final ControlFlowNode.End end;

        @Generated
        public ControlFlowSimpleSummary(ControlFlowNode.Start start, ControlFlowNode.End end) {
            this.start = start;
            this.end = end;
        }

        @Generated
        public ControlFlowNode.Start getStart() {
            return this.start;
        }

        @Generated
        public ControlFlowNode.End getEnd() {
            return this.end;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ControlFlowSimpleSummary)) {
                return false;
            }
            ControlFlowSimpleSummary other = (ControlFlowSimpleSummary)o;
            ControlFlowNode.Start this$start = this.getStart();
            ControlFlowNode.Start other$start = other.getStart();
            if (this$start == null ? other$start != null : !this$start.equals(other$start)) {
                return false;
            }
            ControlFlowNode.End this$end = this.getEnd();
            ControlFlowNode.End other$end = other.getEnd();
            return !(this$end == null ? other$end != null : !this$end.equals(other$end));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ControlFlowNode.Start $start = this.getStart();
            result = result * 59 + ($start == null ? 43 : $start.hashCode());
            ControlFlowNode.End $end = this.getEnd();
            result = result * 59 + ($end == null ? 43 : $end.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "ControlFlow.ControlFlowSimpleSummary(start=" + this.getStart() + ", end=" + this.getEnd() + ")";
        }
    }

    private static class ControlFlowAnalysis<P>
    extends JavaIsoVisitor<P> {
        protected Set<? extends ControlFlowNode> current;
        private final ControlFlowNode.GraphType graphType;
        private final boolean methodEntryPoint;
        protected final Set<ControlFlowNode> exitFlow = new HashSet<ControlFlowNode>();
        protected final Set<ControlFlowNode> continueFlow = new HashSet<ControlFlowNode>();
        protected final Set<ControlFlowNode> breakFlow = new HashSet<ControlFlowNode>();

        ControlFlowAnalysis(ControlFlowNode.Start start, boolean methodEntryPoint) {
            this.current = Collections.singleton(Objects.requireNonNull(start, "start cannot be null"));
            this.graphType = start.getGraphType();
            this.methodEntryPoint = methodEntryPoint;
        }

        ControlFlowAnalysis(Set<? extends ControlFlowNode> current, ControlFlowNode.GraphType graphType) {
            this.current = Objects.requireNonNull(current, "current cannot be null");
            this.graphType = Objects.requireNonNull(graphType, "graphType cannot be null");
            this.methodEntryPoint = false;
        }

        ControlFlowNode.BasicBlock currentAsBasicBlock() {
            if (this.current.isEmpty()) {
                throw new ControlFlowIllegalStateException(ControlFlowIllegalStateException.exceptionMessageBuilder("No current node!").addCursor(this.getCursor()));
            }
            if (this.current.size() == 1 && this.current.iterator().next() instanceof ControlFlowNode.BasicBlock) {
                return (ControlFlowNode.BasicBlock)this.current.iterator().next();
            }
            return this.addBasicBlockToCurrent();
        }

        ControlFlowNode.BasicBlock newEmptyBasicBlockFromCurrent() {
            ControlFlowNode.BasicBlock currentBasicBlock = this.currentAsBasicBlock();
            if (currentBasicBlock.hasLeader()) {
                return currentBasicBlock.addBasicBlock();
            }
            return currentBasicBlock;
        }

        ControlFlowNode.BasicBlock addBasicBlockToCurrent() {
            HashSet<ControlFlowNode> newCurrent = new HashSet<ControlFlowNode>(this.current);
            ControlFlowNode.BasicBlock basicBlock = ControlFlowAnalysis.addBasicBlock(newCurrent);
            this.current = Collections.singleton(basicBlock);
            return basicBlock;
        }

        <C extends ControlFlowNode> void addSuccessorToCurrent(C node) {
            this.current.forEach(c -> c.addSuccessor(node));
            this.current = Collections.singleton(node);
        }

        void addCursorToBasicBlock() {
            this.currentAsBasicBlock().addCursorToBasicBlock(this.getCursor());
        }

        ControlFlowAnalysis<P> createAnalysisForRecursion(Set<? extends ControlFlowNode> start) {
            return new ControlFlowAnalysis<P>(start, this.graphType);
        }

        ControlFlowAnalysis<P> visitRecursive(Set<? extends ControlFlowNode> start, Tree toVisit, P param) {
            ControlFlowAnalysis<P> analysis = this.createAnalysisForRecursion(start);
            analysis.visit(toVisit, param, this.getCursor());
            return analysis;
        }

        ControlFlowAnalysis<P> visitRecursiveTransferringExit(Set<? extends ControlFlowNode> start, Tree toVisit, P param) {
            ControlFlowAnalysis<P> analysis = this.visitRecursive(start, toVisit, param);
            this.transferExit(analysis);
            return analysis;
        }

        ControlFlowAnalysis<P> visitRecursiveTransferringAll(Set<? extends ControlFlowNode> start, Tree toVisit, P param) {
            ControlFlowAnalysis<P> analysis = this.visitRecursiveTransferringExit(start, toVisit, param);
            this.transferContinueFlow(analysis);
            this.transferBreakFlow(analysis);
            return analysis;
        }

        void transferExit(ControlFlowAnalysis<P> analysis) {
            if (!analysis.exitFlow.isEmpty()) {
                this.exitFlow.addAll(analysis.exitFlow);
            }
        }

        void transferContinueFlow(ControlFlowAnalysis<P> analysis) {
            if (!analysis.continueFlow.isEmpty()) {
                this.continueFlow.addAll(analysis.continueFlow);
            }
        }

        void transferBreakFlow(ControlFlowAnalysis<P> analysis) {
            if (!analysis.breakFlow.isEmpty()) {
                this.breakFlow.addAll(analysis.breakFlow);
            }
        }

        public J.Assignment visitAssignment(J.Assignment assignment, P p) {
            this.addCursorToBasicBlock();
            this.visit((Tree)assignment.getAssignment(), p);
            this.visit((Tree)assignment.getVariable(), p);
            return assignment;
        }

        void visitStatementList(List<Statement> statements, P p) {
            for (Statement statement : statements) {
                ControlFlowAnalysis<P> analysis = this.visitRecursive(this.current, (Tree)statement, p);
                this.current = analysis.current;
                this.continueFlow.addAll(analysis.continueFlow);
                this.breakFlow.addAll(analysis.breakFlow);
                this.exitFlow.addAll(analysis.exitFlow);
                if (!this.current.isEmpty() || !(statement instanceof J.Try)) continue;
                break;
            }
        }

        public J.Block visitBlock(J.Block block, P p) {
            this.addCursorToBasicBlock();
            this.visitStatementList(block.getStatements(), p);
            if (this.methodEntryPoint) {
                ControlFlowNode.End end = ControlFlowNode.End.create(this.graphType);
                this.addSuccessorToCurrent(end);
                this.exitFlow.forEach(exit -> exit.addSuccessor(end));
                this.current = Collections.singleton(end);
            }
            return block;
        }

        public J.Synchronized visitSynchronized(J.Synchronized sync, P p) {
            this.addCursorToBasicBlock();
            this.visit((Tree)sync.getLock(), p);
            this.visit((Tree)sync.getBody(), p);
            return sync;
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, P p) {
            this.visit((Tree)method.getSelect(), p);
            this.visit(method.getArguments(), p);
            this.addCursorToBasicBlock();
            return method;
        }

        public J.NewClass visitNewClass(J.NewClass newClass, P p) {
            this.visit((Tree)newClass.getEnclosing(), p);
            this.visit(newClass.getArguments(), p);
            this.addCursorToBasicBlock();
            return newClass;
        }

        public J.Literal visitLiteral(J.Literal literal, P p) {
            this.addCursorToBasicBlock();
            return literal;
        }

        public <T extends J> J.Parentheses<T> visitParentheses(J.Parentheses<T> parens, P p) {
            this.addCursorToBasicBlock();
            this.visit((Tree)parens.getTree(), p);
            return parens;
        }

        public <T extends J> J.ControlParentheses<T> visitControlParentheses(J.ControlParentheses<T> controlParens, P p) {
            this.addCursorToBasicBlock();
            this.visit((Tree)controlParens.getTree(), p);
            return controlParens;
        }

        public J.TypeCast visitTypeCast(J.TypeCast typeCast, P p) {
            this.visit((Tree)typeCast.getExpression(), p);
            this.addCursorToBasicBlock();
            return typeCast;
        }

        public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, P p) {
            this.visit((Tree)multiVariable.getTypeExpression(), p);
            for (J.VariableDeclarations.NamedVariable variable : multiVariable.getVariables()) {
                this.visit((Tree)variable, p);
            }
            this.addCursorToBasicBlock();
            return multiVariable;
        }

        public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, P p) {
            this.visit((Tree)variable.getInitializer(), p);
            this.visit((Tree)variable.getName(), p);
            this.addCursorToBasicBlock();
            return variable;
        }

        public J.Unary visitUnary(J.Unary unary, P p) {
            if (unary.getOperator() == J.Unary.Type.Not) {
                this.addCursorToBasicBlock();
                this.visit((Tree)unary.getExpression(), p);
                this.current.forEach(controlFlowNode -> {
                    if (controlFlowNode instanceof ControlFlowNode.BasicBlock) {
                        ControlFlowNode.BasicBlock basicBlock = (ControlFlowNode.BasicBlock)controlFlowNode;
                        basicBlock.invertNextConditional();
                    }
                });
            } else {
                this.visit((Tree)unary.getExpression(), p);
                this.addCursorToBasicBlock();
            }
            return unary;
        }

        @SelfLoathing(name="Jonathan Leitschuh")
        public J.Switch visitSwitch(J.Switch _switch, P p) {
            this.addCursorToBasicBlock();
            this.visit((Tree)_switch.getSelector(), p);
            ControlFlowAnalysis analysis = new ControlFlowAnalysis<P>(this.current, this.graphType){
                private final Set<ControlFlowNode> caseFlow;
                {
                    super(current, graphType);
                    this.caseFlow = new HashSet<ControlFlowNode>();
                }

                @Override
                @SelfLoathing(name="Jonathan Leitschuh")
                ControlFlowAnalysis<P> createAnalysisForRecursion(Set<? extends ControlFlowNode> start) {
                    return new ControlFlowAnalysis<P>(start, graphType){

                        @Override
                        public J.Case visitCase(J.Case _case, P p) {
                            if (ControlFlowAnalysis.isDefaultCase(_case)) {
                                this.current = Stream.concat(this.current.stream(), caseFlow.stream()).collect(Collectors.toSet());
                                this.addCursorToBasicBlock();
                                return super.visitCase(_case, p);
                            }
                            this.addCursorToBasicBlock();
                            ControlFlowNode.ConditionNode conditionNode = this.currentAsBasicBlock().addConditionNodeTruthFirst();
                            this.current = Stream.concat(Stream.of(conditionNode), caseFlow.stream()).collect(Collectors.toSet());
                            caseFlow.clear();
                            if (_case.getType() == J.Case.Type.Statement) {
                                if (_case.getStatements().isEmpty()) {
                                    this.visit((Tree)new J.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY), p);
                                } else {
                                    this.visitStatementList(_case.getStatements(), p);
                                }
                            } else if (_case.getType() == J.Case.Type.Rule) {
                                this.visit((Tree)_case.getBody(), p);
                                this.breakFlow.add(this.currentAsBasicBlock());
                                this.current = Collections.emptySet();
                            }
                            caseFlow.addAll(this.current);
                            this.current = Collections.singleton(conditionNode);
                            return _case;
                        }
                    };
                }
            };
            analysis.visit((Tree)_switch.getCases(), p, this.getCursor());
            this.transferContinueFlow(analysis);
            this.transferExit(analysis);
            this.current = Stream.concat(analysis.current.stream(), analysis.breakFlow.stream()).collect(Collectors.toSet());
            return _switch;
        }

        public J.Case visitCase(J.Case _case, P p) {
            if (!ControlFlowAnalysis.isDefaultCase(_case)) {
                throw new ControlFlowIllegalStateException(ControlFlowIllegalStateException.exceptionMessageBuilder("Case statements should be visited by the switch statement").addCursor(this.getCursor()));
            }
            return super.visitCase(_case, p);
        }

        private static Set<ControlFlowNode.ConditionNode> allAsConditionNodesMissingTruthFirst(Set<? extends ControlFlowNode> nodes) {
            return nodes.stream().map(controlFlowNode -> {
                if (controlFlowNode instanceof ControlFlowNode.ConditionNode) {
                    return (ControlFlowNode.ConditionNode)controlFlowNode;
                }
                return controlFlowNode.addConditionNodeTruthFirst();
            }).collect(Collectors.toSet());
        }

        private static Set<ControlFlowNode.ConditionNode> allAsConditionNodesMissingFalseFirst(Set<? extends ControlFlowNode> nodes) {
            return nodes.stream().map(controlFlowNode -> {
                if (controlFlowNode instanceof ControlFlowNode.ConditionNode) {
                    return (ControlFlowNode.ConditionNode)controlFlowNode;
                }
                return controlFlowNode.addConditionNodeFalseFirst();
            }).collect(Collectors.toSet());
        }

        private static ControlFlowNode.ConditionNode getControlFlowNodeMissingOneSuccessor(Set<ControlFlowNode.ConditionNode> nodes) {
            for (ControlFlowNode.ConditionNode node : nodes) {
                if (!(node.getTruthySuccessor() == null ^ node.getFalsySuccessor() == null)) continue;
                return node;
            }
            throw new IllegalArgumentException("No control flow node missing only one successor");
        }

        private void visitBranching(BranchingAdapter branching, P p) {
            this.addCursorToBasicBlock();
            ControlFlowAnalysis<P> conditionAnalysis = this.visitRecursiveTransferringAll(this.current, (Tree)branching.getCondition(), p);
            Set<ControlFlowNode.ConditionNode> conditionNodes = ControlFlowAnalysis.allAsConditionNodesMissingTruthFirst(conditionAnalysis.current);
            ControlFlowAnalysis<P> thenAnalysis = this.visitRecursiveTransferringAll(conditionNodes, (Tree)branching.getTruePart(), p);
            Set<ControlFlowNode.ConditionNode> newCurrent = Collections.singleton(ControlFlowAnalysis.getControlFlowNodeMissingOneSuccessor(conditionNodes));
            if (branching.getFalsePart() != null) {
                ControlFlowAnalysis<P> elseAnalysis = this.visitRecursiveTransferringAll(newCurrent, (Tree)branching.getFalsePart(), p);
                this.current = Stream.concat(thenAnalysis.current.stream(), elseAnalysis.current.stream()).collect(Collectors.toSet());
            } else {
                this.current = Stream.concat(newCurrent.stream(), thenAnalysis.current.stream()).collect(Collectors.toSet());
            }
        }

        public J.Ternary visitTernary(J.Ternary ternary, P p) {
            this.visitBranching(BranchingAdapter.of(ternary), p);
            return ternary;
        }

        public J.If visitIf(J.If iff, P p) {
            this.visitBranching(BranchingAdapter.of(iff), p);
            return iff;
        }

        public J.If.Else visitElse(J.If.Else else_, P p) {
            this.addCursorToBasicBlock();
            this.visit((Tree)else_.getBody(), p);
            return else_;
        }

        public J.Binary visitBinary(J.Binary binary, P p) {
            if (J.Binary.Type.And == binary.getOperator()) {
                ControlFlowAnalysis<P> left = this.visitRecursive(this.current, (Tree)binary.getLeft(), p);
                Set<ControlFlowNode.ConditionNode> conditionNodes = ControlFlowAnalysis.allAsConditionNodesMissingTruthFirst(left.current);
                ControlFlowAnalysis<P> right = this.visitRecursive(conditionNodes, (Tree)binary.getRight(), p);
                this.current = Stream.concat(right.current.stream(), Stream.of(ControlFlowAnalysis.getControlFlowNodeMissingOneSuccessor(conditionNodes))).collect(Collectors.toSet());
            } else if (J.Binary.Type.Or == binary.getOperator()) {
                ControlFlowAnalysis<P> left = this.visitRecursive(this.current, (Tree)binary.getLeft(), p);
                Set<ControlFlowNode.ConditionNode> conditionNodes = ControlFlowAnalysis.allAsConditionNodesMissingFalseFirst(left.current);
                ControlFlowAnalysis<P> right = this.visitRecursive(conditionNodes, (Tree)binary.getRight(), p);
                this.current = Stream.concat(Stream.of(ControlFlowAnalysis.getControlFlowNodeMissingOneSuccessor(conditionNodes)), right.current.stream()).collect(Collectors.toSet());
            } else {
                this.visit((Tree)binary.getLeft(), p);
                this.visit((Tree)binary.getRight(), p);
                this.addCursorToBasicBlock();
            }
            return binary;
        }

        public J.InstanceOf visitInstanceOf(J.InstanceOf instanceOf, P p) {
            this.visit((Tree)instanceOf.getExpression(), p);
            this.addCursorToBasicBlock();
            return instanceOf;
        }

        public J.DoWhileLoop visitDoWhileLoop(J.DoWhileLoop doWhileLoop, P p) {
            this.addCursorToBasicBlock();
            ControlFlowNode.BasicBlock basicBlock = this.newEmptyBasicBlockFromCurrent();
            ControlFlowAnalysis<P> bodyAnalysis = this.visitRecursiveTransferringExit(Collections.singleton(basicBlock), (Tree)doWhileLoop.getBody(), p);
            ControlFlowAnalysis<P> conditionAnalysis = this.visitRecursive(bodyAnalysis.current, (Tree)doWhileLoop.getWhileCondition(), p);
            Set<ControlFlowNode.ConditionNode> conditionNodes = ControlFlowAnalysis.allAsConditionNodesMissingTruthFirst(conditionAnalysis.current);
            conditionNodes.forEach(conditionNode -> {
                conditionNode.addSuccessor(basicBlock);
                bodyAnalysis.continueFlow.forEach(continueNode -> continueNode.addSuccessor(conditionNode));
            });
            this.current = Stream.concat(Stream.of(ControlFlowAnalysis.getControlFlowNodeMissingOneSuccessor(conditionNodes)), bodyAnalysis.breakFlow.stream()).collect(Collectors.toSet());
            return doWhileLoop;
        }

        public J.WhileLoop visitWhileLoop(J.WhileLoop whileLoop, P p) {
            this.addCursorToBasicBlock();
            ControlFlowNode.BasicBlock entryBlock = this.currentAsBasicBlock();
            ControlFlowAnalysis<P> conditionAnalysis = this.visitRecursive(Collections.singleton(entryBlock), (Tree)whileLoop.getCondition(), p);
            Set<ControlFlowNode.ConditionNode> conditionNodes = ControlFlowAnalysis.allAsConditionNodesMissingTruthFirst(conditionAnalysis.current);
            ControlFlowAnalysis<P> bodyAnalysis = this.visitRecursiveTransferringExit(conditionNodes, (Tree)whileLoop.getBody(), p);
            bodyAnalysis.current.forEach(controlFlowNode -> controlFlowNode.addSuccessor(entryBlock.getSuccessor()));
            bodyAnalysis.continueFlow.forEach(controlFlowNode -> controlFlowNode.addSuccessor(entryBlock.getSuccessor()));
            this.current = Stream.concat(Stream.of(ControlFlowAnalysis.getControlFlowNodeMissingOneSuccessor(conditionNodes)), bodyAnalysis.breakFlow.stream()).collect(Collectors.toSet());
            return whileLoop;
        }

        public J.ForLoop visitForLoop(J.ForLoop forLoop, P p) {
            this.addCursorToBasicBlock();
            final ControlFlowNode.BasicBlock[] entryBlock = new ControlFlowNode.BasicBlock[1];
            ControlFlowAnalysis controlAnalysisFirstBit = new ControlFlowAnalysis<P>(this.current, this.graphType){

                public J.ForLoop.Control visitForControl(J.ForLoop.Control control, P p) {
                    this.visit(control.getInit(), p);
                    entryBlock[0] = this.currentAsBasicBlock();
                    Object condition = control.getCondition() instanceof J.Empty ? ControlFlowAnalysis.trueLiteral() : control.getCondition();
                    ControlFlowAnalysis conditionAnalysis = this.visitRecursive(this.current, (Tree)condition, p);
                    this.current = ControlFlowAnalysis.allAsConditionNodesMissingTruthFirst(conditionAnalysis.current);
                    return control;
                }
            };
            controlAnalysisFirstBit.visit((Tree)forLoop.getControl(), p, this.getCursor());
            ControlFlowAnalysis<P> bodyAnalysis = this.visitRecursiveTransferringExit(controlAnalysisFirstBit.current, (Tree)forLoop.getBody(), p);
            ControlFlowAnalysis controlAnalysisSecondBit = new ControlFlowAnalysis<P>(bodyAnalysis.current, this.graphType){

                public J.ForLoop.Control visitForControl(J.ForLoop.Control control, P p) {
                    if (this.current.isEmpty()) {
                        this.current = Collections.singleton(ControlFlowNode.BasicBlock.create());
                    }
                    if (control.getUpdate().isEmpty() || control.getUpdate().get(0) instanceof J.Empty) {
                        this.visit(control.getUpdate(), p);
                        return control;
                    }
                    this.current = Collections.singleton(this.newEmptyBasicBlockFromCurrent());
                    this.visit(control.getUpdate(), p);
                    return control;
                }
            };
            controlAnalysisSecondBit.visit((Tree)forLoop.getControl(), p, this.getCursor());
            bodyAnalysis.continueFlow.forEach(continueControlFlowNode -> continueControlFlowNode.addSuccessor(entryBlock[0].getSuccessor()));
            controlAnalysisSecondBit.current.forEach(controlFlowNode -> controlFlowNode.addSuccessor(entryBlock[0].getSuccessor()));
            this.current = Stream.concat(Stream.of(ControlFlowAnalysis.getControlFlowNodeMissingOneSuccessor(ControlFlowAnalysis.allAsConditionNodesMissingTruthFirst(controlAnalysisFirstBit.current))), bodyAnalysis.breakFlow.stream()).collect(Collectors.toSet());
            return forLoop;
        }

        private static J.Literal trueLiteral() {
            return new J.Literal(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (Object)true, "true", null, JavaType.Primitive.Boolean);
        }

        @SelfLoathing(name="Jonathan Leitschuh")
        public J.ForEachLoop visitForEachLoop(J.ForEachLoop forLoop, P p) {
            if (!(forLoop.getControl().getVariable() instanceof J.VariableDeclarations)) {
                throw new IllegalArgumentException("Expecting the for-each loop control variable to be a J.VariableDeclarations");
            }
            J.VariableDeclarations controlVariables = (J.VariableDeclarations)forLoop.getControl().getVariable();
            String iteratorVariableNumber = VariableNameUtils.generateVariableName((String)(((J.VariableDeclarations.NamedVariable)controlVariables.getVariables().get(0)).getSimpleName() + "Iterator"), (Cursor)this.getCursor(), (VariableNameUtils.GenerationStrategy)VariableNameUtils.GenerationStrategy.INCREMENT_NUMBER);
            JavaType controlLoopType = ((J.VariableDeclarations.NamedVariable)controlVariables.getVariables().get(0)).getType();
            if (controlLoopType == null) {
                throw new ControlFlowIllegalStateException(ControlFlowIllegalStateException.exceptionMessageBuilder("No type for `for` loop control variable").addCursor(this.getCursor()));
            }
            J.VariableDeclarations fakeIteratorAssignment = this.createFakeIteratorVariableDeclarations(iteratorVariableNumber, controlLoopType, forLoop);
            this.visit((Tree)fakeIteratorAssignment, p, this.getCursor());
            this.addCursorToBasicBlock();
            final J.MethodInvocation fakeConditionalMethod = this.createFakeConditionalMethod(((J.VariableDeclarations.NamedVariable)fakeIteratorAssignment.getVariables().get(0)).getName(), new Cursor(new Cursor(this.getCursor(), (Object)forLoop.getControl()), (Object)forLoop.getControl().getIterable()));
            ControlFlowAnalysis controlAnalysis = new ControlFlowAnalysis<P>(this.current, this.graphType){

                public J.ForEachLoop.Control visitForEachControl(J.ForEachLoop.Control control, P p) {
                    this.addCursorToBasicBlock();
                    this.visit((Tree)control.getVariable(), p);
                    this.visit((Tree)fakeConditionalMethod, p);
                    return control;
                }
            };
            controlAnalysis.visit((Tree)forLoop.getControl(), p, this.getCursor());
            ControlFlowNode.ConditionNode conditionalEntry = controlAnalysis.currentAsBasicBlock().addConditionNodeTruthFirst();
            ControlFlowAnalysis<P> bodyAnalysis = this.visitRecursiveTransferringExit(Collections.singleton(conditionalEntry), (Tree)forLoop.getBody(), p);
            bodyAnalysis.continueFlow.forEach(continueFlowNode -> continueFlowNode.addSuccessor(conditionalEntry));
            bodyAnalysis.current.forEach(controlFlowNode -> controlFlowNode.addSuccessor(conditionalEntry));
            this.current = Stream.concat(Stream.of(conditionalEntry), bodyAnalysis.breakFlow.stream()).collect(Collectors.toSet());
            return forLoop;
        }

        @SelfLoathing(name="Jonathan Leitschuh")
        private J.VariableDeclarations createFakeIteratorVariableDeclarations(String variableName, JavaType iteratorType, J.ForEachLoop forLoop) {
            Expression iterable = forLoop.getControl().getIterable();
            String type = TypeUtils.toString((JavaType)iteratorType);
            JavaTemplate fakeIterableVariableTemplate = iterable.getType() instanceof JavaType.Array ? JavaTemplate.builder((String)("final Iterator<" + type + "> " + variableName + " = Arrays.stream(#{anyArray()}).iterator();")).imports(new String[]{"java.util.Arrays"}).build() : JavaTemplate.builder((String)("final Iterator<" + type + "> " + variableName + " = #{any(java.lang.Iterable)}.iterator();")).build();
            J.Block block = (J.Block)this.getCursor().firstEnclosing(J.Block.class);
            if (block == null) {
                throw new ControlFlowIllegalStateException(ControlFlowIllegalStateException.exceptionMessageBuilder("Unable to create new J.VariableDeclarations, couldn't find an outer J.Block").addCursor(this.getCursor()));
            }
            J.Label maybeParentLabel = (J.Label)this.getCursor().firstEnclosing(J.Label.class);
            JavaCoordinates coordinates = maybeParentLabel != null && maybeParentLabel.getStatement() == forLoop ? maybeParentLabel.getCoordinates().before() : forLoop.getCoordinates().before();
            Cursor blockCursor = this.getCursor().dropParentUntil(J.Block.class::isInstance);
            J.Block newFakeBlock = (J.Block)fakeIterableVariableTemplate.apply(blockCursor, coordinates, new Object[]{iterable});
            for (Statement statement : newFakeBlock.getStatements()) {
                J.VariableDeclarations maybeNewDeclaration;
                if (!(statement instanceof J.VariableDeclarations) || !(maybeNewDeclaration = (J.VariableDeclarations)statement).getVariables().stream().map(J.VariableDeclarations.NamedVariable::getSimpleName).anyMatch(name -> name.equals(variableName))) continue;
                return maybeNewDeclaration;
            }
            throw new ControlFlowIllegalStateException(ControlFlowIllegalStateException.exceptionMessageBuilder("Unable to create new J.VariableDeclarations with name `" + variableName + "`").addCursor(this.getCursor()));
        }

        @SelfLoathing(name="Jonathan Leitschuh")
        protected J.MethodInvocation createFakeConditionalMethod(J.Identifier iteratorIdentifier, Cursor iterableCursor) {
            JavaTemplate fakeConditionalTemplate = JavaTemplate.builder((String)"#{any(java.util.Iterator)}.hasNext()").build();
            JavaCoordinates coordinates = ((Expression)iterableCursor.getValue()).getCoordinates().replace();
            J.MethodInvocation fakeConditional = (J.MethodInvocation)fakeConditionalTemplate.apply(iterableCursor, coordinates, new Object[]{iteratorIdentifier});
            if (iterableCursor.getValue() == fakeConditional) {
                throw new IllegalStateException("Failed to create a fake conditional!");
            }
            return fakeConditional;
        }

        public J.Identifier visitIdentifier(J.Identifier identifier, P p) {
            this.addCursorToBasicBlock();
            return identifier;
        }

        public J.Assert visitAssert(J.Assert _assert, P p) {
            this.visit((Tree)_assert.getCondition(), p);
            if (_assert.getDetail() != null) {
                this.visit((Tree)_assert.getDetail().getElement(), p);
            }
            this.addCursorToBasicBlock();
            return _assert;
        }

        public J.ArrayAccess visitArrayAccess(J.ArrayAccess arrayAccess, P p) {
            this.addCursorToBasicBlock();
            return arrayAccess;
        }

        public J.Try visitTry(J.Try _try, P p) {
            this.addCursorToBasicBlock();
            this.visit(_try.getResources(), p);
            if (_try.getFinally() == null) {
                this.visit((Tree)_try.getBody(), p);
            } else {
                ControlFlowAnalysis<P> tryBodyAnalysis = new ControlFlowAnalysis<P>(this.current, this.graphType);
                tryBodyAnalysis.visit((Tree)_try.getBody(), p, this.getCursor());
                if (!tryBodyAnalysis.current.isEmpty()) {
                    ControlFlowAnalysis<P> finallyAnalysisFromCurrent = this.visitRecursiveTransferringAll(tryBodyAnalysis.current, (Tree)_try.getFinally(), p);
                    this.current = finallyAnalysisFromCurrent.current;
                } else {
                    this.current = Collections.emptySet();
                }
                if (!tryBodyAnalysis.exitFlow.isEmpty()) {
                    ControlFlowAnalysis<P> finallyAnalysisFromExitFlow = this.visitRecursiveTransferringAll(tryBodyAnalysis.exitFlow, (Tree)_try.getFinally(), p);
                    this.exitFlow.addAll(finallyAnalysisFromExitFlow.current);
                }
                if (!tryBodyAnalysis.breakFlow.isEmpty()) {
                    ControlFlowAnalysis<P> finallyAnalysisFromBreakFlow = this.visitRecursiveTransferringAll(tryBodyAnalysis.breakFlow, (Tree)_try.getFinally(), p);
                    this.breakFlow.addAll(finallyAnalysisFromBreakFlow.current);
                }
                if (!tryBodyAnalysis.continueFlow.isEmpty()) {
                    ControlFlowAnalysis<P> finallyAnalysisFromContinueFlow = this.visitRecursiveTransferringAll(tryBodyAnalysis.continueFlow, (Tree)_try.getFinally(), p);
                    this.continueFlow.addAll(finallyAnalysisFromContinueFlow.current);
                }
            }
            return _try;
        }

        public J.Try.Resource visitTryResource(J.Try.Resource tryResource, P p) {
            this.visit((Tree)tryResource.getVariableDeclarations(), p);
            return tryResource;
        }

        public J.Lambda visitLambda(J.Lambda lambda, P p) {
            this.addCursorToBasicBlock();
            if (lambda.getBody() instanceof J.Block) {
                ControlFlowSimpleSummary summary = ControlFlow.findControlFlowInternal(new Cursor(this.getCursor(), (Object)lambda.getBody()), ControlFlowNode.GraphType.LAMBDA);
                this.currentAsBasicBlock().addSuccessor(summary.start);
                this.current = Collections.singleton(summary.end);
                return lambda;
            }
            return super.visitLambda(lambda, p);
        }

        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, P p) {
            this.addCursorToBasicBlock();
            return classDecl;
        }

        public J.Empty visitEmpty(J.Empty empty, P p) {
            J.MethodInvocation parent = (J.MethodInvocation)this.getCursor().firstEnclosing(J.MethodInvocation.class);
            if (parent != null && parent.getArguments().contains(empty)) {
                return empty;
            }
            this.addCursorToBasicBlock();
            return super.visitEmpty(empty, p);
        }

        public J.Return visitReturn(J.Return _return, P p) {
            this.visit((Tree)_return.getExpression(), p);
            this.addCursorToBasicBlock();
            this.exitFlow.addAll(this.current);
            this.current = Collections.emptySet();
            return _return;
        }

        public J.Throw visitThrow(J.Throw thrown, P p) {
            this.visit((Tree)thrown.getException(), p);
            this.addCursorToBasicBlock();
            this.exitFlow.addAll(this.current);
            this.current = Collections.emptySet();
            return thrown;
        }

        public J.Continue visitContinue(J.Continue continueStatement, P p) {
            this.addCursorToBasicBlock();
            this.continueFlow.add(this.currentAsBasicBlock());
            this.current = Collections.emptySet();
            return continueStatement;
        }

        public J.Break visitBreak(J.Break breakStatement, P p) {
            this.addCursorToBasicBlock();
            this.breakFlow.add(this.currentAsBasicBlock());
            this.current = Collections.emptySet();
            return breakStatement;
        }

        private static ControlFlowNode.BasicBlock addBasicBlock(Collection<ControlFlowNode> nodes) {
            if (nodes.isEmpty()) {
                throw new IllegalStateException("No nodes to add to a basic block!");
            }
            Iterator<ControlFlowNode> cfnIterator = nodes.iterator();
            ControlFlowNode.BasicBlock basicBlock = cfnIterator.next().addBasicBlock();
            while (cfnIterator.hasNext()) {
                cfnIterator.next().addSuccessor(basicBlock);
            }
            return basicBlock;
        }

        private static boolean isDefaultCase(J.Case _case) {
            List expressions = _case.getCaseLabels();
            return expressions.size() == 1 && expressions.get(0) instanceof J.Identifier && "default".equals(((J.Identifier)expressions.get(0)).getSimpleName());
        }

        private static interface BranchingAdapter {
            public Expression getCondition();

            public J getTruePart();

            public @Nullable J getFalsePart();

            public static BranchingAdapter of(final J.If ifStatement) {
                return new BranchingAdapter(){

                    @Override
                    public Expression getCondition() {
                        return ifStatement.getIfCondition();
                    }

                    @Override
                    public J getTruePart() {
                        return ifStatement.getThenPart();
                    }

                    @Override
                    public @Nullable J getFalsePart() {
                        return ifStatement.getElsePart();
                    }
                };
            }

            public static BranchingAdapter of(final J.Ternary ternary) {
                return new BranchingAdapter(){

                    @Override
                    public Expression getCondition() {
                        return ternary.getCondition();
                    }

                    @Override
                    public J getTruePart() {
                        return ternary.getTruePart();
                    }

                    @Override
                    public J getFalsePart() {
                        return ternary.getFalsePart();
                    }
                };
            }
        }
    }
}

