/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.analysis.controlflow;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.Cursor;
import org.openrewrite.Incubating;
import org.openrewrite.Tree;
import org.openrewrite.analysis.controlflow.BarrierGuardPredicate;
import org.openrewrite.analysis.controlflow.ControlFlowIllegalStateException;
import org.openrewrite.analysis.controlflow.ControlFlowJavaPrinter;
import org.openrewrite.analysis.controlflow.Guard;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

@Incubating(since="7.25.0")
public abstract class ControlFlowNode {
    final Set<ControlFlowNode> predecessors = Collections.newSetFromMap(new IdentityHashMap());
    private static final ThreadLocal<AtomicInteger> recursionCounter = ThreadLocal.withInitial(() -> new AtomicInteger(0));

    abstract Set<ControlFlowNode> getSuccessors();

    protected abstract void _addSuccessorInternal(ControlFlowNode var1);

    Set<ControlFlowNode> getPredecessors() {
        return Collections.unmodifiableSet(this.predecessors);
    }

    <C extends ControlFlowNode> C addSuccessor(C successor) {
        Objects.requireNonNull(successor, "successor must not be null");
        if (this == successor) {
            throw new ControlFlowIllegalStateException("Cannot add a node as a successor of itself", this);
        }
        this._addSuccessorInternal(successor);
        successor.predecessors.add(this);
        return successor;
    }

    BasicBlock addBasicBlock() {
        return this.addSuccessor(BasicBlock.create());
    }

    ConditionNode addConditionNodeTruthFirst() {
        throw new ControlFlowIllegalStateException("Can only add a condition node to a basic block", this);
    }

    ConditionNode addConditionNodeFalseFirst() {
        throw new ControlFlowIllegalStateException("Can only add a condition node to a basic block", this);
    }

    String toDescriptiveString() {
        if (recursionCounter.get().incrementAndGet() > 2) {
            recursionCounter.get().set(0);
            return "...";
        }
        try {
            String value = this.internalToDescriptiveString();
            recursionCounter.get().set(0);
            return value;
        }
        catch (RuntimeException e) {
            recursionCounter.get().set(0);
            return this.toString();
        }
    }

    abstract String internalToDescriptiveString();

    abstract String toVisualizerString();

    private ControlFlowNode() {
    }

    static final class BasicBlock
    extends ControlFlowNode {
        private ControlFlowNode successor;
        private final List<Cursor> node = new ArrayList<Cursor>();
        private boolean nextConditionDefault = true;

        public J getLeader() {
            if (this.node.isEmpty()) {
                throw new ControlFlowIllegalStateException(ControlFlowIllegalStateException.exceptionMessageBuilder("Basic block has no nodes!").addPredecessors(this));
            }
            return (J)this.node.get(0).getValue();
        }

        boolean hasLeader() {
            return !this.node.isEmpty();
        }

        public List<Cursor> getNodeCursors() {
            return Collections.unmodifiableList(this.node);
        }

        String getStatementsWithinBlock() {
            ControlFlowJavaPrinter.ControlFlowPrintOutputCapture<Integer> capture = new ControlFlowJavaPrinter.ControlFlowPrintOutputCapture<Integer>(0);
            List<J> nodeValuesExpanded = this.getNodeValues().stream().flatMap(v -> {
                J.Case caseStatement;
                if (v instanceof J.Case && (caseStatement = (J.Case)v).getExpressions().size() == 1 && caseStatement.getExpressions().get(0) instanceof J.Literal) {
                    return Stream.of(v, (J)caseStatement.getExpressions().get(0));
                }
                return Stream.of(v);
            }).collect(Collectors.toList());
            ControlFlowJavaPrinter printer = new ControlFlowJavaPrinter(nodeValuesExpanded);
            Cursor commonBlock = this.getCommonBlock();
            printer.visit((Tree)commonBlock.getValue(), capture, commonBlock.getParentOrThrow());
            return StringUtils.trimIndentPreserveCRLF((String)capture.getOut()).replaceAll("(?m)^[ \t]*\r?\n", "");
        }

        Cursor getCommonBlock() {
            List shortestList = this.node.stream().map(BasicBlock::computeBlockList).min(Comparator.comparingInt(List::size)).orElseThrow(() -> new ControlFlowIllegalStateException(ControlFlowIllegalStateException.exceptionMessageBuilder("Could not find common block for basic block").thisNode(this)));
            if (shortestList.isEmpty()) {
                throw new ControlFlowIllegalStateException(ControlFlowIllegalStateException.exceptionMessageBuilder("Could not find common block for basic block").thisNode(this));
            }
            return (Cursor)shortestList.get(shortestList.size() - 1);
        }

        private List<J> getNodeValues() {
            return this.node.stream().map(Cursor::getValue).collect(Collectors.toList());
        }

        void addCursorToBasicBlock(Cursor expression) {
            this.node.add(expression);
        }

        void invertNextConditional() {
            this.nextConditionDefault = !this.nextConditionDefault;
        }

        @Override
        ConditionNode addConditionNodeTruthFirst() {
            if (this.node.isEmpty()) {
                throw new ControlFlowIllegalStateException(ControlFlowIllegalStateException.exceptionMessageBuilder("Cannot add condition node to empty basic block").addPredecessors(this));
            }
            return this.addSuccessor(ConditionNode.create(this.node.get(this.node.size() - 1), this.nextConditionDefault));
        }

        @Override
        ConditionNode addConditionNodeFalseFirst() {
            if (this.node.isEmpty()) {
                throw new ControlFlowIllegalStateException(ControlFlowIllegalStateException.exceptionMessageBuilder("Cannot add condition node to empty basic block").addPredecessors(this));
            }
            return this.addSuccessor(ConditionNode.create(this.node.get(this.node.size() - 1), !this.nextConditionDefault));
        }

        @Override
        protected void _addSuccessorInternal(ControlFlowNode successor) {
            if (this.successor == successor) {
                return;
            }
            if (this.successor != null) {
                throw new ControlFlowIllegalStateException(ControlFlowIllegalStateException.exceptionMessageBuilder("Basic block already has a successor").thisNode(this).current(this.successor).otherNode(successor));
            }
            this.successor = successor;
        }

        @Override
        Set<ControlFlowNode> getSuccessors() {
            if (this.successor == null) {
                throw new ControlFlowIllegalStateException(ControlFlowIllegalStateException.exceptionMessageBuilder("Basic block has no successor").thisNode(this));
            }
            return Collections.singleton(this.successor);
        }

        @Override
        String toVisualizerString() {
            return this.getStatementsWithinBlock();
        }

        @Override
        String internalToDescriptiveString() {
            String statementsWithinBlock = this.getStatementsWithinBlock();
            if (statementsWithinBlock.contains("\n")) {
                return "BasicBlock { contents=```\n" + statementsWithinBlock + "\n``` }";
            }
            return "BasicBlock { contents=`" + statementsWithinBlock + "` }";
        }

        public String toString() {
            if (this.node.isEmpty()) {
                return "BasicBlock { No leader yet! }";
            }
            return "BasicBlock { leader=" + this.getLeader() + " }";
        }

        private static List<Cursor> computeBlockList(Cursor cursor) {
            ArrayList<Cursor> blocks = new ArrayList<Cursor>();
            cursor.getPathAsCursors(c -> c.getValue() instanceof J.Block).forEachRemaining(blocks::add);
            Collections.reverse(blocks);
            return blocks;
        }

        private BasicBlock() {
        }

        @NonNull
        static BasicBlock create() {
            return new BasicBlock();
        }

        public ControlFlowNode getSuccessor() {
            return this.successor;
        }
    }

    static enum GraphType {
        METHOD_BODY_OR_STATIC_INITIALIZER_OR_INSTANCE_INITIALIZER,
        LAMBDA;

    }

    static interface GraphTerminator {
        public GraphType getGraphType();
    }

    static final class End
    extends ControlFlowNode
    implements GraphTerminator {
        private final GraphType graphType;
        private ControlFlowNode successor;

        @Override
        Set<ControlFlowNode> getSuccessors() {
            if (GraphType.LAMBDA.equals((Object)this.graphType)) {
                if (this.successor == null) {
                    throw new ControlFlowIllegalStateException(ControlFlowIllegalStateException.exceptionMessageBuilder("Lambda End node has no successor").thisNode(this).addPredecessors(this));
                }
                return Collections.singleton(this.successor);
            }
            return Collections.emptySet();
        }

        @Override
        protected void _addSuccessorInternal(ControlFlowNode successor) {
            if (GraphType.LAMBDA.equals((Object)this.graphType)) {
                if (this.successor != null) {
                    throw new ControlFlowIllegalStateException(ControlFlowIllegalStateException.exceptionMessageBuilder("Lambda End node already has a successor").thisNode(this).current(this.successor).otherNode(successor));
                }
            } else {
                throw new ControlFlowIllegalStateException(ControlFlowIllegalStateException.exceptionMessageBuilder("End nodes cannot have successors").otherNode(successor));
            }
            this.successor = successor;
        }

        @Override
        String internalToDescriptiveString() {
            return this + " { predecessors=" + this.getPredecessors().size() + " }";
        }

        @Override
        String toVisualizerString() {
            return this.toString();
        }

        public String toString() {
            switch (this.graphType) {
                case METHOD_BODY_OR_STATIC_INITIALIZER_OR_INSTANCE_INITIALIZER: {
                    return "End";
                }
                case LAMBDA: {
                    return "Lambda End";
                }
            }
            throw new ControlFlowIllegalStateException(ControlFlowIllegalStateException.exceptionMessageBuilder("Unknown graph type: " + (Object)((Object)this.graphType)));
        }

        private End(GraphType graphType) {
            this.graphType = graphType;
        }

        @NonNull
        static End create(GraphType graphType) {
            return new End(graphType);
        }

        @Override
        public GraphType getGraphType() {
            return this.graphType;
        }
    }

    static final class Start
    extends ControlFlowNode
    implements GraphTerminator {
        private final GraphType graphType;
        private ControlFlowNode successor;

        @Override
        protected void _addSuccessorInternal(ControlFlowNode successor) {
            if (this.successor != null) {
                throw new ControlFlowIllegalStateException(ControlFlowIllegalStateException.exceptionMessageBuilder("Start node already has a successor").current(this.successor).otherNode(successor));
            }
            this.successor = successor;
        }

        @Override
        Set<ControlFlowNode> getSuccessors() {
            return Collections.singleton(this.successor);
        }

        @Override
        String internalToDescriptiveString() {
            if (this.successor == null) {
                return this + " { No successor yet! }";
            }
            return this + " { successor=" + this.successor.toDescriptiveString() + " }";
        }

        @Override
        String toVisualizerString() {
            return this.toString();
        }

        public String toString() {
            switch (this.graphType) {
                case METHOD_BODY_OR_STATIC_INITIALIZER_OR_INSTANCE_INITIALIZER: {
                    return "Start";
                }
                case LAMBDA: {
                    return "Lambda Start";
                }
            }
            throw new ControlFlowIllegalStateException(ControlFlowIllegalStateException.exceptionMessageBuilder("Unknown graph type: " + (Object)((Object)this.graphType)));
        }

        private Start(GraphType graphType) {
            this.graphType = graphType;
        }

        @NonNull
        static Start create(GraphType graphType) {
            return new Start(graphType);
        }

        @Override
        public GraphType getGraphType() {
            return this.graphType;
        }
    }

    static final class ConditionNode
    extends ControlFlowNode {
        private final Guard guard;
        private final boolean truthFirst;
        private ControlFlowNode truthySuccessor;
        private ControlFlowNode falsySuccessor;

        private ConditionNode(Guard guard, boolean truthFirst) {
            this.guard = guard;
            this.truthFirst = truthFirst;
        }

        public J getCondition() {
            return (J)this.guard.getCursor().getValue();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected void _addSuccessorInternal(ControlFlowNode successor) {
            if (this.truthFirst) {
                if (this.truthySuccessor == null) {
                    this.truthySuccessor = successor;
                    return;
                } else {
                    if (this.falsySuccessor != null) throw new ControlFlowIllegalStateException("Condition node already has both successors", this);
                    this.falsySuccessor = successor;
                }
                return;
            } else if (this.falsySuccessor == null) {
                this.falsySuccessor = successor;
                return;
            } else {
                if (this.truthySuccessor != null) throw new ControlFlowIllegalStateException("Condition node already has both successors", this);
                this.truthySuccessor = successor;
            }
        }

        private Optional<Boolean> asBooleanLiteralValue() {
            J.Literal literal;
            if (this.getCondition() instanceof J.Literal && TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Boolean, (JavaType)(literal = (J.Literal)this.getCondition()).getType())) {
                Boolean value = (Boolean)literal.getValue();
                return Optional.ofNullable(value);
            }
            return Optional.empty();
        }

        boolean isAlwaysTrue() {
            return this.asBooleanLiteralValue().orElse(false);
        }

        boolean isAlwaysFalse() {
            return this.asBooleanLiteralValue().map(b -> b == false).orElse(false);
        }

        @Override
        Set<ControlFlowNode> getSuccessors() {
            this.verifyState();
            if (this.isAlwaysTrue()) {
                return Collections.singleton(this.truthySuccessor);
            }
            if (this.isAlwaysFalse()) {
                return Collections.singleton(this.falsySuccessor);
            }
            return Stream.of(this.truthySuccessor, this.falsySuccessor).collect(Collectors.toSet());
        }

        private void verifyState() {
            if (this.truthySuccessor == null && this.falsySuccessor == null) {
                throw new ControlFlowIllegalStateException("Condition node has no successors. Should have both!", this);
            }
            if (this.truthySuccessor == null) {
                throw new ControlFlowIllegalStateException("Condition node has no truthy successor", this);
            }
            if (this.falsySuccessor == null) {
                throw new ControlFlowIllegalStateException("Condition node has no falsy successor", this);
            }
        }

        Set<ControlFlowNode> visit(BarrierGuardPredicate isBarrierGuard) {
            this.verifyState();
            HashSet<ControlFlowNode> nodes = new HashSet<ControlFlowNode>(2);
            if (this.isAlwaysTrue()) {
                nodes.add(this.truthySuccessor);
            } else if (this.isAlwaysFalse()) {
                nodes.add(this.falsySuccessor);
            } else {
                if (!isBarrierGuard.isBarrierGuard(this.asGuard(), true)) {
                    nodes.add(this.getTruthySuccessor());
                }
                if (!isBarrierGuard.isBarrierGuard(this.asGuard(), false)) {
                    nodes.add(this.getFalsySuccessor());
                }
            }
            return nodes;
        }

        Guard asGuard() {
            return this.guard;
        }

        @Override
        String internalToDescriptiveString() {
            String truthyDescriptive = null;
            if (this.truthySuccessor != null) {
                truthyDescriptive = this.truthySuccessor.internalToDescriptiveString();
            }
            String falsyDescriptive = null;
            if (this.falsySuccessor != null) {
                falsyDescriptive = this.falsySuccessor.internalToDescriptiveString();
            }
            return "ConditionNode{condition=" + this.getCondition() + ", truthySuccessor=" + truthyDescriptive + ", falsySuccessor=" + falsyDescriptive + '}';
        }

        @Override
        String toVisualizerString() {
            J.Literal literal;
            J condition = this.getCondition();
            if (condition instanceof J.Literal && (literal = (J.Literal)condition).getValue() instanceof Boolean) {
                return literal.getValue().toString();
            }
            if (condition instanceof J.Case) {
                J.Case caseStatement = (J.Case)condition;
                String caseString = caseStatement.toString();
                if (caseStatement.getType() == J.Case.Type.Statement) {
                    return caseString.substring(0, caseString.indexOf(":") + 1);
                }
                if (caseStatement.getType() == J.Case.Type.Rule) {
                    return caseString.substring(0, caseString.indexOf("->") + 2);
                }
            }
            return condition.toString();
        }

        public String toString() {
            return "ConditionNode{condition=" + this.getCondition() + ", truthySuccessor=" + this.truthySuccessor + ", falsySuccessor=" + this.falsySuccessor + '}';
        }

        private static ConditionNode create(Cursor cursor, boolean truthFirst) {
            return Guard.from(cursor).map(guard -> new ConditionNode((Guard)guard, truthFirst)).orElseThrow(() -> new ControlFlowIllegalStateException(ControlFlowIllegalStateException.exceptionMessageBuilder("Condition Node is not a guard!").addCursor(cursor)));
        }

        public ControlFlowNode getTruthySuccessor() {
            return this.truthySuccessor;
        }

        public ControlFlowNode getFalsySuccessor() {
            return this.falsySuccessor;
        }
    }
}

