/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.analysis.controlflow;

import java.util.Optional;
import java.util.function.Function;
import org.openrewrite.Cursor;
import org.openrewrite.Incubating;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Loop;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;

@Incubating(since="7.25.0")
public final class Guard {
    private final Cursor cursor;
    @Nullable
    private final Expression expression;
    @Nullable
    private final J.Case theCase;

    private Guard(Cursor cursor, @Nullable Expression expression, @Nullable J.Case theCase) {
        if (expression == null && theCase == null) {
            throw new IllegalArgumentException("Guard must have either an expression or a case");
        }
        this.cursor = cursor;
        this.expression = expression;
        this.theCase = theCase;
    }

    public <T> T map(Function<Expression, T> whenExpression, Function<J.Case, T> whenCase) {
        if (this.expression != null) {
            return whenExpression.apply(this.expression);
        }
        return whenCase.apply(this.theCase);
    }

    public static Optional<Guard> from(Cursor cursor) {
        if (cursor.getValue() instanceof J.Case) {
            J.Case theCase = (J.Case)cursor.getValue();
            return Optional.of(new Guard(cursor, null, theCase));
        }
        if (!(cursor.getValue() instanceof Expression)) {
            return Optional.empty();
        }
        Expression e = (Expression)cursor.getValue();
        if (e instanceof J.ControlParentheses && Guard.getControlParenthesesFromParent(cursor).map(c -> c == e).orElse(false).booleanValue()) {
            return Optional.empty();
        }
        return Guard.getTypeSafe(cursor, e).map(type -> {
            if (TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Boolean, (JavaType)type)) {
                return new Guard(cursor, e, null);
            }
            return null;
        });
    }

    private static Optional<J.ControlParentheses<?>> getControlParenthesesFromParent(Cursor cursor) {
        Statement parent = (Statement)cursor.dropParentUntil(v -> v instanceof J.If || v instanceof Loop || v instanceof J.Block).getValue();
        Object parentControlParentheses = parent instanceof J.If ? ((J.If)parent).getIfCondition() : (parent instanceof J.WhileLoop ? ((J.WhileLoop)parent).getCondition() : (parent instanceof J.DoWhileLoop ? ((J.DoWhileLoop)parent).getWhileCondition() : null));
        return Optional.ofNullable(parentControlParentheses);
    }

    @Deprecated
    private static boolean isGuardType(Expression e) {
        return e instanceof J.MethodInvocation || e instanceof J.FieldAccess || e instanceof J.ArrayAccess || e instanceof J.TypeCast || e instanceof J.InstanceOf || e instanceof J.Binary || e instanceof J.Parentheses || e instanceof J.ControlParentheses || e instanceof J.Assignment || e instanceof J.AssignmentOperation || e instanceof J.Ternary || e instanceof J.Unary && ((J.Unary)e).getOperator() == J.Unary.Type.Not;
    }

    private static Optional<JavaType> getTypeSafe(Cursor c, Expression e) {
        J.ForLoop.Control control;
        JavaType type = e.getType();
        if (type != null && !JavaType.Unknown.getInstance().equals(type)) {
            return Optional.of(type);
        }
        if (e instanceof J.Binary) {
            J.Binary binary = (J.Binary)e;
            switch (binary.getOperator()) {
                case And: 
                case Or: 
                case Equal: 
                case NotEqual: 
                case LessThan: 
                case LessThanOrEqual: 
                case GreaterThan: 
                case GreaterThanOrEqual: {
                    return Optional.of(JavaType.Primitive.Boolean);
                }
            }
        } else {
            J.MethodInvocation methodInvocation;
            J.Unary unary;
            if (e instanceof J.InstanceOf) {
                return Optional.of(JavaType.Primitive.Boolean);
            }
            if (e instanceof J.Unary ? (unary = (J.Unary)e).getOperator() == J.Unary.Type.Not : e instanceof J.MethodInvocation && "equals".equals((methodInvocation = (J.MethodInvocation)e).getSimpleName())) {
                return Optional.of(JavaType.Primitive.Boolean);
            }
        }
        J firstEnclosing = (J)c.getParentOrThrow().firstEnclosing(J.class);
        if (firstEnclosing instanceof J.Binary) {
            J.Binary binary = (J.Binary)firstEnclosing;
            if (binary.getLeft() == e || binary.getRight() == e) {
                switch (binary.getOperator()) {
                    case And: 
                    case Or: {
                        return Optional.of(JavaType.Primitive.Boolean);
                    }
                }
            }
        } else if (firstEnclosing instanceof J.Unary) {
            J.Unary unary = (J.Unary)firstEnclosing;
            if (unary.getExpression() == e && unary.getOperator() == J.Unary.Type.Not) {
                return Optional.of(JavaType.Primitive.Boolean);
            }
        } else if (firstEnclosing instanceof J.Ternary) {
            J.Ternary ternary = (J.Ternary)firstEnclosing;
            if (ternary.getCondition() == e) {
                return Optional.of(JavaType.Primitive.Boolean);
            }
        } else if (firstEnclosing instanceof J.ControlParentheses) {
            J.ControlParentheses controlParentheses = (J.ControlParentheses)firstEnclosing;
            if (controlParentheses.getTree() == e) {
                if (Optional.ofNullable((J.If)c.getParentOrThrow().firstEnclosing(J.If.class)).map(J.If::getIfCondition).map(condition -> condition == controlParentheses).orElse(false).booleanValue() || Optional.ofNullable((J.WhileLoop)c.getParentOrThrow().firstEnclosing(J.WhileLoop.class)).map(J.WhileLoop::getCondition).map(condition -> condition == controlParentheses).orElse(false).booleanValue() || Optional.ofNullable((J.DoWhileLoop)c.getParentOrThrow().firstEnclosing(J.DoWhileLoop.class)).map(J.DoWhileLoop::getWhileCondition).map(condition -> condition == controlParentheses).orElse(false).booleanValue()) {
                    return Optional.of(JavaType.Primitive.Boolean);
                }
                Cursor parent = c.getParentTreeCursor();
                return Guard.getTypeSafe(parent, (Expression)parent.getValue());
            }
        } else if (firstEnclosing instanceof J.Parentheses) {
            J.Parentheses parentheses = (J.Parentheses)firstEnclosing;
            if (parentheses.getTree() == e) {
                Cursor parent = c.getParentTreeCursor();
                return Guard.getTypeSafe(parent, (Expression)parent.getValue());
            }
        } else if (firstEnclosing instanceof J.VariableDeclarations.NamedVariable) {
            J.VariableDeclarations.NamedVariable namedVariable = (J.VariableDeclarations.NamedVariable)firstEnclosing;
            if (namedVariable.getInitializer() == e) {
                return Optional.ofNullable(namedVariable.getType());
            }
        } else if (firstEnclosing instanceof J.Assignment) {
            J.Assignment assignment = (J.Assignment)firstEnclosing;
            if (assignment.getAssignment() == e) {
                return Optional.ofNullable(assignment.getType());
            }
        } else if (firstEnclosing instanceof J.ForLoop.Control && (control = (J.ForLoop.Control)firstEnclosing).getCondition() == e) {
            return Optional.of(JavaType.Primitive.Boolean);
        }
        return Optional.empty();
    }

    Cursor getCursor() {
        return this.cursor;
    }

    @Nullable
    public Expression getExpression() {
        return this.expression;
    }

    @Nullable
    public J.Case getTheCase() {
        return this.theCase;
    }
}

