/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.analysis.dataflow;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.Incubating;
import org.openrewrite.Tree;
import org.openrewrite.analysis.dataflow.DataFlowSpec;
import org.openrewrite.analysis.dataflow.Dataflow;
import org.openrewrite.analysis.dataflow.analysis.SinkFlowSummary;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.marker.SearchResult;

@Incubating(since="7.24.0")
public class FindLocalFlowPaths<P>
extends JavaIsoVisitor<P> {
    private static final String FLOW_GRAPHS = "flowGraphs";
    private final DataFlowSpec spec;

    @Nullable
    public J visit(@Nullable Tree tree, P p) {
        if (tree instanceof JavaSourceFile) {
            this.getCursor().putMessage(FLOW_GRAPHS, new ArrayList());
            JavaSourceFile c = (JavaSourceFile)super.visit(tree, p);
            final Set flowSteps = Collections.newSetFromMap(new IdentityHashMap());
            List sinkFlows = (List)this.getCursor().getMessage(FLOW_GRAPHS);
            for (SinkFlowSummary flowGraphSummary : Objects.requireNonNull(sinkFlows)) {
                flowSteps.addAll(flowGraphSummary.getFlowParticipants());
            }
            if (!flowSteps.isEmpty()) {
                return (J)new JavaIsoVisitor<P>(){

                    public Expression visitExpression(Expression expression, P p) {
                        return flowSteps.contains(expression) ? (Expression)SearchResult.found((Tree)expression) : expression;
                    }

                    public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, P p) {
                        return flowSteps.contains(variable) ? (J.VariableDeclarations.NamedVariable)SearchResult.found((Tree)super.visitVariable(variable, p)) : super.visitVariable(variable, p);
                    }
                }.visit((Tree)c, p);
            }
            return c;
        }
        return (J)super.visit(tree, p);
    }

    public Expression visitExpression(Expression expression, P p) {
        Dataflow.startingAt(this.getCursor()).findSinks(this.spec).forEach(flow -> {
            if (flow.isNotEmpty()) {
                List flowGraphs = (List)this.getCursor().getNearestMessage(FLOW_GRAPHS);
                assert (flowGraphs != null);
                flowGraphs.add(flow);
            }
        });
        return expression;
    }

    public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, P p) {
        Dataflow.startingAt(this.getCursor()).findSinks(this.spec).forEach(flow -> {
            if (flow.isNotEmpty()) {
                List flowGraphs = (List)this.getCursor().getNearestMessage(FLOW_GRAPHS);
                assert (flowGraphs != null);
                flowGraphs.add(flow);
            }
        });
        return super.visitVariable(variable, p);
    }

    public static boolean anyMatch(Cursor cursor, DataFlowSpec spec) {
        JavaSourceFile enclosing = (JavaSourceFile)cursor.firstEnclosingOrThrow(JavaSourceFile.class);
        return new FindLocalFlowPaths<Integer>(spec).visit((Tree)enclosing, 0) != enclosing;
    }

    public static boolean noneMatch(Cursor cursor, DataFlowSpec spec) {
        return !FindLocalFlowPaths.anyMatch(cursor, spec);
    }

    @Generated
    public FindLocalFlowPaths(DataFlowSpec spec) {
        this.spec = spec;
    }
}

