/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.checkstyle;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import com.google.common.base.Charsets;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import io.micrometer.prometheus.PrometheusConfig;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import io.micrometer.prometheus.rsocket.PrometheusRSocketClient;
import io.rsocket.transport.ClientTransport;
import io.rsocket.transport.netty.client.TcpClientTransport;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.StandardOpenOption;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.openrewrite.Change;
import org.openrewrite.Refactor;
import org.openrewrite.checkstyle.RewriteCheckstyle;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.tree.J;
import org.slf4j.LoggerFactory;
import reactor.netty.tcp.TcpClient;
import reactor.util.retry.Retry;

public class Main {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws ParseException, IOException {
        PrometheusRSocketClient metricsClient = null;
        try {
            RewriteCheckstyle rewriteCheckstyle;
            InputStream is;
            DefaultParser parser = new DefaultParser();
            Options options = new Options();
            options.addOption("f", "file", true, "Checkstyle configuration XML file");
            options.addOption("c", "config", true, "Checkstyle configuration XML");
            options.addOption("l", "limit", true, "Limit number of files processed");
            options.addOption("r", "regex", true, "Glob filter");
            options.addOption("m", "metrics", false, "Publish metrics");
            CommandLine line = parser.parse(options, args);
            if (line.hasOption("m")) {
                PrometheusMeterRegistry prometheusMeterRegistry = new PrometheusMeterRegistry(PrometheusConfig.DEFAULT);
                metricsClient = PrometheusRSocketClient.build((PrometheusMeterRegistry)prometheusMeterRegistry, (ClientTransport)TcpClientTransport.create((TcpClient)TcpClient.create().host("localhost").port(7001))).retry((Retry)Retry.backoff((long)Long.MAX_VALUE, (Duration)Duration.ofSeconds(10L)).maxBackoff(Duration.ofMinutes(10L))).connect();
                Metrics.globalRegistry.add((MeterRegistry)prometheusMeterRegistry);
                new JvmGcMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
                new ProcessorMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
            }
            if (line.hasOption("f")) {
                is = new FileInputStream(new File(line.getOptionValue("f")));
                try {
                    rewriteCheckstyle = new RewriteCheckstyle(is);
                }
                finally {
                    is.close();
                }
            } else if (line.hasOption("c")) {
                is = new ByteArrayInputStream(line.getOptionValue("c").getBytes(Charsets.UTF_8));
                try {
                    rewriteCheckstyle = new RewriteCheckstyle(is);
                }
                finally {
                    is.close();
                }
            } else {
                throw new IllegalArgumentException("Supply either a config XML file via -f or an inline config via -c");
            }
            PathMatcher pathMatcher = line.hasOption("r") ? FileSystems.getDefault().getPathMatcher("glob:" + line.getOptionValue("r")) : null;
            List sourcePaths = Files.walk(Path.of("", new String[0]), new FileVisitOption[0]).filter(p -> p.toFile().getName().endsWith(".java")).filter(p -> pathMatcher == null || pathMatcher.matches((Path)p)).limit(Integer.parseInt(line.getOptionValue("l", "2147483647"))).collect(Collectors.toList());
            sourcePaths.stream().flatMap(javaSource -> {
                try {
                    return new JavaParser().setLogCompilationWarningsAndErrors(false).parse(Collections.singletonList(javaSource), Path.of("", new String[0]).toAbsolutePath()).stream();
                }
                catch (Throwable t) {
                    try {
                        Files.writeString(Path.of("errors-parsing.log", new String[0]), (CharSequence)javaSource.toString(), StandardOpenOption.APPEND);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return Stream.empty();
                }
            }).forEach(cu -> {
                Refactor<J.CompilationUnit, J> refactor = rewriteCheckstyle.apply((Refactor<J.CompilationUnit, J>)cu.refactor());
                Change fixed = refactor.fix();
                if (!fixed.getRulesThatMadeChanges().isEmpty()) {
                    fixed.getRulesThatMadeChanges().forEach(rule -> System.out.println("  " + rule));
                    try {
                        Files.writeString(new File(cu.getSourcePath()).toPath(), (CharSequence)((J.CompilationUnit)fixed.getFixed()).print(), new OpenOption[0]);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            });
        }
        finally {
            if (metricsClient != null) {
                metricsClient.pushAndClose().block(Duration.ofSeconds(10L));
            }
        }
    }

    static {
        Logger logger = (Logger)LoggerFactory.getLogger((String)"ROOT");
        logger.setLevel(Level.INFO);
    }
}

