/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.checkstyle.check;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openrewrite.Tree;
import org.openrewrite.java.refactor.JavaRefactorVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;

public class DefaultComesLast
extends JavaRefactorVisitor {
    private final boolean skipIfLastAndSharedWithCase;

    public DefaultComesLast(boolean skipIfLastAndSharedWithCase) {
        this.skipIfLastAndSharedWithCase = skipIfLastAndSharedWithCase;
    }

    public DefaultComesLast() {
        this(false);
    }

    public String getName() {
        return "checkstyle.DefaultComesLast";
    }

    public J visitSwitch(J.Switch switzh) {
        J.Switch s = (J.Switch)this.refactor((Tree)switzh, x$0 -> super.visitSwitch(x$0));
        if (!this.defaultIsLastOrNotPresent(switzh)) {
            J.Case lastNotGroupedWithDefault;
            J.Case lastGroupedWithDefault;
            J.Case aCase;
            int i;
            List cases = s.getCases().getStatements();
            ArrayList<Object> fixedCases = new ArrayList<Object>(cases.size());
            int defaultCaseIndex = -1;
            J.Case defaultCase = null;
            for (int i2 = 0; i2 < cases.size(); ++i2) {
                J.Case aCase2 = (J.Case)cases.get(i2);
                if (!this.isDefault(aCase2)) continue;
                defaultCaseIndex = i2;
                defaultCase = aCase2;
            }
            ArrayList<J.Case> casesGroupedWithDefault = new ArrayList<J.Case>();
            boolean foundNonEmptyCase = false;
            for (i = defaultCaseIndex - 1; i >= 0; --i) {
                aCase = (J.Case)cases.get(i);
                if (aCase.getStatements().isEmpty() && !foundNonEmptyCase) {
                    casesGroupedWithDefault.add(0, aCase);
                    continue;
                }
                foundNonEmptyCase = true;
                fixedCases.add(0, aCase);
            }
            foundNonEmptyCase = false;
            for (i = defaultCaseIndex + 1; i < cases.size(); ++i) {
                aCase = (J.Case)cases.get(i);
                if (defaultCase != null && defaultCase.getStatements().isEmpty() && aCase.getStatements().isEmpty() && !foundNonEmptyCase) {
                    casesGroupedWithDefault.add(aCase);
                    continue;
                }
                if (defaultCase != null && defaultCase.getStatements().isEmpty() && !foundNonEmptyCase) {
                    casesGroupedWithDefault.add(aCase);
                }
                foundNonEmptyCase = true;
                fixedCases.add(aCase);
            }
            if (defaultCase != null && !casesGroupedWithDefault.isEmpty() && !(lastGroupedWithDefault = (J.Case)casesGroupedWithDefault.get(casesGroupedWithDefault.size() - 1)).getStatements().isEmpty()) {
                casesGroupedWithDefault.set(casesGroupedWithDefault.size() - 1, lastGroupedWithDefault.withStatements(Collections.emptyList()));
                defaultCase = defaultCase.withStatements(lastGroupedWithDefault.getStatements());
            }
            if (!(lastNotGroupedWithDefault = (J.Case)fixedCases.get(fixedCases.size() - 1)).getStatements().stream().reduce((s1, s2) -> s2).map(stat -> stat instanceof J.Break || stat instanceof J.Continue || stat instanceof J.Return || stat instanceof J.Throw).orElse(false).booleanValue()) {
                ArrayList<J.Break> stats = new ArrayList<J.Break>(lastNotGroupedWithDefault.getStatements());
                stats.add(new J.Break(Tree.randomId(), null, this.formatter.format((Tree)lastNotGroupedWithDefault)));
                fixedCases.set(fixedCases.size() - 1, lastNotGroupedWithDefault.withStatements(stats));
            }
            fixedCases.addAll(casesGroupedWithDefault);
            if (defaultCase != null) {
                if (defaultCase.getStatements().stream().reduce((s1, s2) -> s2).map(stat -> stat instanceof J.Break || stat instanceof J.Continue || this.isVoidReturn((Statement)stat)).orElse(false).booleanValue()) {
                    ArrayList fixedDefaultStatements = new ArrayList(defaultCase.getStatements());
                    fixedDefaultStatements.remove(fixedDefaultStatements.size() - 1);
                    fixedCases.add(defaultCase.withStatements(fixedDefaultStatements));
                } else {
                    fixedCases.add(defaultCase);
                }
            }
            boolean changed = true;
            if (cases.size() == fixedCases.size()) {
                changed = false;
                for (int i3 = 0; i3 < cases.size(); ++i3) {
                    if (cases.get(i3) == fixedCases.get(i3)) continue;
                    changed = true;
                    break;
                }
            }
            if (changed) {
                s = s.withCases(s.getCases().withStatements(fixedCases));
            }
        }
        return s;
    }

    private boolean isVoidReturn(Statement stat) {
        return stat instanceof J.Return && ((J.Return)stat).getExpr() == null;
    }

    private boolean defaultIsLastOrNotPresent(J.Switch switzh) {
        J.Case defaultCase = null;
        J.Case prior = null;
        for (J.Case aCase : switzh.getCases().getStatements()) {
            if (defaultCase != null) {
                return false;
            }
            if (this.isDefault(aCase)) {
                defaultCase = aCase;
            }
            if (defaultCase != null && prior != null && this.skipIfLastAndSharedWithCase && prior.getStatements().isEmpty()) {
                return true;
            }
            prior = aCase;
        }
        return true;
    }

    private boolean isDefault(J.Case caze) {
        return caze.getPattern() != null && caze.getPattern().printTrimmed().equals("default");
    }
}

