/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.checkstyle.check;

import java.util.Collections;
import java.util.UUID;
import org.openrewrite.Formatting;
import org.openrewrite.SourceVisitor;
import org.openrewrite.Tree;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.refactor.JavaRefactorVisitor;
import org.openrewrite.java.refactor.ScopedJavaRefactorVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

public class EqualsAvoidsNull
extends JavaRefactorVisitor {
    private static final MethodMatcher STRING_EQUALS = new MethodMatcher("String equals(java.lang.Object)");
    private static final MethodMatcher STRING_EQUALS_IGNORE_CASE = new MethodMatcher("String equalsIgnoreCase(java.lang.String)");
    private final boolean ignoreEqualsIgnoreCase;

    public EqualsAvoidsNull(boolean ignoreEqualsIgnoreCase) {
        this.ignoreEqualsIgnoreCase = ignoreEqualsIgnoreCase;
    }

    public EqualsAvoidsNull() {
        this(false);
    }

    public String getName() {
        return "checkstyle.EqualsAvoidsNull";
    }

    public boolean isCursored() {
        return true;
    }

    public J visitMethodInvocation(J.MethodInvocation method) {
        J.MethodInvocation m = (J.MethodInvocation)this.refactor((Tree)method, x$0 -> super.visitMethodInvocation(x$0));
        if ((STRING_EQUALS.matches(m) || !this.ignoreEqualsIgnoreCase && STRING_EQUALS_IGNORE_CASE.matches(m)) && m.getArgs().getArgs().get(0) instanceof J.Literal && !(m.getSelect() instanceof J.Literal)) {
            J.Binary potentialNullCheck;
            J.Binary binary;
            Tree parent = this.getCursor().getParentOrThrow().getTree();
            if (parent instanceof J.Binary && (binary = (J.Binary)parent).getOperator() instanceof J.Binary.Operator.And && binary.getLeft() instanceof J.Binary && (this.isNullLiteral((potentialNullCheck = (J.Binary)binary.getLeft()).getLeft()) && this.matchesSelect(potentialNullCheck.getRight(), m.getSelect()) || this.isNullLiteral(potentialNullCheck.getRight()) && this.matchesSelect(potentialNullCheck.getLeft(), m.getSelect()))) {
                this.andThen((SourceVisitor)new RemoveUnnecessaryNullCheck(binary.getId()));
            }
            m = m.withSelect((Expression)((Expression)m.getArgs().getArgs().get(0)).withFormatting(m.getSelect().getFormatting())).withArgs(m.getArgs().withArgs(Collections.singletonList((Expression)m.getSelect().withFormatting(Formatting.EMPTY))));
        }
        return m;
    }

    private boolean isNullLiteral(Expression expression) {
        return expression instanceof J.Literal && ((J.Literal)expression).getType() == JavaType.Primitive.Null;
    }

    private boolean matchesSelect(Expression expression, Expression select) {
        return expression.printTrimmed().replaceAll("\\s", "").equals(select.printTrimmed().replaceAll("\\s", ""));
    }

    private static class RemoveUnnecessaryNullCheck
    extends ScopedJavaRefactorVisitor {
        public RemoveUnnecessaryNullCheck(UUID scope) {
            super(scope);
        }

        public J visitBinary(J.Binary binary) {
            this.maybeUnwrapParentheses(this.getCursor().getParent());
            if (this.isScope()) {
                return (J)Formatting.stripPrefix((Tree)binary.getRight());
            }
            return super.visitBinary(binary);
        }
    }
}

