/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.checkstyle.check;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.openrewrite.SourceVisitor;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaSourceVisitor;
import org.openrewrite.java.refactor.JavaRefactorVisitor;
import org.openrewrite.java.refactor.ScopedJavaRefactorVisitor;
import org.openrewrite.java.tree.J;

public class FallThrough
extends JavaRefactorVisitor {
    private final boolean checkLastCaseGroup;
    private final Pattern reliefPattern;
    private final Set<UUID> casesToAddBreak = new HashSet<UUID>();

    public String getName() {
        return "checkstyle.FallThrough";
    }

    public boolean isCursored() {
        return true;
    }

    public void nextCycle() {
        this.casesToAddBreak.clear();
        super.nextCycle();
    }

    public J visitCase(J.Case caze) {
        J.Switch switzh = (J.Switch)this.getCursor().getParentOrThrow().getParentOrThrow().getTree();
        if ((this.checkLastCaseGroup || !this.isLastCase(caze)) && !((Boolean)new LastLineBreaksOrFallsThrough(caze).visit((Tree)switzh)).booleanValue() && this.casesToAddBreak.add(caze.getId())) {
            this.andThen((SourceVisitor)new AddBreak(caze.getId()));
        }
        return super.visitCase(caze);
    }

    private boolean isLastCase(J.Case caze) {
        J.Block switchBlock = (J.Block)this.getCursor().getParentOrThrow().getTree();
        return caze == switchBlock.getStatements().get(switchBlock.getStatements().size() - 1);
    }

    private static boolean $default$checkLastCaseGroup() {
        return false;
    }

    private static Pattern $default$reliefPattern() {
        return Pattern.compile("falls?[ -]?thr(u|ough)");
    }

    FallThrough(boolean checkLastCaseGroup, Pattern reliefPattern) {
        this.checkLastCaseGroup = checkLastCaseGroup;
        this.reliefPattern = reliefPattern;
    }

    public static FallThroughBuilder builder() {
        return new FallThroughBuilder();
    }

    public static class FallThroughBuilder {
        private boolean checkLastCaseGroup$set;
        private boolean checkLastCaseGroup$value;
        private boolean reliefPattern$set;
        private Pattern reliefPattern$value;

        FallThroughBuilder() {
        }

        public FallThroughBuilder checkLastCaseGroup(boolean checkLastCaseGroup) {
            this.checkLastCaseGroup$value = checkLastCaseGroup;
            this.checkLastCaseGroup$set = true;
            return this;
        }

        public FallThroughBuilder reliefPattern(Pattern reliefPattern) {
            this.reliefPattern$value = reliefPattern;
            this.reliefPattern$set = true;
            return this;
        }

        public FallThrough build() {
            boolean checkLastCaseGroup$value = this.checkLastCaseGroup$value;
            if (!this.checkLastCaseGroup$set) {
                checkLastCaseGroup$value = FallThrough.$default$checkLastCaseGroup();
            }
            Pattern reliefPattern$value = this.reliefPattern$value;
            if (!this.reliefPattern$set) {
                reliefPattern$value = FallThrough.$default$reliefPattern();
            }
            return new FallThrough(checkLastCaseGroup$value, reliefPattern$value);
        }

        public String toString() {
            return "FallThrough.FallThroughBuilder(checkLastCaseGroup$value=" + this.checkLastCaseGroup$value + ", reliefPattern$value=" + this.reliefPattern$value + ")";
        }
    }

    private class LastLineBreaksOrFallsThrough
    extends JavaSourceVisitor<Boolean> {
        private final J.Case scope;

        public Boolean defaultTo(Tree t) {
            return false;
        }

        public Boolean visitSwitch(J.Switch switzh) {
            List statements = switzh.getCases().getStatements();
            for (int i = 0; i < statements.size() - 1; ++i) {
                J.Case caze = (J.Case)statements.get(i);
                if (caze != this.scope || !FallThrough.this.reliefPattern.matcher(((J.Case)statements.get(i + 1)).getFormatting().getPrefix()).find()) continue;
                return true;
            }
            return (Boolean)super.visitSwitch(switzh);
        }

        public Boolean visitCase(J.Case caze) {
            return caze == this.scope && (this.lastLineBreaksOrFallsThrough(caze.getStatements()) || (Boolean)super.visitCase(caze) != false);
        }

        public Boolean visitBlock(J.Block<J> block) {
            return this.lastLineBreaksOrFallsThrough(block.getStatements()) || FallThrough.this.reliefPattern.matcher(block.getEndOfBlockSuffix()).find() || (Boolean)super.visitBlock(block) != false;
        }

        private boolean lastLineBreaksOrFallsThrough(List<? extends Tree> trees) {
            return trees.stream().reduce((s1, s2) -> s2).map(s -> s instanceof J.Return || s instanceof J.Break || s instanceof J.Continue || s instanceof J.Empty && FallThrough.this.reliefPattern.matcher(s.getFormatting().getPrefix()).find() || FallThrough.this.reliefPattern.matcher(s.getFormatting().getSuffix()).find()).orElse(false);
        }

        public LastLineBreaksOrFallsThrough(J.Case scope) {
            this.scope = scope;
        }
    }

    private static class AddBreak
    extends ScopedJavaRefactorVisitor {
        public AddBreak(UUID scope) {
            super(scope);
        }

        public J visitCase(J.Case caze) {
            J.Case c = (J.Case)this.refactor((Tree)caze, x$0 -> super.visitCase(x$0));
            if (this.isScope() && c.getStatements().stream().noneMatch(s -> s instanceof J.Break) && c.getStatements().stream().reduce((s1, s2) -> s2).map(s -> !(s instanceof J.Block)).orElse(true).booleanValue()) {
                ArrayList<J.Break> statements = new ArrayList<J.Break>(c.getStatements());
                J.Block switchBlock = (J.Block)this.getCursor().getParentOrThrow().getTree();
                statements.add(new J.Break(Tree.randomId(), null, this.formatter.format((Tree)switchBlock)));
                c = c.withStatements(statements);
            }
            return c;
        }

        public J visitBlock(J.Block<J> block) {
            J.Block b = (J.Block)this.refactor((Tree)block, x$0 -> super.visitBlock(x$0));
            if (this.isScopeInCursorPath() && block.getStatements().stream().noneMatch(s -> s instanceof J.Break) && block.getStatements().stream().reduce((s1, s2) -> s2).map(s -> !(s instanceof J.Block)).orElse(true).booleanValue()) {
                List statements = b.getStatements();
                statements.add(new J.Break(Tree.randomId(), null, this.formatter.format((Tree)b)));
                b = b.withStatements(statements);
            }
            return b;
        }
    }
}

