/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.checkstyle.check;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.openrewrite.Cursor;
import org.openrewrite.SourceVisitor;
import org.openrewrite.Tree;
import org.openrewrite.checkstyle.policy.Token;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaSourceVisitor;
import org.openrewrite.java.refactor.JavaRefactorVisitor;
import org.openrewrite.java.refactor.ScopedJavaRefactorVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class HiddenField
extends JavaRefactorVisitor {
    private static final Pattern NAME_PATTERN = Pattern.compile("(.+)(\\d+)");
    @Nullable
    Pattern ignoreFormat;
    boolean ignoreConstructorParameter;
    boolean ignoreSetter;
    boolean setterCanReturnItsClass;
    boolean ignoreAbstractMethods;
    Set<Token> tokens;

    public String getName() {
        return "checkstyle.HiddenField";
    }

    public boolean isCursored() {
        return true;
    }

    public J visitClassDecl(J.ClassDecl classDecl) {
        List visibleSupertypeMembers = TypeUtils.getVisibleSupertypeMembers((JavaType)classDecl.getType());
        List<J.VariableDecls.NamedVar> shadows = visibleSupertypeMembers.stream().filter(member -> this.ignoreFormat == null || !this.ignoreFormat.matcher(member.getName()).matches()).flatMap(member -> ((List)new FindNameShadows(member.getName(), this.enclosingClass()).visit((Tree)classDecl.getBody())).stream()).collect(Collectors.toList());
        if (!shadows.isEmpty()) {
            shadows.forEach(shadow -> this.andThen((SourceVisitor)new RenameShadowedName(shadow.getId(), visibleSupertypeMembers)));
        }
        return super.visitClassDecl(classDecl);
    }

    public J visitVariable(J.VariableDecls.NamedVar variable) {
        Cursor parent = this.getCursor().getParentOrThrow().getParentOrThrow().getParentOrThrow();
        if (parent.getTree() instanceof J.ClassDecl && (this.ignoreFormat == null || !this.ignoreFormat.matcher(variable.getSimpleName()).matches())) {
            J.ClassDecl classDecl = (J.ClassDecl)parent.getTree();
            List shadows = (List)new FindNameShadows(variable, this.enclosingClass()).visit((Tree)this.enclosingBlock());
            if (!shadows.isEmpty()) {
                shadows.forEach(shadow -> this.andThen((SourceVisitor)new RenameShadowedName(shadow.getId(), TypeUtils.getVisibleSupertypeMembers((JavaType)classDecl.getType()))));
            }
        }
        return super.visitVariable(variable);
    }

    private static Pattern $default$ignoreFormat() {
        return null;
    }

    private static boolean $default$ignoreConstructorParameter() {
        return false;
    }

    private static boolean $default$ignoreSetter() {
        return false;
    }

    private static boolean $default$setterCanReturnItsClass() {
        return false;
    }

    private static boolean $default$ignoreAbstractMethods() {
        return false;
    }

    private static Set<Token> $default$tokens() {
        return Set.of(Token.VARIABLE_DEF, Token.PARAMETER_DEF, Token.LAMBDA);
    }

    HiddenField(Pattern ignoreFormat, boolean ignoreConstructorParameter, boolean ignoreSetter, boolean setterCanReturnItsClass, boolean ignoreAbstractMethods, Set<Token> tokens) {
        this.ignoreFormat = ignoreFormat;
        this.ignoreConstructorParameter = ignoreConstructorParameter;
        this.ignoreSetter = ignoreSetter;
        this.setterCanReturnItsClass = setterCanReturnItsClass;
        this.ignoreAbstractMethods = ignoreAbstractMethods;
        this.tokens = tokens;
    }

    public static HiddenFieldBuilder builder() {
        return new HiddenFieldBuilder();
    }

    public static class HiddenFieldBuilder {
        private boolean ignoreFormat$set;
        private Pattern ignoreFormat$value;
        private boolean ignoreConstructorParameter$set;
        private boolean ignoreConstructorParameter$value;
        private boolean ignoreSetter$set;
        private boolean ignoreSetter$value;
        private boolean setterCanReturnItsClass$set;
        private boolean setterCanReturnItsClass$value;
        private boolean ignoreAbstractMethods$set;
        private boolean ignoreAbstractMethods$value;
        private boolean tokens$set;
        private Set<Token> tokens$value;

        HiddenFieldBuilder() {
        }

        public HiddenFieldBuilder ignoreFormat(Pattern ignoreFormat) {
            this.ignoreFormat$value = ignoreFormat;
            this.ignoreFormat$set = true;
            return this;
        }

        public HiddenFieldBuilder ignoreConstructorParameter(boolean ignoreConstructorParameter) {
            this.ignoreConstructorParameter$value = ignoreConstructorParameter;
            this.ignoreConstructorParameter$set = true;
            return this;
        }

        public HiddenFieldBuilder ignoreSetter(boolean ignoreSetter) {
            this.ignoreSetter$value = ignoreSetter;
            this.ignoreSetter$set = true;
            return this;
        }

        public HiddenFieldBuilder setterCanReturnItsClass(boolean setterCanReturnItsClass) {
            this.setterCanReturnItsClass$value = setterCanReturnItsClass;
            this.setterCanReturnItsClass$set = true;
            return this;
        }

        public HiddenFieldBuilder ignoreAbstractMethods(boolean ignoreAbstractMethods) {
            this.ignoreAbstractMethods$value = ignoreAbstractMethods;
            this.ignoreAbstractMethods$set = true;
            return this;
        }

        public HiddenFieldBuilder tokens(Set<Token> tokens) {
            this.tokens$value = tokens;
            this.tokens$set = true;
            return this;
        }

        public HiddenField build() {
            Pattern ignoreFormat$value = this.ignoreFormat$value;
            if (!this.ignoreFormat$set) {
                ignoreFormat$value = HiddenField.$default$ignoreFormat();
            }
            boolean ignoreConstructorParameter$value = this.ignoreConstructorParameter$value;
            if (!this.ignoreConstructorParameter$set) {
                ignoreConstructorParameter$value = HiddenField.$default$ignoreConstructorParameter();
            }
            boolean ignoreSetter$value = this.ignoreSetter$value;
            if (!this.ignoreSetter$set) {
                ignoreSetter$value = HiddenField.$default$ignoreSetter();
            }
            boolean setterCanReturnItsClass$value = this.setterCanReturnItsClass$value;
            if (!this.setterCanReturnItsClass$set) {
                setterCanReturnItsClass$value = HiddenField.$default$setterCanReturnItsClass();
            }
            boolean ignoreAbstractMethods$value = this.ignoreAbstractMethods$value;
            if (!this.ignoreAbstractMethods$set) {
                ignoreAbstractMethods$value = HiddenField.$default$ignoreAbstractMethods();
            }
            Set<Token> tokens$value = this.tokens$value;
            if (!this.tokens$set) {
                tokens$value = HiddenField.$default$tokens();
            }
            return new HiddenField(ignoreFormat$value, ignoreConstructorParameter$value, ignoreSetter$value, setterCanReturnItsClass$value, ignoreAbstractMethods$value, tokens$value);
        }

        public String toString() {
            return "HiddenField.HiddenFieldBuilder(ignoreFormat$value=" + this.ignoreFormat$value + ", ignoreConstructorParameter$value=" + this.ignoreConstructorParameter$value + ", ignoreSetter$value=" + this.ignoreSetter$value + ", setterCanReturnItsClass$value=" + this.setterCanReturnItsClass$value + ", ignoreAbstractMethods$value=" + this.ignoreAbstractMethods$value + ", tokens$value=" + this.tokens$value + ")";
        }
    }

    private static class RenameShadowedName
    extends ScopedJavaRefactorVisitor {
        private final List<JavaType.Var> supertypeMembers;

        public RenameShadowedName(UUID scope, List<JavaType.Var> supertypeMembers) {
            super(scope);
            this.supertypeMembers = supertypeMembers;
        }

        public J visitVariable(J.VariableDecls.NamedVar variable) {
            J.VariableDecls.NamedVar v = (J.VariableDecls.NamedVar)this.refactor((Tree)variable, x$0 -> super.visitVariable(x$0));
            if (this.isScope()) {
                String nextName = this.nextName(v.getSimpleName());
                while (this.matchesSupertypeMember(nextName) || ((Boolean)new ShadowsName(this.getCursor(), nextName).visit((Tree)this.enclosingCompilationUnit())).booleanValue()) {
                    nextName = this.nextName(nextName);
                }
                v = v.withName(v.getName().withName(nextName));
            }
            return v;
        }

        private boolean matchesSupertypeMember(String nextName) {
            return this.supertypeMembers.stream().anyMatch(m -> m.getName().equals(nextName));
        }

        private String nextName(String name) {
            Matcher nameMatcher = NAME_PATTERN.matcher(name);
            return nameMatcher.matches() ? nameMatcher.group(1) + (Integer.parseInt(nameMatcher.group(2)) + 1) : name + "1";
        }
    }

    private static class ShadowsName
    extends JavaSourceVisitor<Boolean> {
        private final Cursor scope;
        private final String name;

        public boolean isCursored() {
            return true;
        }

        public Boolean defaultTo(Tree t) {
            return false;
        }

        public Boolean visitVariable(J.VariableDecls.NamedVar variable) {
            return variable != this.scope.getTree() && this.isInSameNameScope(this.scope) && variable.getSimpleName().equals(this.name) || (Boolean)super.visitVariable(variable) != false;
        }

        public ShadowsName(Cursor scope, String name) {
            this.scope = scope;
            this.name = name;
        }
    }

    private class FindNameShadows
    extends JavaSourceVisitor<List<J.VariableDecls.NamedVar>> {
        @Nullable
        private final J.VariableDecls.NamedVar thatLookLike;
        private final String thatLookLikeName;
        private final J.ClassDecl enclosingClass;

        public FindNameShadows(J.VariableDecls.NamedVar thatLookLike, J.ClassDecl enclosingClass) {
            this.thatLookLike = thatLookLike;
            this.thatLookLikeName = thatLookLike.getSimpleName();
            this.enclosingClass = enclosingClass;
        }

        public FindNameShadows(String thatLookLikeName, J.ClassDecl enclosingClass) {
            this.enclosingClass = enclosingClass;
            this.thatLookLike = null;
            this.thatLookLikeName = thatLookLikeName;
        }

        public boolean isCursored() {
            return true;
        }

        public List<J.VariableDecls.NamedVar> defaultTo(Tree t) {
            return Collections.emptyList();
        }

        public List<J.VariableDecls.NamedVar> visitClassDecl(J.ClassDecl classDecl) {
            if (!(classDecl.getKind() instanceof J.ClassDecl.Kind.Class) || classDecl.hasModifier("static")) {
                return Collections.emptyList();
            }
            return (List)super.visitClassDecl(classDecl);
        }

        public List<J.VariableDecls.NamedVar> visitVariable(J.VariableDecls.NamedVar variable) {
            boolean isIgnorableAbstractMethod;
            List shadows = (List)super.visitVariable(variable);
            Tree maybeMethodDecl = this.getCursor().getParentOrThrow().getParentOrThrow().getTree();
            boolean isIgnorableConstructorParam = HiddenField.this.ignoreConstructorParameter;
            if (isIgnorableConstructorParam) {
                isIgnorableConstructorParam = maybeMethodDecl instanceof J.MethodDecl && ((J.MethodDecl)maybeMethodDecl).isConstructor();
            }
            boolean isIgnorableSetter = HiddenField.this.ignoreSetter;
            if (isIgnorableSetter &= maybeMethodDecl instanceof J.MethodDecl) {
                J.MethodDecl methodDecl = (J.MethodDecl)maybeMethodDecl;
                String methodName = methodDecl.getSimpleName();
                boolean bl = methodName.startsWith("set") && methodDecl.getReturnTypeExpr() != null && (HiddenField.this.setterCanReturnItsClass ? this.enclosingClass.getType().equals(methodDecl.getReturnTypeExpr().getType()) : JavaType.Primitive.Void.equals((Object)methodDecl.getReturnTypeExpr().getType())) && methodName.length() > 3 && variable.getSimpleName().equalsIgnoreCase(methodName.substring(3)) ? true : (isIgnorableSetter = false);
            }
            if (isIgnorableAbstractMethod = HiddenField.this.ignoreAbstractMethods) {
                boolean bl = isIgnorableAbstractMethod = maybeMethodDecl instanceof J.MethodDecl && ((J.MethodDecl)maybeMethodDecl).hasModifier("abstract");
            }
            if (variable != this.thatLookLike && !isIgnorableSetter && !isIgnorableConstructorParam && !isIgnorableAbstractMethod && variable.getSimpleName().equals(this.thatLookLikeName) && HiddenField.this.tokens.stream().anyMatch(t -> t.equals((Object)Token.LAMBDA) ? this.getCursor().getParentOrThrow().getTree() instanceof J.Lambda.Parameters : t.getMatcher().matches(this.getCursor()))) {
                shadows.add(variable);
            }
            return shadows;
        }
    }
}

