/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.checkstyle.check;

import java.util.Set;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.checkstyle.check.SpansMultipleLines;
import org.openrewrite.checkstyle.policy.LeftCurlyPolicy;
import org.openrewrite.checkstyle.policy.Token;
import org.openrewrite.java.refactor.JavaRefactorVisitor;
import org.openrewrite.java.tree.J;

public class LeftCurly
extends JavaRefactorVisitor {
    private final LeftCurlyPolicy option;
    private final boolean ignoreEnums;
    private final Set<Token> tokens;

    public String getName() {
        return "checkstyle.LeftCurly";
    }

    public boolean isCursored() {
        return true;
    }

    public J visitBlock(J.Block<J> block) {
        boolean spansMultipleLines;
        J.Block<J> b = (J.Block<J>)this.refactor((Tree)block, x$0 -> super.visitBlock(x$0));
        Cursor containing = this.getCursor().getParentOrThrow();
        boolean bl = spansMultipleLines = LeftCurlyPolicy.NLOW.equals((Object)this.option) ? (Boolean)new SpansMultipleLines((J)containing.getTree(), (J)block).visit(containing.getTree()) : false;
        if (!this.satisfiesPolicy(this.option, block, containing.getTree(), spansMultipleLines)) {
            b = LeftCurly.formatCurly(this.option, b, spansMultipleLines, containing);
        }
        return b;
    }

    private boolean satisfiesPolicy(LeftCurlyPolicy option, J.Block<J> block, Tree containing, boolean spansMultipleLines) {
        switch (option) {
            case EOL: {
                if (this.ignoreEnums && containing instanceof J.Case) {
                    return true;
                }
                if (block.getStatic() == null) {
                    return !block.getFormatting().getPrefix().contains("\n");
                }
                return !block.getStatic().getFormatting().getSuffix().contains("\n");
            }
            case NL: {
                if (block.getStatic() == null) {
                    return block.getFormatting().getPrefix().contains("\n");
                }
                return block.getStatic().getFormatting().getSuffix().contains("\n");
            }
        }
        return spansMultipleLines && this.satisfiesPolicy(LeftCurlyPolicy.NL, block, containing, true) || !spansMultipleLines && this.satisfiesPolicy(LeftCurlyPolicy.EOL, block, containing, false);
    }

    private static J.Block<J> formatCurly(LeftCurlyPolicy option, J.Block<J> block, boolean spansMultipleLines, Cursor containing) {
        switch (option) {
            case EOL: {
                Tree parent = containing.getParentOrThrow().getTree();
                if ((parent instanceof J.ClassDecl || parent instanceof J.NewClass) && block.getStatic() == null) {
                    return block;
                }
                return block.getStatic() == null ? (J.Block)block.withPrefix(" ") : block.withStatic((J.Empty)block.getStatic().withSuffix(" "));
            }
            case NL: {
                return block.getStatic() == null ? (J.Block)block.withPrefix(block.getEndOfBlockSuffix()) : block.withStatic((J.Empty)block.getStatic().withSuffix(block.getEndOfBlockSuffix()));
            }
        }
        return LeftCurly.formatCurly(spansMultipleLines ? LeftCurlyPolicy.NL : LeftCurlyPolicy.EOL, block, spansMultipleLines, containing);
    }

    private static LeftCurlyPolicy $default$option() {
        return LeftCurlyPolicy.EOL;
    }

    private static boolean $default$ignoreEnums() {
        return true;
    }

    private static Set<Token> $default$tokens() {
        return Set.of(Token.ANNOTATION_DEF, Token.CLASS_DEF, Token.CTOR_DEF, Token.ENUM_CONSTANT_DEF, Token.ENUM_DEF, Token.INTERFACE_DEF, Token.LAMBDA, Token.LITERAL_CASE, Token.LITERAL_CATCH, Token.LITERAL_DEFAULT, Token.LITERAL_DO, Token.LITERAL_ELSE, Token.LITERAL_FINALLY, Token.LITERAL_FOR, Token.LITERAL_IF, Token.LITERAL_SWITCH, Token.LITERAL_SYNCHRONIZED, Token.LITERAL_TRY, Token.LITERAL_WHILE, Token.METHOD_DEF, Token.OBJBLOCK, Token.STATIC_INIT);
    }

    LeftCurly(LeftCurlyPolicy option, boolean ignoreEnums, Set<Token> tokens) {
        this.option = option;
        this.ignoreEnums = ignoreEnums;
        this.tokens = tokens;
    }

    public static LeftCurlyBuilder builder() {
        return new LeftCurlyBuilder();
    }

    public static class LeftCurlyBuilder {
        private boolean option$set;
        private LeftCurlyPolicy option$value;
        private boolean ignoreEnums$set;
        private boolean ignoreEnums$value;
        private boolean tokens$set;
        private Set<Token> tokens$value;

        LeftCurlyBuilder() {
        }

        public LeftCurlyBuilder option(LeftCurlyPolicy option) {
            this.option$value = option;
            this.option$set = true;
            return this;
        }

        public LeftCurlyBuilder ignoreEnums(boolean ignoreEnums) {
            this.ignoreEnums$value = ignoreEnums;
            this.ignoreEnums$set = true;
            return this;
        }

        public LeftCurlyBuilder tokens(Set<Token> tokens) {
            this.tokens$value = tokens;
            this.tokens$set = true;
            return this;
        }

        public LeftCurly build() {
            LeftCurlyPolicy option$value = this.option$value;
            if (!this.option$set) {
                option$value = LeftCurly.$default$option();
            }
            boolean ignoreEnums$value = this.ignoreEnums$value;
            if (!this.ignoreEnums$set) {
                ignoreEnums$value = LeftCurly.$default$ignoreEnums();
            }
            Set<Token> tokens$value = this.tokens$value;
            if (!this.tokens$set) {
                tokens$value = LeftCurly.$default$tokens();
            }
            return new LeftCurly(option$value, ignoreEnums$value, tokens$value);
        }

        public String toString() {
            return "LeftCurly.LeftCurlyBuilder(option$value=" + this.option$value + ", ignoreEnums$value=" + this.ignoreEnums$value + ", tokens$value=" + this.tokens$value + ")";
        }
    }
}

