/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.checkstyle.check;

import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.openrewrite.Tree;
import org.openrewrite.checkstyle.policy.PadPolicy;
import org.openrewrite.checkstyle.policy.Token;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.refactor.JavaRefactorVisitor;
import org.openrewrite.java.tree.J;

public class MethodParamPad
extends JavaRefactorVisitor {
    private final boolean allowLineBreaks;
    private final PadPolicy option;
    private final Set<Token> tokens;

    public String getName() {
        return "checkstyle.MethodParamPad";
    }

    public boolean isCursored() {
        return true;
    }

    public J visitMethod(J.MethodDecl method) {
        return this.maybeFixFormatting(method, x$0 -> super.visitMethod(x$0), J.MethodDecl::getParams, J.MethodDecl::withParams, Token.METHOD_DEF);
    }

    public J visitNewClass(J.NewClass newClass) {
        return this.maybeFixFormatting(newClass, x$0 -> super.visitNewClass(x$0), J.NewClass::getArgs, J.NewClass::withArgs, Token.LITERAL_NEW);
    }

    public J visitMethodInvocation(J.MethodInvocation method) {
        return this.maybeFixFormatting((J)method, x$0 -> super.visitMethodInvocation(x$0), J.MethodInvocation::getArgs, J.MethodInvocation::withArgs, Token.METHOD_CALL, Token.SUPER_CTOR_CALL);
    }

    private <T extends J, U extends Tree> T maybeFixFormatting(@Nullable T t, Function<T, Tree> callSuper, Function<T, U> getter, BiFunction<T, U, T> setter, Token ... tokensToMatch) {
        if (getter.apply(t = (J)this.refactor((Tree)t, callSuper)) != null && Token.matchesOneOf(this.tokens, this.getCursor(), tokensToMatch) && this.hasWrongSpacing((Tree)getter.apply(t))) {
            t = (J)setter.apply(t, ((Tree)getter.apply(t)).withPrefix(this.option == PadPolicy.NOSPACE ? "" : " "));
        }
        return t;
    }

    private boolean hasWrongSpacing(Tree t) {
        String prefix = t.getFormatting().getPrefix();
        return this.option == PadPolicy.NOSPACE ? !prefix.isEmpty() && (this.allowLineBreaks ? prefix.startsWith(" ") || prefix.startsWith("\t") : Character.isWhitespace(prefix.charAt(0))) : prefix.isEmpty();
    }

    private static boolean $default$allowLineBreaks() {
        return false;
    }

    private static PadPolicy $default$option() {
        return PadPolicy.NOSPACE;
    }

    private static Set<Token> $default$tokens() {
        return Set.of(Token.CTOR_DEF, Token.LITERAL_NEW, Token.METHOD_CALL, Token.METHOD_DEF, Token.SUPER_CTOR_CALL, Token.ENUM_CONSTANT_DEF);
    }

    MethodParamPad(boolean allowLineBreaks, PadPolicy option, Set<Token> tokens) {
        this.allowLineBreaks = allowLineBreaks;
        this.option = option;
        this.tokens = tokens;
    }

    public static MethodParamPadBuilder builder() {
        return new MethodParamPadBuilder();
    }

    public static class MethodParamPadBuilder {
        private boolean allowLineBreaks$set;
        private boolean allowLineBreaks$value;
        private boolean option$set;
        private PadPolicy option$value;
        private boolean tokens$set;
        private Set<Token> tokens$value;

        MethodParamPadBuilder() {
        }

        public MethodParamPadBuilder allowLineBreaks(boolean allowLineBreaks) {
            this.allowLineBreaks$value = allowLineBreaks;
            this.allowLineBreaks$set = true;
            return this;
        }

        public MethodParamPadBuilder option(PadPolicy option) {
            this.option$value = option;
            this.option$set = true;
            return this;
        }

        public MethodParamPadBuilder tokens(Set<Token> tokens) {
            this.tokens$value = tokens;
            this.tokens$set = true;
            return this;
        }

        public MethodParamPad build() {
            boolean allowLineBreaks$value = this.allowLineBreaks$value;
            if (!this.allowLineBreaks$set) {
                allowLineBreaks$value = MethodParamPad.$default$allowLineBreaks();
            }
            PadPolicy option$value = this.option$value;
            if (!this.option$set) {
                option$value = MethodParamPad.$default$option();
            }
            Set<Token> tokens$value = this.tokens$value;
            if (!this.tokens$set) {
                tokens$value = MethodParamPad.$default$tokens();
            }
            return new MethodParamPad(allowLineBreaks$value, option$value, tokens$value);
        }

        public String toString() {
            return "MethodParamPad.MethodParamPadBuilder(allowLineBreaks$value=" + this.allowLineBreaks$value + ", option$value=" + this.option$value + ", tokens$value=" + this.tokens$value + ")";
        }
    }
}

