/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.checkstyle.check;

import java.util.Collections;
import java.util.Set;
import org.openrewrite.Formatting;
import org.openrewrite.Tree;
import org.openrewrite.checkstyle.check.SpansMultipleLines;
import org.openrewrite.checkstyle.policy.Token;
import org.openrewrite.java.refactor.JavaRefactorVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.refactor.Formatter;

public class NeedBraces
extends JavaRefactorVisitor {
    private final boolean allowSingleLineStatement;
    private final boolean allowEmptyLoopBody;
    private final Set<Token> tokens;

    public String getName() {
        return "checkstyle.NeedBraces";
    }

    public boolean isCursored() {
        return true;
    }

    public J visitIf(J.If iff) {
        J.If i = (J.If)this.refactor((Tree)iff, x$0 -> super.visitIf(x$0));
        if (this.tokens.contains((Object)Token.LITERAL_IF) && !(iff.getThenPart() instanceof J.Block) && this.isNotAllowableSingleLine()) {
            i = i.withThenPart(this.addBraces(i.getThenPart()));
        }
        return i;
    }

    public J visitElse(J.If.Else elze) {
        J.If.Else e = (J.If.Else)this.refactor((Tree)elze, x$0 -> super.visitElse(x$0));
        if (this.tokens.contains((Object)Token.LITERAL_ELSE) && !(elze.getStatement() instanceof J.If) && !(elze.getStatement() instanceof J.Block) && this.isNotAllowableSingleLine()) {
            e = e.withStatement(this.addBraces(e.getStatement()));
        }
        return e;
    }

    public J visitWhileLoop(J.WhileLoop whileLoop) {
        boolean hasAllowableBodyType;
        J.WhileLoop w = (J.WhileLoop)this.refactor((Tree)whileLoop, x$0 -> super.visitWhileLoop(x$0));
        Statement body = w.getBody();
        boolean bl = this.allowEmptyLoopBody ? body instanceof J.Empty || body instanceof J.Block : (hasAllowableBodyType = body instanceof J.Block);
        if (this.tokens.contains((Object)Token.LITERAL_WHILE) && !hasAllowableBodyType && this.isNotAllowableSingleLine()) {
            w = w.withBody(this.addBraces(w.getBody()));
        }
        return w;
    }

    public J visitDoWhileLoop(J.DoWhileLoop doWhileLoop) {
        J.DoWhileLoop w = (J.DoWhileLoop)this.refactor((Tree)doWhileLoop, x$0 -> super.visitDoWhileLoop(x$0));
        if (this.tokens.contains((Object)Token.LITERAL_DO) && !(w.getBody() instanceof J.Block) && this.isNotAllowableSingleLine()) {
            w = w.withBody(this.addBraces(w.getBody()));
        }
        return w;
    }

    public J visitForLoop(J.ForLoop forLoop) {
        boolean hasAllowableBodyType;
        J.ForLoop f = (J.ForLoop)this.refactor((Tree)forLoop, x$0 -> super.visitForLoop(x$0));
        Statement body = f.getBody();
        boolean bl = this.allowEmptyLoopBody ? body instanceof J.Empty || body instanceof J.Block : (hasAllowableBodyType = body instanceof J.Block);
        if (this.tokens.contains((Object)Token.LITERAL_FOR) && !hasAllowableBodyType && this.isNotAllowableSingleLine()) {
            f = f.withBody(this.addBraces(f.getBody()));
        }
        return f;
    }

    private boolean isNotAllowableSingleLine() {
        return !this.allowSingleLineStatement || (Boolean)new SpansMultipleLines((J)this.getCursor().getTree(), null).visit(this.getCursor().getTree()) != false;
    }

    private Statement addBraces(Statement body) {
        if (body instanceof J.Block) {
            return body;
        }
        int enclosingIndent = ((J.Block)this.getCursor().getParentOrThrow().firstEnclosing(J.Block.class)).getIndent();
        Formatter.Result format = this.formatter.findIndent(enclosingIndent, new Tree[]{this.getCursor().getParentOrThrow().getTree()});
        String originalBodySuffix = body.getFormatting().getSuffix();
        return new J.Block(Tree.randomId(), null, body instanceof J.Empty ? Collections.emptyList() : Collections.singletonList((J)body.withFormatting(Formatting.format((String)format.getPrefix(1)))), Formatting.format((String)" ", (String)originalBodySuffix), format.getPrefix());
    }

    private static boolean $default$allowSingleLineStatement() {
        return false;
    }

    private static boolean $default$allowEmptyLoopBody() {
        return false;
    }

    private static Set<Token> $default$tokens() {
        return Set.of(Token.LITERAL_DO, Token.LITERAL_ELSE, Token.LITERAL_FOR, Token.LITERAL_IF, Token.LITERAL_WHILE);
    }

    NeedBraces(boolean allowSingleLineStatement, boolean allowEmptyLoopBody, Set<Token> tokens) {
        this.allowSingleLineStatement = allowSingleLineStatement;
        this.allowEmptyLoopBody = allowEmptyLoopBody;
        this.tokens = tokens;
    }

    public static NeedBracesBuilder builder() {
        return new NeedBracesBuilder();
    }

    public static class NeedBracesBuilder {
        private boolean allowSingleLineStatement$set;
        private boolean allowSingleLineStatement$value;
        private boolean allowEmptyLoopBody$set;
        private boolean allowEmptyLoopBody$value;
        private boolean tokens$set;
        private Set<Token> tokens$value;

        NeedBracesBuilder() {
        }

        public NeedBracesBuilder allowSingleLineStatement(boolean allowSingleLineStatement) {
            this.allowSingleLineStatement$value = allowSingleLineStatement;
            this.allowSingleLineStatement$set = true;
            return this;
        }

        public NeedBracesBuilder allowEmptyLoopBody(boolean allowEmptyLoopBody) {
            this.allowEmptyLoopBody$value = allowEmptyLoopBody;
            this.allowEmptyLoopBody$set = true;
            return this;
        }

        public NeedBracesBuilder tokens(Set<Token> tokens) {
            this.tokens$value = tokens;
            this.tokens$set = true;
            return this;
        }

        public NeedBraces build() {
            boolean allowSingleLineStatement$value = this.allowSingleLineStatement$value;
            if (!this.allowSingleLineStatement$set) {
                allowSingleLineStatement$value = NeedBraces.$default$allowSingleLineStatement();
            }
            boolean allowEmptyLoopBody$value = this.allowEmptyLoopBody$value;
            if (!this.allowEmptyLoopBody$set) {
                allowEmptyLoopBody$value = NeedBraces.$default$allowEmptyLoopBody();
            }
            Set<Token> tokens$value = this.tokens$value;
            if (!this.tokens$set) {
                tokens$value = NeedBraces.$default$tokens();
            }
            return new NeedBraces(allowSingleLineStatement$value, allowEmptyLoopBody$value, tokens$value);
        }

        public String toString() {
            return "NeedBraces.NeedBracesBuilder(allowSingleLineStatement$value=" + this.allowSingleLineStatement$value + ", allowEmptyLoopBody$value=" + this.allowEmptyLoopBody$value + ", tokens$value=" + this.tokens$value + ")";
        }
    }
}

