/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.checkstyle.check;

import java.util.Set;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.checkstyle.check.SpansMultipleLines;
import org.openrewrite.checkstyle.policy.RightCurlyPolicy;
import org.openrewrite.checkstyle.policy.Token;
import org.openrewrite.java.refactor.JavaRefactorVisitor;
import org.openrewrite.java.tree.J;

public class RightCurly
extends JavaRefactorVisitor {
    private final RightCurlyPolicy option;
    private final Set<Token> tokens;

    public String getName() {
        return "checkstyle.RightCurly";
    }

    public boolean isCursored() {
        return true;
    }

    public J visitBlock(J.Block<J> block) {
        String suffix;
        boolean satisfiesPolicy;
        J.Block b = (J.Block)this.refactor((Tree)block, x$0 -> super.visitBlock(x$0));
        Cursor parentCursor = this.getCursor().getParentOrThrow();
        boolean tokenMatches = this.tokens.stream().anyMatch(t -> t.getMatcher().matches(this.getCursor())) || this.option != RightCurlyPolicy.ALONE_OR_SINGLELINE && this.tokens.stream().anyMatch(t -> t.getMatcher().matches(parentCursor)) || parentCursor.getTree() instanceof J.Block;
        boolean bl = satisfiesPolicy = block.getEndOfBlockSuffix().contains("\n") || this.option != RightCurlyPolicy.ALONE && (Boolean)new SpansMultipleLines((J)block, null).visit((Tree)block) == false;
        if (tokenMatches && !satisfiesPolicy && parentCursor.firstEnclosing(J.Block.class) != null && (b = b.withEndOfBlockSuffix(suffix = this.formatter.findIndent(((J.Block)this.getCursor().getParentOrThrow().firstEnclosing(J.Block.class)).getIndent(), new Tree[]{this.getCursor().getParentOrThrow().getTree()}).getPrefix())).getStatements().size() == 1) {
            b.getStatements().set(0, (J)((J)b.getStatements().get(0)).withFormatting(this.formatter.format((Tree)b)));
        }
        return b;
    }

    public J visitElse(J.If.Else elze) {
        J.If.Else e = (J.If.Else)this.refactor((Tree)elze, x$0 -> super.visitElse(x$0));
        if (this.tokens.contains((Object)Token.LITERAL_ELSE) && !this.multiBlockSatisfiesPolicy((Tree)elze)) {
            e = this.formatMultiBlock(e);
        }
        return e;
    }

    public J visitFinally(J.Try.Finally finallie) {
        J.Try.Finally f = (J.Try.Finally)this.refactor((Tree)finallie, x$0 -> super.visitFinally(x$0));
        if (this.tokens.contains((Object)Token.LITERAL_FINALLY) && !this.multiBlockSatisfiesPolicy((Tree)finallie)) {
            f = this.formatMultiBlock(f);
        }
        return f;
    }

    public J visitCatch(J.Try.Catch catzh) {
        J.Try.Catch c = (J.Try.Catch)this.refactor((Tree)catzh, x$0 -> super.visitCatch(x$0));
        if (this.tokens.contains((Object)Token.LITERAL_CATCH) && !this.multiBlockSatisfiesPolicy((Tree)catzh)) {
            c = this.formatMultiBlock(c);
        }
        return c;
    }

    private boolean multiBlockSatisfiesPolicy(Tree blockFollower) {
        boolean isAlone = blockFollower.getFormatting().getPrefix().contains("\n");
        return this.option == RightCurlyPolicy.SAME != isAlone;
    }

    private <T extends J> T formatMultiBlock(T tree) {
        return (T)(this.option == RightCurlyPolicy.SAME ? (J)tree.withPrefix(" ") : (J)tree.withFormatting(this.formatter.format((Tree)this.enclosingBlock())));
    }

    private static RightCurlyPolicy $default$option() {
        return RightCurlyPolicy.ALONE;
    }

    private static Set<Token> $default$tokens() {
        return Set.of(Token.LITERAL_TRY, Token.LITERAL_CATCH, Token.LITERAL_FINALLY, Token.LITERAL_IF, Token.LITERAL_ELSE);
    }

    RightCurly(RightCurlyPolicy option, Set<Token> tokens) {
        this.option = option;
        this.tokens = tokens;
    }

    public static RightCurlyBuilder builder() {
        return new RightCurlyBuilder();
    }

    public static class RightCurlyBuilder {
        private boolean option$set;
        private RightCurlyPolicy option$value;
        private boolean tokens$set;
        private Set<Token> tokens$value;

        RightCurlyBuilder() {
        }

        public RightCurlyBuilder option(RightCurlyPolicy option) {
            this.option$value = option;
            this.option$set = true;
            return this;
        }

        public RightCurlyBuilder tokens(Set<Token> tokens) {
            this.tokens$value = tokens;
            this.tokens$set = true;
            return this;
        }

        public RightCurly build() {
            RightCurlyPolicy option$value = this.option$value;
            if (!this.option$set) {
                option$value = RightCurly.$default$option();
            }
            Set<Token> tokens$value = this.tokens$value;
            if (!this.tokens$set) {
                tokens$value = RightCurly.$default$tokens();
            }
            return new RightCurly(option$value, tokens$value);
        }

        public String toString() {
            return "RightCurly.RightCurlyBuilder(option$value=" + this.option$value + ", tokens$value=" + this.tokens$value + ")";
        }
    }
}

