/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.checkstyle.check;

import org.openrewrite.SourceVisitor;
import org.openrewrite.Tree;
import org.openrewrite.java.refactor.JavaRefactorVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

public class SimplifyBooleanExpression
extends JavaRefactorVisitor {
    private int pass = 0;

    public SimplifyBooleanExpression() {
    }

    public SimplifyBooleanExpression(int pass) {
        this.pass = pass;
    }

    public String getName() {
        return "checkstyle.SimplifyBooleanExpression";
    }

    public boolean isCursored() {
        return true;
    }

    public J visitCompilationUnit(J.CompilationUnit cu) {
        J.CompilationUnit c = (J.CompilationUnit)this.refactor((Tree)cu, x$0 -> super.visitCompilationUnit(x$0));
        if (c != cu) {
            this.andThen((SourceVisitor)new SimplifyBooleanExpression(this.pass + 1));
        }
        return c;
    }

    public J visitBinary(J.Binary binary) {
        J.Binary b = (J.Binary)this.refactor((Tree)binary, x$0 -> super.visitBinary(x$0));
        if (b.getOperator() instanceof J.Binary.Operator.And) {
            if (this.isLiteralFalse(b.getLeft())) {
                return this.binaryLeftAndUnwrap(b);
            }
            if (this.isLiteralFalse(b.getRight())) {
                return this.binaryRightAndUnwrap(b);
            }
            if (b.getLeft().printTrimmed().replaceAll("\\s", "").equals(b.getRight().printTrimmed().replaceAll("\\s", ""))) {
                return this.binaryLeftAndUnwrap(b);
            }
        } else if (b.getOperator() instanceof J.Binary.Operator.Or) {
            if (this.isLiteralTrue(b.getLeft())) {
                return this.binaryLeftAndUnwrap(b);
            }
            if (this.isLiteralTrue(b.getRight())) {
                return this.binaryRightAndUnwrap(b);
            }
            if (b.getLeft().printTrimmed().replaceAll("\\s", "").equals(b.getRight().printTrimmed().replaceAll("\\s", ""))) {
                return this.binaryLeftAndUnwrap(b);
            }
        } else if (b.getOperator() instanceof J.Binary.Operator.Equal) {
            if (this.isLiteralTrue(b.getLeft())) {
                return this.binaryRightAndUnwrap(b);
            }
            if (this.isLiteralTrue(b.getRight())) {
                return this.binaryLeftAndUnwrap(b);
            }
        } else if (b.getOperator() instanceof J.Binary.Operator.NotEqual) {
            if (this.isLiteralFalse(b.getLeft())) {
                return this.binaryRightAndUnwrap(b);
            }
            if (this.isLiteralFalse(b.getRight())) {
                return this.binaryLeftAndUnwrap(b);
            }
        }
        return b;
    }

    public J visitUnary(J.Unary unary) {
        J.Unary u = (J.Unary)this.refactor((Tree)unary, x$0 -> super.visitUnary(x$0));
        if (u.getOperator() instanceof J.Unary.Operator.Not) {
            if (this.isLiteralTrue(u.getExpr())) {
                this.maybeUnwrapParentheses();
                return new J.Literal(Tree.randomId(), (Object)false, "false", JavaType.Primitive.Boolean, u.getFormatting());
            }
            if (this.isLiteralFalse(u.getExpr())) {
                this.maybeUnwrapParentheses();
                return new J.Literal(Tree.randomId(), (Object)true, "true", JavaType.Primitive.Boolean, u.getFormatting());
            }
            if (u.getExpr() instanceof J.Unary && ((J.Unary)u.getExpr()).getOperator() instanceof J.Unary.Operator.Not) {
                this.maybeUnwrapParentheses();
                return (J)((J.Unary)u.getExpr()).getExpr().withFormatting(u.getFormatting());
            }
        }
        return u;
    }

    private Expression binaryLeftAndUnwrap(J.Binary binary) {
        this.maybeUnwrapParentheses();
        return (Expression)binary.getLeft().withFormatting(binary.getFormatting());
    }

    private Expression binaryRightAndUnwrap(J.Binary binary) {
        this.maybeUnwrapParentheses(this.getCursor().getParent());
        return (Expression)binary.getRight().withFormatting(binary.getFormatting());
    }

    private void maybeUnwrapParentheses() {
        this.maybeUnwrapParentheses(this.getCursor().getParent());
    }

    private boolean isLiteralTrue(Expression expression) {
        return expression instanceof J.Literal && ((J.Literal)expression).getValue() == Boolean.valueOf(true);
    }

    private boolean isLiteralFalse(Expression expression) {
        return expression instanceof J.Literal && ((J.Literal)expression).getValue() == Boolean.valueOf(false);
    }
}

