/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.checkstyle.check;

import java.util.Spliterators;
import java.util.UUID;
import java.util.stream.StreamSupport;
import org.openrewrite.ScopedVisitorSupport;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaSourceVisitor;
import org.openrewrite.java.tree.J;

class SpansMultipleLines
extends JavaSourceVisitor<Boolean>
implements ScopedVisitorSupport {
    private final UUID scope;
    @Nullable
    private final J skip;

    SpansMultipleLines(J scope, J skip) {
        this.scope = scope.getId();
        this.skip = skip;
    }

    public boolean isCursored() {
        return true;
    }

    public Boolean defaultTo(Tree t) {
        return false;
    }

    public Boolean visitTree(Tree tree) {
        if (this.isScope()) {
            if (tree instanceof J.Block && ((J.Block)tree).getEndOfBlockSuffix().contains("\n")) {
                return true;
            }
            return (Boolean)super.visitTree(tree);
        }
        if (this.isScopeInCursorPath() && !this.isSkipInCursorPath()) {
            if (tree instanceof J.Block && ((J.Block)tree).getEndOfBlockSuffix().contains("\n")) {
                return true;
            }
            return tree != null && tree.getFormatting().getPrefix().contains("\n") || (Boolean)super.visitTree(tree) != false;
        }
        return false;
    }

    private boolean isSkipInCursorPath() {
        Tree t = this.getCursor().getTree();
        return this.skip != null && (t != null && t.getId().equals(this.skip.getId()) || StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.getCursor().getPath(), 0), false).anyMatch(p -> p.getId().equals(this.skip.getId())));
    }

    public UUID getScope() {
        return this.scope;
    }
}

