/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.checkstyle.check;

import java.util.function.Function;
import org.openrewrite.SourceVisitor;
import org.openrewrite.java.refactor.ChangeFieldName;
import org.openrewrite.java.refactor.JavaRefactorVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class StaticVariableName
extends JavaRefactorVisitor {
    private String format;
    private final Function<String, String> renamer;
    private final boolean applyToPublic;
    private final boolean applyToProtected;
    private final boolean applyToPackage;
    private final boolean applyToPrivate;

    public String getName() {
        return "checkstyle.StaticVariableName";
    }

    public boolean isCursored() {
        return true;
    }

    public J visitVariable(J.VariableDecls.NamedVar variable) {
        J.VariableDecls multiVariable = (J.VariableDecls)this.getCursor().getParentOrThrow().getTree();
        if (multiVariable.hasModifier("static") && (this.applyToPublic && multiVariable.hasModifier("public") || this.applyToProtected && multiVariable.hasModifier("protected") || this.applyToPrivate && multiVariable.hasModifier("private") || this.applyToPackage && !multiVariable.hasModifier("public") && !multiVariable.hasModifier("protected") && !multiVariable.hasModifier("private"))) {
            JavaType.Class containingClassType = TypeUtils.asClass((JavaType)this.enclosingClass().getType());
            this.andThen((SourceVisitor)new ChangeFieldName(containingClassType, variable.getSimpleName(), this.renamer.apply(variable.getSimpleName())));
        }
        return super.visitVariable(variable);
    }

    static String snakeCaseToCamel(String value) {
        if (!value.matches("([A-Z0-9]+_*)+")) {
            return value;
        }
        StringBuilder camelName = new StringBuilder();
        char last = '\u0000';
        for (char c : value.toCharArray()) {
            if (c != '_') {
                camelName.append(last == '_' ? c : Character.toLowerCase(c));
            }
            last = c;
        }
        return camelName.toString();
    }

    private static String $default$format() {
        return "^[a-z][a-zA-Z0-9]*$";
    }

    private static Function<String, String> $default$renamer() {
        return StaticVariableName::snakeCaseToCamel;
    }

    private static boolean $default$applyToPublic() {
        return true;
    }

    private static boolean $default$applyToProtected() {
        return true;
    }

    private static boolean $default$applyToPackage() {
        return true;
    }

    private static boolean $default$applyToPrivate() {
        return true;
    }

    StaticVariableName(String format, Function<String, String> renamer, boolean applyToPublic, boolean applyToProtected, boolean applyToPackage, boolean applyToPrivate) {
        this.format = format;
        this.renamer = renamer;
        this.applyToPublic = applyToPublic;
        this.applyToProtected = applyToProtected;
        this.applyToPackage = applyToPackage;
        this.applyToPrivate = applyToPrivate;
    }

    public static StaticVariableNameBuilder builder() {
        return new StaticVariableNameBuilder();
    }

    public static class StaticVariableNameBuilder {
        private boolean format$set;
        private String format$value;
        private boolean renamer$set;
        private Function<String, String> renamer$value;
        private boolean applyToPublic$set;
        private boolean applyToPublic$value;
        private boolean applyToProtected$set;
        private boolean applyToProtected$value;
        private boolean applyToPackage$set;
        private boolean applyToPackage$value;
        private boolean applyToPrivate$set;
        private boolean applyToPrivate$value;

        StaticVariableNameBuilder() {
        }

        public StaticVariableNameBuilder format(String format) {
            this.format$value = format;
            this.format$set = true;
            return this;
        }

        public StaticVariableNameBuilder renamer(Function<String, String> renamer) {
            this.renamer$value = renamer;
            this.renamer$set = true;
            return this;
        }

        public StaticVariableNameBuilder applyToPublic(boolean applyToPublic) {
            this.applyToPublic$value = applyToPublic;
            this.applyToPublic$set = true;
            return this;
        }

        public StaticVariableNameBuilder applyToProtected(boolean applyToProtected) {
            this.applyToProtected$value = applyToProtected;
            this.applyToProtected$set = true;
            return this;
        }

        public StaticVariableNameBuilder applyToPackage(boolean applyToPackage) {
            this.applyToPackage$value = applyToPackage;
            this.applyToPackage$set = true;
            return this;
        }

        public StaticVariableNameBuilder applyToPrivate(boolean applyToPrivate) {
            this.applyToPrivate$value = applyToPrivate;
            this.applyToPrivate$set = true;
            return this;
        }

        public StaticVariableName build() {
            String format$value = this.format$value;
            if (!this.format$set) {
                format$value = StaticVariableName.$default$format();
            }
            Function<String, String> renamer$value = this.renamer$value;
            if (!this.renamer$set) {
                renamer$value = StaticVariableName.$default$renamer();
            }
            boolean applyToPublic$value = this.applyToPublic$value;
            if (!this.applyToPublic$set) {
                applyToPublic$value = StaticVariableName.$default$applyToPublic();
            }
            boolean applyToProtected$value = this.applyToProtected$value;
            if (!this.applyToProtected$set) {
                applyToProtected$value = StaticVariableName.$default$applyToProtected();
            }
            boolean applyToPackage$value = this.applyToPackage$value;
            if (!this.applyToPackage$set) {
                applyToPackage$value = StaticVariableName.$default$applyToPackage();
            }
            boolean applyToPrivate$value = this.applyToPrivate$value;
            if (!this.applyToPrivate$set) {
                applyToPrivate$value = StaticVariableName.$default$applyToPrivate();
            }
            return new StaticVariableName(format$value, renamer$value, applyToPublic$value, applyToProtected$value, applyToPackage$value, applyToPrivate$value);
        }

        public String toString() {
            return "StaticVariableName.StaticVariableNameBuilder(format$value=" + this.format$value + ", renamer$value=" + this.renamer$value + ", applyToPublic$value=" + this.applyToPublic$value + ", applyToProtected$value=" + this.applyToProtected$value + ", applyToPackage$value=" + this.applyToPackage$value + ", applyToPrivate$value=" + this.applyToPrivate$value + ")";
        }
    }
}

