/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.checkstyle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.openrewrite.Cursor;
import org.openrewrite.Formatting;
import org.openrewrite.Tree;
import org.openrewrite.checkstyle.CheckstyleRefactorVisitor;
import org.openrewrite.config.AutoConfigure;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.TreeBuilder;
import org.openrewrite.java.tree.TypeUtils;

@AutoConfigure
public class CovariantEquals
extends CheckstyleRefactorVisitor {
    public CovariantEquals() {
        this.setCursoringOn();
    }

    public J visitMethod(J.MethodDecl method) {
        J.MethodDecl m = (J.MethodDecl)this.refactor((Tree)method, x$0 -> super.visitMethod(x$0));
        JavaType.Class classType = TypeUtils.asClass((JavaType)this.enclosingClass().getType());
        if (method.getSimpleName().equals("equals") && method.hasModifier("public") && method.getReturnTypeExpr() != null && JavaType.Primitive.Boolean.equals((Object)method.getReturnTypeExpr().getType()) && method.getParams().getParams().size() == 1 && method.getParams().getParams().stream().allMatch(p -> p.hasClassType(classType))) {
            String methodIndent;
            String methodPrefix = this.methodFormattingPrefix(method);
            if (!(m = this.maybeAddOverrideAnnotation(m, methodPrefix, methodIndent = this.formatter.findIndent(this.enclosingBlock().getIndent(), new Tree[]{method}).getPrefix())).getModifiers().isEmpty()) {
                m = m.withModifiers(Formatting.formatFirstPrefix((List)m.getModifiers(), (String)methodIndent));
            }
            J.VariableDecls.NamedVar oldParamName = (J.VariableDecls.NamedVar)((J.VariableDecls)method.getParams().getParams().iterator().next()).getVars().iterator().next();
            J.VariableDecls.NamedVar paramName = oldParamName.withName(oldParamName.getName().withName("o".equals(oldParamName.getSimpleName()) ? "other" : "o"));
            m = this.changeParameterNameAndType(m, paramName);
            m = this.addEqualsBody(m, oldParamName, paramName);
        }
        return m;
    }

    private J.MethodDecl addEqualsBody(J.MethodDecl method, J.VariableDecls.NamedVar oldParamName, J.VariableDecls.NamedVar paramName) {
        String paramNameStr = paramName.printTrimmed();
        List equalsBody = TreeBuilder.buildSnippet((J.CompilationUnit)this.enclosingCompilationUnit(), (Cursor)new Cursor(this.getCursor(), (Tree)method.getBody()), (String)("if (this == " + paramNameStr + ") return true;\nif (" + paramNameStr + " == null || getClass() != " + paramNameStr + ".getClass()) return false;\nTest " + oldParamName.printTrimmed() + " = (Test) " + paramNameStr + ";\n"), (JavaType.Class[])new JavaType.Class[0]);
        equalsBody.addAll(method.getBody().getStatements());
        return method.withBody(method.getBody().withStatements(equalsBody));
    }

    private J.MethodDecl changeParameterNameAndType(J.MethodDecl method, J.VariableDecls.NamedVar paramName) {
        return method.withParams(method.getParams().withParams(method.getParams().getParams().stream().map(p -> ((J.VariableDecls)p).withVars(Collections.singletonList(paramName)).withTypeExpr(TreeBuilder.buildName((String)"Object"))).collect(Collectors.toList())));
    }

    private J.MethodDecl maybeAddOverrideAnnotation(J.MethodDecl method, String methodPrefix, String methodIndent) {
        if (method.getAnnotations().stream().noneMatch(ann -> TypeUtils.isOfClassType((JavaType)ann.getType(), (String)"java.lang.Override"))) {
            ArrayList<J.Annotation> annotations = new ArrayList<J.Annotation>(method.getAnnotations());
            annotations.add(new J.Annotation(Tree.randomId(), (NameTree)J.Ident.build((UUID)Tree.randomId(), (String)"Override", (JavaType)JavaType.Class.build((String)"java.lang.Override"), (Formatting)Formatting.EMPTY), null, method.getAnnotations().isEmpty() ? Formatting.format((String)methodPrefix) : Formatting.format((String)methodIndent)));
            return method.withAnnotations(annotations);
        }
        return method;
    }

    private String methodFormattingPrefix(J.MethodDecl method) {
        if (!method.getAnnotations().isEmpty()) {
            return ((J.Annotation)method.getAnnotations().iterator().next()).getFormatting().getPrefix();
        }
        return ((J.Modifier)method.getModifiers().iterator().next()).getFormatting().getPrefix();
    }
}

