/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.checkstyle;

import org.openrewrite.Tree;
import org.openrewrite.checkstyle.CheckstyleRefactorVisitor;
import org.openrewrite.checkstyle.policy.PadPolicy;
import org.openrewrite.config.AutoConfigure;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;

@AutoConfigure
public class EmptyForInitializerPad
extends CheckstyleRefactorVisitor {
    private PadPolicy option;

    @Override
    protected void configure(CheckstyleRefactorVisitor.Module m) {
        this.option = m.propAsOptionValue(PadPolicy::valueOf, PadPolicy.NOSPACE);
    }

    public J visitForLoop(J.ForLoop forLoop) {
        J.ForLoop f = (J.ForLoop)this.refactor((Tree)forLoop, x$0 -> super.visitForLoop(x$0));
        String prefix = forLoop.getControl().getInit().getFormatting().getPrefix();
        if (!prefix.startsWith("\n") && (this.option == PadPolicy.NOSPACE ? prefix.startsWith(" ") || prefix.startsWith("\t") : prefix.isEmpty()) && forLoop.getControl().getInit() instanceof J.Empty) {
            Statement init = f.getControl().getInit();
            String fixedPrefix = this.option == PadPolicy.NOSPACE ? "" : " ";
            f = f.withControl(f.getControl().withInit((Statement)init.withPrefix(fixedPrefix)));
        }
        return f;
    }
}

