/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.checkstyle;

import java.util.List;
import org.openrewrite.Cursor;
import org.openrewrite.Formatting;
import org.openrewrite.Tree;
import org.openrewrite.checkstyle.CheckstyleRefactorVisitor;
import org.openrewrite.config.AutoConfigure;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

@AutoConfigure
public class ExplicitInitialization
extends CheckstyleRefactorVisitor {
    private boolean onlyObjectReferences;

    public ExplicitInitialization() {
        this.setCursoringOn();
    }

    @Override
    protected void configure(CheckstyleRefactorVisitor.Module m) {
        this.onlyObjectReferences = m.prop("onlyObjectReferences", false);
    }

    public J visitVariable(J.VariableDecls.NamedVar variable) {
        J.Literal literalInit;
        J.VariableDecls.NamedVar v = (J.VariableDecls.NamedVar)this.refactor((Tree)variable, x$0 -> super.visitVariable(x$0));
        Cursor variableDeclsCursor = this.getCursor().getParentOrThrow();
        if (!(variableDeclsCursor.getParentOrThrow().getParentOrThrow().getTree() instanceof J.ClassDecl)) {
            return v;
        }
        JavaType.Primitive primitive = TypeUtils.asPrimitive((JavaType)variable.getType());
        JavaType.Array array = TypeUtils.asArray((JavaType)variable.getType());
        J tree = (J)variableDeclsCursor.getTree();
        if (!(tree instanceof J.VariableDecls)) {
            return v;
        }
        J.VariableDecls variableDecls = (J.VariableDecls)tree;
        J.Literal literal = literalInit = variable.getInitializer() instanceof J.Literal ? (J.Literal)variable.getInitializer() : null;
        if (literalInit != null && !variableDecls.hasModifier("final")) {
            if (TypeUtils.asClass((JavaType)variable.getType()) != null && JavaType.Primitive.Null.equals((Object)literalInit.getType())) {
                v = v.withInitializer(null).withName((J.Ident)Formatting.stripSuffix((Tree)v.getName()));
            } else if (primitive != null && !this.onlyObjectReferences) {
                switch (primitive) {
                    case Boolean: {
                        if (literalInit.getValue() != Boolean.valueOf(false)) break;
                        v = v.withInitializer(null).withName((J.Ident)Formatting.stripSuffix((Tree)v.getName()));
                        break;
                    }
                    case Char: {
                        if (literalInit.getValue() == null || ((Character)literalInit.getValue()).charValue() != '\u0000') break;
                        v = v.withInitializer(null).withName((J.Ident)Formatting.stripSuffix((Tree)v.getName()));
                        break;
                    }
                    case Int: 
                    case Long: 
                    case Short: {
                        if (literalInit.getValue() == null || ((Number)literalInit.getValue()).intValue() != 0) break;
                        v = v.withInitializer(null).withName((J.Ident)Formatting.stripSuffix((Tree)v.getName()));
                    }
                }
            } else if (array != null && JavaType.Primitive.Null.equals((Object)literalInit.getType())) {
                v = v.withInitializer(null).withDimensionsAfterName(Formatting.formatLastSuffix((List)v.getDimensionsAfterName(), (String)""));
            }
        }
        return v;
    }
}

