/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.checkstyle;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.openrewrite.SourceVisitor;
import org.openrewrite.Tree;
import org.openrewrite.checkstyle.CheckstyleRefactorVisitor;
import org.openrewrite.config.AutoConfigure;
import org.openrewrite.java.JavaRefactorVisitor;
import org.openrewrite.java.JavaSourceVisitor;
import org.openrewrite.java.tree.J;

@AutoConfigure
public class FallThrough
extends CheckstyleRefactorVisitor {
    private boolean checkLastCaseGroup;
    private Pattern reliefPattern;
    private final Set<UUID> casesToAddBreak = new HashSet<UUID>();

    public FallThrough() {
        this.setCursoringOn();
    }

    @Override
    protected void configure(CheckstyleRefactorVisitor.Module m) {
        this.checkLastCaseGroup = m.prop("checkLastCaseGroup", false);
        this.reliefPattern = m.prop("reliefPattern", Pattern.compile("falls?[ -]?thr(u|ough)"));
    }

    public void nextCycle() {
        this.casesToAddBreak.clear();
        super.nextCycle();
    }

    public J visitCase(J.Case caze) {
        J.Switch switzh = (J.Switch)this.getCursor().getParentOrThrow().getParentOrThrow().getTree();
        if ((this.checkLastCaseGroup || !this.isLastCase(caze)) && !((Boolean)new LastLineBreaksOrFallsThrough(caze).visit((Tree)switzh)).booleanValue() && this.casesToAddBreak.add(caze.getId())) {
            this.andThen((SourceVisitor)new AddBreak(caze));
        }
        return super.visitCase(caze);
    }

    private boolean isLastCase(J.Case caze) {
        J.Block switchBlock = (J.Block)this.getCursor().getParentOrThrow().getTree();
        return caze == switchBlock.getStatements().get(switchBlock.getStatements().size() - 1);
    }

    private class LastLineBreaksOrFallsThrough
    extends JavaSourceVisitor<Boolean> {
        private final J.Case scope;

        private LastLineBreaksOrFallsThrough(J.Case scope) {
            this.scope = scope;
        }

        public Boolean defaultTo(Tree t) {
            return false;
        }

        public Boolean visitSwitch(J.Switch switzh) {
            List statements = switzh.getCases().getStatements();
            for (int i = 0; i < statements.size() - 1; ++i) {
                J.Case caze = (J.Case)statements.get(i);
                if (caze != this.scope || !FallThrough.this.reliefPattern.matcher(((J.Case)statements.get(i + 1)).getFormatting().getPrefix()).find()) continue;
                return true;
            }
            return (Boolean)super.visitSwitch(switzh);
        }

        public Boolean visitCase(J.Case caze) {
            return caze == this.scope && (this.lastLineBreaksOrFallsThrough(caze.getStatements()) || (Boolean)super.visitCase(caze) != false);
        }

        public Boolean visitBlock(J.Block<J> block) {
            return this.lastLineBreaksOrFallsThrough(block.getStatements()) || FallThrough.this.reliefPattern.matcher(block.getEndOfBlockSuffix()).find() || (Boolean)super.visitBlock(block) != false;
        }

        private boolean lastLineBreaksOrFallsThrough(List<? extends Tree> trees) {
            return trees.stream().reduce((s1, s2) -> s2).map(s -> s instanceof J.Return || s instanceof J.Break || s instanceof J.Continue || s instanceof J.Empty && FallThrough.this.reliefPattern.matcher(s.getFormatting().getPrefix()).find() || FallThrough.this.reliefPattern.matcher(s.getFormatting().getSuffix()).find()).orElse(false);
        }
    }

    private static class AddBreak
    extends JavaRefactorVisitor {
        private final J.Case scope;

        public AddBreak(J.Case scope) {
            this.scope = scope;
            this.setCursoringOn();
        }

        public J visitCase(J.Case caze) {
            J.Case c = (J.Case)this.refactor((Tree)caze, x$0 -> super.visitCase(x$0));
            if (this.scope.isScope((Tree)caze) && c.getStatements().stream().noneMatch(s -> s instanceof J.Break) && c.getStatements().stream().reduce((s1, s2) -> s2).map(s -> !(s instanceof J.Block)).orElse(true).booleanValue()) {
                ArrayList<J.Break> statements = new ArrayList<J.Break>(c.getStatements());
                J.Block switchBlock = (J.Block)this.getCursor().getParentOrThrow().getTree();
                statements.add(new J.Break(Tree.randomId(), null, this.formatter.format((Tree)switchBlock)));
                c = c.withStatements(statements);
            }
            return c;
        }

        public J visitBlock(J.Block<J> block) {
            J.Block b = (J.Block)this.refactor((Tree)block, x$0 -> super.visitBlock(x$0));
            if (this.getCursor().isScopeInPath((Tree)this.scope) && block.getStatements().stream().noneMatch(s -> s instanceof J.Break) && block.getStatements().stream().reduce((s1, s2) -> s2).map(s -> !(s instanceof J.Block)).orElse(true).booleanValue()) {
                List statements = b.getStatements();
                statements.add(new J.Break(Tree.randomId(), null, this.formatter.format((Tree)b)));
                b = b.withStatements(statements);
            }
            return b;
        }
    }
}

