/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.checkstyle;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.openrewrite.Cursor;
import org.openrewrite.SourceVisitor;
import org.openrewrite.Tree;
import org.openrewrite.checkstyle.CheckstyleRefactorVisitor;
import org.openrewrite.checkstyle.policy.Token;
import org.openrewrite.config.AutoConfigure;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaRefactorVisitor;
import org.openrewrite.java.JavaSourceVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

@AutoConfigure
public class HiddenField
extends CheckstyleRefactorVisitor {
    private static final Pattern NAME_PATTERN = Pattern.compile("(.+)(\\d+)");
    private static final Set<Token> DEFAULT_TOKENS = Set.of(Token.VARIABLE_DEF, Token.PARAMETER_DEF, Token.LAMBDA);
    @Nullable
    private Pattern ignoreFormat;
    private boolean ignoreConstructorParameter;
    private boolean ignoreSetter;
    private boolean setterCanReturnItsClass;
    private boolean ignoreAbstractMethods;
    private Set<Token> tokens;

    public HiddenField() {
        this.setCursoringOn();
    }

    @Override
    protected void configure(CheckstyleRefactorVisitor.Module m) {
        this.ignoreFormat = m.prop("ignoreFormat", null);
        this.ignoreConstructorParameter = m.prop("ignoreConstructorParameter", false);
        this.ignoreSetter = m.prop("ignoreSetter", false);
        this.setterCanReturnItsClass = m.prop("setterCanReturnItsClass", false);
        this.ignoreAbstractMethods = m.prop("ignoreAbstractMethods", false);
        this.tokens = m.propAsTokens(Token.class, DEFAULT_TOKENS);
    }

    public J visitClassDecl(J.ClassDecl classDecl) {
        List visibleSupertypeMembers = TypeUtils.getVisibleSupertypeMembers((JavaType)classDecl.getType());
        List<J.VariableDecls.NamedVar> shadows = visibleSupertypeMembers.stream().filter(member -> this.ignoreFormat == null || !this.ignoreFormat.matcher(member.getName()).matches()).flatMap(member -> ((List)new FindNameShadows(member.getName(), this.enclosingClass()).visit((Tree)classDecl.getBody())).stream()).collect(Collectors.toList());
        if (!shadows.isEmpty()) {
            shadows.forEach(shadow -> this.andThen((SourceVisitor)new RenameShadowedName((J.VariableDecls.NamedVar)shadow, visibleSupertypeMembers)));
        }
        return super.visitClassDecl(classDecl);
    }

    public J visitVariable(J.VariableDecls.NamedVar variable) {
        Cursor parent = this.getCursor().getParentOrThrow().getParentOrThrow().getParentOrThrow();
        if (parent.getTree() instanceof J.ClassDecl && (this.ignoreFormat == null || !this.ignoreFormat.matcher(variable.getSimpleName()).matches())) {
            J.ClassDecl classDecl = (J.ClassDecl)parent.getTree();
            List shadows = (List)new FindNameShadows(variable, this.enclosingClass()).visit((Tree)this.enclosingBlock());
            if (!shadows.isEmpty()) {
                shadows.forEach(shadow -> this.andThen((SourceVisitor)new RenameShadowedName((J.VariableDecls.NamedVar)shadow, TypeUtils.getVisibleSupertypeMembers((JavaType)classDecl.getType()))));
            }
        }
        return super.visitVariable(variable);
    }

    private static class RenameShadowedName
    extends JavaRefactorVisitor {
        private final J.VariableDecls.NamedVar scope;
        private final List<JavaType.Var> supertypeMembers;

        public RenameShadowedName(J.VariableDecls.NamedVar scope, List<JavaType.Var> supertypeMembers) {
            this.scope = scope;
            this.supertypeMembers = supertypeMembers;
            this.setCursoringOn();
        }

        public J visitVariable(J.VariableDecls.NamedVar variable) {
            J.VariableDecls.NamedVar v = (J.VariableDecls.NamedVar)this.refactor((Tree)variable, x$0 -> super.visitVariable(x$0));
            if (this.scope.isScope((Tree)variable)) {
                String nextName = this.nextName(v.getSimpleName());
                while (this.matchesSupertypeMember(nextName) || ((Boolean)new ShadowsName(this.getCursor(), nextName).visit((Tree)this.enclosingCompilationUnit())).booleanValue()) {
                    nextName = this.nextName(nextName);
                }
                v = v.withName(v.getName().withName(nextName));
            }
            return v;
        }

        private boolean matchesSupertypeMember(String nextName) {
            return this.supertypeMembers.stream().anyMatch(m -> m.getName().equals(nextName));
        }

        private String nextName(String name) {
            Matcher nameMatcher = NAME_PATTERN.matcher(name);
            return nameMatcher.matches() ? nameMatcher.group(1) + (Integer.parseInt(nameMatcher.group(2)) + 1) : name + "1";
        }
    }

    private static class ShadowsName
    extends JavaSourceVisitor<Boolean> {
        private final Cursor scope;
        private final String name;

        private ShadowsName(Cursor scope, String name) {
            this.scope = scope;
            this.name = name;
            this.setCursoringOn();
        }

        public Boolean defaultTo(Tree t) {
            return false;
        }

        public Boolean visitVariable(J.VariableDecls.NamedVar variable) {
            return variable != this.scope.getTree() && this.isInSameNameScope(this.scope) && variable.getSimpleName().equals(this.name) || (Boolean)super.visitVariable(variable) != false;
        }
    }

    private class FindNameShadows
    extends JavaSourceVisitor<List<J.VariableDecls.NamedVar>> {
        @Nullable
        private final J.VariableDecls.NamedVar thatLookLike;
        private final String thatLookLikeName;
        private final J.ClassDecl enclosingClass;

        public FindNameShadows(J.VariableDecls.NamedVar thatLookLike, J.ClassDecl enclosingClass) {
            this.enclosingClass = enclosingClass;
            this.thatLookLike = thatLookLike;
            this.thatLookLikeName = thatLookLike.getSimpleName();
            this.setCursoringOn();
        }

        public FindNameShadows(String thatLookLikeName, J.ClassDecl enclosingClass) {
            this.thatLookLike = null;
            this.thatLookLikeName = thatLookLikeName;
            this.enclosingClass = enclosingClass;
            this.setCursoringOn();
        }

        public List<J.VariableDecls.NamedVar> defaultTo(Tree t) {
            return Collections.emptyList();
        }

        public List<J.VariableDecls.NamedVar> visitClassDecl(J.ClassDecl classDecl) {
            if (!(classDecl.getKind() instanceof J.ClassDecl.Kind.Class) || classDecl.hasModifier("static")) {
                return Collections.emptyList();
            }
            return (List)super.visitClassDecl(classDecl);
        }

        public List<J.VariableDecls.NamedVar> visitVariable(J.VariableDecls.NamedVar variable) {
            boolean isIgnorableAbstractMethod;
            List shadows = (List)super.visitVariable(variable);
            Tree maybeMethodDecl = this.getCursor().getParentOrThrow().getParentOrThrow().getTree();
            boolean isIgnorableConstructorParam = HiddenField.this.ignoreConstructorParameter;
            if (isIgnorableConstructorParam) {
                isIgnorableConstructorParam = maybeMethodDecl instanceof J.MethodDecl && ((J.MethodDecl)maybeMethodDecl).isConstructor();
            }
            boolean isIgnorableSetter = HiddenField.this.ignoreSetter;
            if (isIgnorableSetter &= maybeMethodDecl instanceof J.MethodDecl) {
                J.MethodDecl methodDecl = (J.MethodDecl)maybeMethodDecl;
                String methodName = methodDecl.getSimpleName();
                boolean bl = methodName.startsWith("set") && methodDecl.getReturnTypeExpr() != null && (HiddenField.this.setterCanReturnItsClass ? this.enclosingClass.getType().equals(methodDecl.getReturnTypeExpr().getType()) : JavaType.Primitive.Void.equals((Object)methodDecl.getReturnTypeExpr().getType())) && methodName.length() > 3 && variable.getSimpleName().equalsIgnoreCase(methodName.substring(3)) ? true : (isIgnorableSetter = false);
            }
            if (isIgnorableAbstractMethod = HiddenField.this.ignoreAbstractMethods) {
                boolean bl = isIgnorableAbstractMethod = maybeMethodDecl instanceof J.MethodDecl && ((J.MethodDecl)maybeMethodDecl).hasModifier("abstract");
            }
            if (variable != this.thatLookLike && !isIgnorableSetter && !isIgnorableConstructorParam && !isIgnorableAbstractMethod && variable.getSimpleName().equals(this.thatLookLikeName) && HiddenField.this.tokens.stream().anyMatch(t -> t.equals((Object)Token.LAMBDA) ? this.getCursor().getParentOrThrow().getTree() instanceof J.Lambda.Parameters : t.getMatcher().matches(this.getCursor()))) {
                shadows.add(variable);
            }
            return shadows;
        }
    }
}

