/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.checkstyle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.Tree;
import org.openrewrite.checkstyle.CheckstyleRefactorVisitor;
import org.openrewrite.config.AutoConfigure;
import org.openrewrite.java.tree.J;

@AutoConfigure
public class MultipleVariableDeclarations
extends CheckstyleRefactorVisitor {
    public MultipleVariableDeclarations() {
        this.setCursoringOn();
    }

    public J visitBlock(J.Block<J> block) {
        J.Block b = (J.Block)this.refactor((Tree)block, x$0 -> super.visitBlock(x$0));
        AtomicBoolean splitAtLeastOneVariable = new AtomicBoolean(false);
        List statements = block.getStatements().stream().flatMap(s -> s.whenType(J.VariableDecls.class).map(multiVariable -> {
            if (multiVariable.getVars().size() > 1 && this.getCursor().getTree() instanceof J.Block) {
                splitAtLeastOneVariable.set(true);
                J.VariableDecls mv = (J.VariableDecls)s;
                return Stream.concat(Stream.of(mv.withVars(Collections.singletonList((J.VariableDecls.NamedVar)mv.getVars().get(0)))), mv.getVars().stream().skip(1L).map(var -> {
                    ArrayList dimensions = new ArrayList(mv.getDimensionsBeforeName());
                    dimensions.addAll(var.getDimensionsAfterName());
                    return new J.VariableDecls(Tree.randomId(), mv.getAnnotations(), mv.getModifiers(), mv.getTypeExpr(), null, Collections.emptyList(), Collections.singletonList(var.withDimensionsAfterName(dimensions)), this.formatter.format((Tree)block));
                }));
            }
            return Stream.of(s);
        }).orElse(Stream.of(s))).collect(Collectors.toList());
        return splitAtLeastOneVariable.get() ? b.withStatements(statements) : b;
    }
}

