/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.checkstyle;

import java.util.Collections;
import java.util.Set;
import org.openrewrite.Formatting;
import org.openrewrite.Tree;
import org.openrewrite.checkstyle.CheckstyleRefactorVisitor;
import org.openrewrite.checkstyle.SpansMultipleLines;
import org.openrewrite.checkstyle.policy.Token;
import org.openrewrite.config.AutoConfigure;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.refactor.Formatter;

@AutoConfigure
public class NeedBraces
extends CheckstyleRefactorVisitor {
    private static final Set<Token> DEFAULT_TOKENS = Set.of(Token.LITERAL_DO, Token.LITERAL_ELSE, Token.LITERAL_FOR, Token.LITERAL_IF, Token.LITERAL_WHILE);
    private boolean allowSingleLineStatement;
    private boolean allowEmptyLoopBody;
    private Set<Token> tokens;

    public NeedBraces() {
        this.setCursoringOn();
    }

    @Override
    protected void configure(CheckstyleRefactorVisitor.Module m) {
        this.allowSingleLineStatement = m.prop("allowSingleLineStatement", false);
        this.allowEmptyLoopBody = m.prop("allowEmptyLoopBody", false);
        this.tokens = m.propAsTokens(Token.class, DEFAULT_TOKENS);
    }

    public J visitIf(J.If iff) {
        J.If i = (J.If)this.refactor((Tree)iff, x$0 -> super.visitIf(x$0));
        if (this.tokens.contains((Object)Token.LITERAL_IF) && !(iff.getThenPart() instanceof J.Block) && this.isNotAllowableSingleLine()) {
            i = i.withThenPart(this.addBraces(i.getThenPart()));
        }
        return i;
    }

    public J visitElse(J.If.Else elze) {
        J.If.Else e = (J.If.Else)this.refactor((Tree)elze, x$0 -> super.visitElse(x$0));
        if (this.tokens.contains((Object)Token.LITERAL_ELSE) && !(elze.getStatement() instanceof J.If) && !(elze.getStatement() instanceof J.Block) && this.isNotAllowableSingleLine()) {
            e = e.withStatement(this.addBraces(e.getStatement()));
        }
        return e;
    }

    public J visitWhileLoop(J.WhileLoop whileLoop) {
        boolean hasAllowableBodyType;
        J.WhileLoop w = (J.WhileLoop)this.refactor((Tree)whileLoop, x$0 -> super.visitWhileLoop(x$0));
        Statement body = w.getBody();
        boolean bl = this.allowEmptyLoopBody ? body instanceof J.Empty || body instanceof J.Block : (hasAllowableBodyType = body instanceof J.Block);
        if (this.tokens.contains((Object)Token.LITERAL_WHILE) && !hasAllowableBodyType && this.isNotAllowableSingleLine()) {
            w = w.withBody(this.addBraces(w.getBody()));
        }
        return w;
    }

    public J visitDoWhileLoop(J.DoWhileLoop doWhileLoop) {
        J.DoWhileLoop w = (J.DoWhileLoop)this.refactor((Tree)doWhileLoop, x$0 -> super.visitDoWhileLoop(x$0));
        if (this.tokens.contains((Object)Token.LITERAL_DO) && !(w.getBody() instanceof J.Block) && this.isNotAllowableSingleLine()) {
            w = w.withBody(this.addBraces(w.getBody()));
        }
        return w;
    }

    public J visitForLoop(J.ForLoop forLoop) {
        boolean hasAllowableBodyType;
        J.ForLoop f = (J.ForLoop)this.refactor((Tree)forLoop, x$0 -> super.visitForLoop(x$0));
        Statement body = f.getBody();
        boolean bl = this.allowEmptyLoopBody ? body instanceof J.Empty || body instanceof J.Block : (hasAllowableBodyType = body instanceof J.Block);
        if (this.tokens.contains((Object)Token.LITERAL_FOR) && !hasAllowableBodyType && this.isNotAllowableSingleLine()) {
            f = f.withBody(this.addBraces(f.getBody()));
        }
        return f;
    }

    private boolean isNotAllowableSingleLine() {
        return !this.allowSingleLineStatement || (Boolean)new SpansMultipleLines((J)this.getCursor().getTree(), null).visit(this.getCursor().getTree()) != false;
    }

    private Statement addBraces(Statement body) {
        if (body instanceof J.Block) {
            return body;
        }
        int enclosingIndent = ((J.Block)this.getCursor().getParentOrThrow().firstEnclosing(J.Block.class)).getIndent();
        Formatter.Result format = this.formatter.findIndent(enclosingIndent, new Tree[]{this.getCursor().getParentOrThrow().getTree()});
        String originalBodySuffix = body.getFormatting().getSuffix();
        return new J.Block(Tree.randomId(), null, body instanceof J.Empty ? Collections.emptyList() : Collections.singletonList((J)body.withFormatting(Formatting.format((String)format.getPrefix(1)))), Formatting.format((String)" ", (String)originalBodySuffix), format.getPrefix());
    }
}

