/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.checkstyle;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openrewrite.Cursor;
import org.openrewrite.Formatting;
import org.openrewrite.SourceVisitor;
import org.openrewrite.Tree;
import org.openrewrite.checkstyle.CheckstyleRefactorVisitor;
import org.openrewrite.config.AutoConfigure;
import org.openrewrite.java.DeleteStatement;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;

@AutoConfigure
public class SimplifyBooleanReturn
extends CheckstyleRefactorVisitor {
    public SimplifyBooleanReturn() {
        this.setCursoringOn();
    }

    public J visitIf(J.If iff) {
        J.If i = (J.If)this.refactor((Tree)iff, x$0 -> super.visitIf(x$0));
        Cursor parent = this.getCursor().getParentOrThrow();
        if (parent.getTree() instanceof J.Block && parent.getParentOrThrow().getTree() instanceof J.MethodDecl && this.thenHasOnlyReturnStatement(iff) && this.elseWithOnlyReturn(i)) {
            List<Statement> followingStatements = this.followingStatements();
            Optional<Expression> singleFollowingStatement = Optional.ofNullable(followingStatements.isEmpty() ? null : followingStatements.get(0)).flatMap(stat -> Optional.ofNullable(stat instanceof J.Return ? (J.Return)stat : null)).map(J.Return::getExpr);
            if (followingStatements.isEmpty() || singleFollowingStatement.map(r -> this.isLiteralFalse((J)r) || this.isLiteralTrue((J)r)).orElse(false).booleanValue()) {
                J.Return retrn = this.getReturnIfOnlyStatementInThen(iff).orElseThrow();
                Expression ifCondition = (Expression)i.getIfCondition().getTree();
                if (this.isLiteralTrue((J)retrn.getExpr())) {
                    if (singleFollowingStatement.map(this::isLiteralFalse).orElse(false).booleanValue() && i.getElsePart() == null) {
                        this.andThen((SourceVisitor)new DeleteStatement(followingStatements.get(0)));
                        return retrn.withExpr((Expression)ifCondition.withFormatting(Formatting.format((String)" "))).withFormatting(i.getFormatting());
                    }
                    if (singleFollowingStatement.isEmpty() && this.getReturnExprIfOnlyStatementInElseThen(i).map(this::isLiteralFalse).orElse(false).booleanValue()) {
                        if (i.getElsePart() != null) {
                            this.andThen((SourceVisitor)new DeleteStatement(i.getElsePart().getStatement()));
                        }
                        return retrn.withExpr((Expression)ifCondition.withFormatting(Formatting.format((String)" "))).withFormatting(i.getFormatting());
                    }
                } else if (this.isLiteralFalse((J)retrn.getExpr())) {
                    boolean returnThenPart = false;
                    if (singleFollowingStatement.map(this::isLiteralTrue).orElse(false).booleanValue() && i.getElsePart() == null) {
                        this.andThen((SourceVisitor)new DeleteStatement(followingStatements.get(0)));
                        returnThenPart = true;
                    } else if (singleFollowingStatement.isEmpty() && this.getReturnExprIfOnlyStatementInElseThen(i).map(this::isLiteralTrue).orElse(false).booleanValue()) {
                        if (i.getElsePart() != null) {
                            this.andThen((SourceVisitor)new DeleteStatement(i.getElsePart().getStatement()));
                        }
                        returnThenPart = true;
                    }
                    if (returnThenPart) {
                        J.Parentheses maybeParenthesizedCondition = ifCondition instanceof J.Binary || ifCondition instanceof J.Ternary ? new J.Parentheses(Tree.randomId(), (J)ifCondition, Formatting.EMPTY) : ifCondition;
                        return retrn.withExpr((Expression)new J.Unary(Tree.randomId(), (J.Unary.Operator)new J.Unary.Operator.Not(Tree.randomId(), Formatting.EMPTY), (Expression)maybeParenthesizedCondition, (JavaType)JavaType.Primitive.Boolean, Formatting.format((String)" "))).withFormatting(i.getFormatting());
                    }
                }
            }
        }
        return i;
    }

    private boolean elseWithOnlyReturn(J.If i) {
        return i.getElsePart() == null || !(i.getElsePart().getStatement() instanceof J.If);
    }

    private boolean thenHasOnlyReturnStatement(J.If iff) {
        return this.getReturnIfOnlyStatementInThen(iff).map(retrn -> this.isLiteralFalse((J)retrn.getExpr()) || this.isLiteralTrue((J)retrn.getExpr())).orElse(false);
    }

    private List<Statement> followingStatements() {
        J.Block block = (J.Block)this.getCursor().getParentOrThrow().getTree();
        return block.getStatements().stream().dropWhile(s -> s != this.getCursor().getTree()).skip(1L).collect(Collectors.toList());
    }

    private boolean isLiteralTrue(J tree) {
        return tree instanceof J.Literal && ((J.Literal)tree).getValue() == Boolean.valueOf(true);
    }

    private boolean isLiteralFalse(J tree) {
        return tree instanceof J.Literal && ((J.Literal)tree).getValue() == Boolean.valueOf(false);
    }

    private Optional<J.Return> getReturnIfOnlyStatementInThen(J.If iff) {
        J.Block then;
        if (iff.getThenPart() instanceof J.Return) {
            return Optional.of((J.Return)iff.getThenPart());
        }
        if (iff.getThenPart() instanceof J.Block && (then = (J.Block)iff.getThenPart()).getStatements().size() == 1 && then.getStatements().get(0) instanceof J.Return) {
            return Optional.of((J.Return)then.getStatements().get(0));
        }
        return Optional.empty();
    }

    private Optional<Expression> getReturnExprIfOnlyStatementInElseThen(J.If iff2) {
        J statement;
        List statements;
        if (iff2.getElsePart() == null) {
            return Optional.empty();
        }
        Statement elze = iff2.getElsePart().getStatement();
        if (elze instanceof J.Return) {
            return Optional.ofNullable(((J.Return)elze).getExpr());
        }
        if (elze instanceof J.Block && (statements = ((J.Block)elze).getStatements()).size() == 1 && (statement = (J)statements.get(0)) instanceof J.Return) {
            return Optional.ofNullable(((J.Return)statement).getExpr());
        }
        return Optional.empty();
    }
}

