/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.checkstyle;

import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;

final class WhitespaceChecks {
    private WhitespaceChecks() {
    }

    public static boolean prefixStartsWithNonLinebreakWhitespace(@Nullable Tree t) {
        return t != null && WhitespaceChecks.startsWithNonLinebreakWhitespace(t.getFormatting().getPrefix());
    }

    public static boolean suffixStartsWithNonLinebreakWhitespace(@Nullable Tree t) {
        return t != null && WhitespaceChecks.startsWithNonLinebreakWhitespace(t.getFormatting().getSuffix());
    }

    public static boolean startsWithNonLinebreakWhitespace(String prefixOrSuffix) {
        return prefixOrSuffix.startsWith(" ") || prefixOrSuffix.startsWith("\t");
    }

    public static <T extends Tree> T stripSuffixUpToLinebreak(@Nullable T t) {
        return (T)(t == null ? null : t.withSuffix(WhitespaceChecks.stripUpToLinebreak(t.getFormatting().getSuffix())));
    }

    public static <T extends Tree> T stripPrefixUpToLinebreak(@Nullable T t) {
        return (T)(t == null ? null : t.withPrefix(WhitespaceChecks.stripUpToLinebreak(t.getFormatting().getPrefix())));
    }

    public static String stripUpToLinebreak(String prefixOrSuffix) {
        StringBuilder sb = new StringBuilder();
        boolean drop = true;
        for (char c : prefixOrSuffix.toCharArray()) {
            if (drop &= c == ' ' || c == '\t') continue;
            sb.append(c);
        }
        return sb.toString();
    }
}

