/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.checkstyle;

import java.util.Optional;
import java.util.stream.Collectors;
import org.openrewrite.AutoConfigure;
import org.openrewrite.Cursor;
import org.openrewrite.SourceVisitor;
import org.openrewrite.Tree;
import org.openrewrite.checkstyle.CheckstyleRefactorVisitor;
import org.openrewrite.java.DeleteStatement;
import org.openrewrite.java.JavaRefactorVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;

@AutoConfigure
public class EmptyStatement
extends CheckstyleRefactorVisitor {
    public EmptyStatement() {
        this.setCursoringOn();
    }

    public J visitIf(J.If iff) {
        J.If i = (J.If)this.refactor((Tree)iff, x$0 -> super.visitIf(x$0));
        return i.withThenPart(this.removeEmptyStatement(i.getThenPart()));
    }

    public J visitForLoop(J.ForLoop forLoop) {
        J.ForLoop f = (J.ForLoop)this.refactor((Tree)forLoop, x$0 -> super.visitForLoop(x$0));
        return f.withBody(this.removeEmptyStatement(f.getBody()));
    }

    public J visitForEachLoop(J.ForEachLoop forEachLoop) {
        J.ForEachLoop f = (J.ForEachLoop)this.refactor((Tree)forEachLoop, x$0 -> super.visitForEachLoop(x$0));
        return f.withBody(this.removeEmptyStatement(f.getBody()));
    }

    public J visitWhileLoop(J.WhileLoop whileLoop) {
        J.WhileLoop w = (J.WhileLoop)this.refactor((Tree)whileLoop, x$0 -> super.visitWhileLoop(x$0));
        return w.withBody(this.removeEmptyStatement(w.getBody()));
    }

    private Statement removeEmptyStatement(Statement t) {
        if (!this.isEmptyStatement(t)) {
            return t;
        }
        return this.nextStatement().map(s -> {
            this.andThen((SourceVisitor)new RemoveStatementFromParentBlock(this.getCursor(), (Statement)s));
            return s;
        }).orElseGet(() -> {
            this.andThen((SourceVisitor)new DeleteStatement((Statement)this.getCursor().getTree()));
            return t;
        });
    }

    private Optional<Statement> nextStatement() {
        Tree parent = this.getCursor().getParentOrThrow().getTree();
        return parent instanceof J.Block ? ((J.Block)parent).getStatements().stream().dropWhile(s -> s != this.getCursor().getTree()).skip(1L).findFirst() : Optional.empty();
    }

    private boolean isEmptyStatement(Statement statement) {
        return statement instanceof J.Empty;
    }

    private static class RemoveStatementFromParentBlock
    extends JavaRefactorVisitor {
        private final Tree scope;
        private final Statement statement;

        public RemoveStatementFromParentBlock(Cursor cursor, Statement statement) {
            this.scope = cursor.getParentOrThrow().getTree();
            this.statement = statement;
        }

        public J visitBlock(J.Block<J> block) {
            J.Block b = (J.Block)this.refactor((Tree)block, x$0 -> super.visitBlock(x$0));
            if (this.scope.isScope(block)) {
                b = b.withStatements(b.getStatements().stream().filter(s -> s != this.statement).collect(Collectors.toList()));
            }
            return b;
        }
    }
}

