/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.checkstyle;

import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.AutoConfigure;
import org.openrewrite.Tree;
import org.openrewrite.checkstyle.CheckstyleRefactorVisitor;
import org.openrewrite.checkstyle.policy.PadPolicy;
import org.openrewrite.checkstyle.policy.Token;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.tree.J;

@AutoConfigure
public class MethodParamPad
extends CheckstyleRefactorVisitor {
    private static final Set<Token> DEFAULT_TOKENS = Stream.of(Token.CTOR_DEF, Token.LITERAL_NEW, Token.METHOD_CALL, Token.METHOD_DEF, Token.SUPER_CTOR_CALL, Token.ENUM_CONSTANT_DEF).collect(Collectors.toSet());
    private boolean allowLineBreaks;
    private PadPolicy option;
    private Set<Token> tokens;

    public MethodParamPad() {
        this.setCursoringOn();
    }

    @Override
    protected void configure(CheckstyleRefactorVisitor.Module m) {
        this.allowLineBreaks = m.prop("allowLineBreaks", false);
        this.option = m.propAsOptionValue(PadPolicy::valueOf, PadPolicy.NOSPACE);
        this.tokens = m.propAsTokens(Token.class, DEFAULT_TOKENS);
    }

    public J visitMethod(J.MethodDecl method) {
        return this.maybeFixFormatting(method, x$0 -> super.visitMethod(x$0), J.MethodDecl::getParams, J.MethodDecl::withParams, Token.METHOD_DEF);
    }

    public J visitNewClass(J.NewClass newClass) {
        return this.maybeFixFormatting(newClass, x$0 -> super.visitNewClass(x$0), J.NewClass::getArgs, J.NewClass::withArgs, Token.LITERAL_NEW);
    }

    public J visitMethodInvocation(J.MethodInvocation method) {
        return this.maybeFixFormatting((J)method, x$0 -> super.visitMethodInvocation(x$0), J.MethodInvocation::getArgs, J.MethodInvocation::withArgs, Token.METHOD_CALL, Token.SUPER_CTOR_CALL);
    }

    private <T extends J, U extends Tree> T maybeFixFormatting(@Nullable T t, Function<T, Tree> callSuper, Function<T, U> getter, BiFunction<T, U, T> setter, Token ... tokensToMatch) {
        if (getter.apply(t = (J)this.refactor((Tree)t, callSuper)) != null && Token.matchesOneOf(this.tokens, this.getCursor(), tokensToMatch) && this.hasWrongSpacing((Tree)getter.apply(t))) {
            t = (J)setter.apply(t, ((Tree)getter.apply(t)).withPrefix(this.option == PadPolicy.NOSPACE ? "" : " "));
        }
        return t;
    }

    private boolean hasWrongSpacing(Tree t) {
        String prefix = t.getFormatting().getPrefix();
        return this.option == PadPolicy.NOSPACE ? !prefix.isEmpty() && (this.allowLineBreaks ? prefix.startsWith(" ") || prefix.startsWith("\t") : Character.isWhitespace(prefix.charAt(0))) : prefix.isEmpty();
    }
}

