/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.checkstyle;

import java.util.List;
import org.openrewrite.AutoConfigure;
import org.openrewrite.Formatting;
import org.openrewrite.Tree;
import org.openrewrite.checkstyle.CheckstyleRefactorVisitor;
import org.openrewrite.java.tree.J;

@AutoConfigure
public class FinalClass
extends CheckstyleRefactorVisitor {
    public boolean isIdempotent() {
        return false;
    }

    public J visitClassDecl(J.ClassDecl classDecl) {
        J.ClassDecl c = (J.ClassDecl)this.refactor((Tree)classDecl, x$0 -> super.visitClassDecl(x$0));
        if (classDecl.getBody().getStatements().stream().noneMatch(s -> s instanceof J.MethodDecl && ((J.MethodDecl)s).isConstructor() && !((J.MethodDecl)s).hasModifier("private"))) {
            List modifiers = c.getModifiers();
            int insertPosition = 0;
            for (int i = 0; i < modifiers.size(); ++i) {
                J.Modifier modifier = (J.Modifier)modifiers.get(i);
                if (!(modifier instanceof J.Modifier.Public) && !(modifier instanceof J.Modifier.Static)) continue;
                insertPosition = i + 1;
            }
            Formatting format = Formatting.format((String)" ");
            if (insertPosition == 0 && !modifiers.isEmpty()) {
                format = ((J.Modifier)modifiers.get(0)).getFormatting();
                Formatting.formatFirstPrefix((List)modifiers, (String)" ");
            }
            modifiers.add(insertPosition, new J.Modifier.Final(Tree.randomId(), format));
            c = c.withModifiers(modifiers);
        }
        return c;
    }
}

