/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.checkstyle;

import java.util.Collections;
import org.openrewrite.AutoConfigure;
import org.openrewrite.Formatting;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.Tree;
import org.openrewrite.checkstyle.CheckstyleRefactorVisitor;
import org.openrewrite.java.JavaRefactorVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

@AutoConfigure
public class EqualsAvoidsNull
extends CheckstyleRefactorVisitor {
    private static final MethodMatcher STRING_EQUALS = new MethodMatcher("String equals(java.lang.Object)");
    private static final MethodMatcher STRING_EQUALS_IGNORE_CASE = new MethodMatcher("String equalsIgnoreCase(java.lang.String)");
    private boolean ignoreEqualsIgnoreCase;

    public EqualsAvoidsNull() {
        this.setCursoringOn();
    }

    @Override
    protected void configure(CheckstyleRefactorVisitor.Module m) {
        this.ignoreEqualsIgnoreCase = m.prop("ignoreEqualsIgnoreCase", false);
    }

    public J visitMethodInvocation(J.MethodInvocation method) {
        J.MethodInvocation m = (J.MethodInvocation)this.refactor((Tree)method, x$0 -> super.visitMethodInvocation(x$0));
        if ((STRING_EQUALS.matches(m) || !this.ignoreEqualsIgnoreCase && STRING_EQUALS_IGNORE_CASE.matches(m)) && m.getArgs().getArgs().get(0) instanceof J.Literal && !(m.getSelect() instanceof J.Literal)) {
            J.Binary potentialNullCheck;
            J.Binary binary;
            Tree parent = this.getCursor().getParentOrThrow().getTree();
            if (parent instanceof J.Binary && (binary = (J.Binary)parent).getOperator() instanceof J.Binary.Operator.And && binary.getLeft() instanceof J.Binary && (this.isNullLiteral((potentialNullCheck = (J.Binary)binary.getLeft()).getLeft()) && this.matchesSelect(potentialNullCheck.getRight(), m.getSelect()) || this.isNullLiteral(potentialNullCheck.getRight()) && this.matchesSelect(potentialNullCheck.getLeft(), m.getSelect()))) {
                this.andThen((RefactorVisitor)new RemoveUnnecessaryNullCheck(binary));
            }
            m = m.withSelect((Expression)((Expression)m.getArgs().getArgs().get(0)).withFormatting(m.getSelect().getFormatting())).withArgs(m.getArgs().withArgs(Collections.singletonList((Expression)m.getSelect().withFormatting(Formatting.EMPTY))));
        }
        return m;
    }

    private boolean isNullLiteral(Expression expression) {
        return expression instanceof J.Literal && ((J.Literal)expression).getType() == JavaType.Primitive.Null;
    }

    private boolean matchesSelect(Expression expression, Expression select) {
        return expression.printTrimmed().replaceAll("\\s", "").equals(select.printTrimmed().replaceAll("\\s", ""));
    }

    private static class RemoveUnnecessaryNullCheck
    extends JavaRefactorVisitor {
        private final J.Binary scope;

        public RemoveUnnecessaryNullCheck(J.Binary scope) {
            this.scope = scope;
            this.setCursoringOn();
        }

        public J visitBinary(J.Binary binary) {
            this.maybeUnwrapParentheses(this.getCursor().getParent());
            if (this.scope.isScope((Tree)binary)) {
                return (J)Formatting.stripPrefix((Tree)binary.getRight());
            }
            return super.visitBinary(binary);
        }
    }
}

