/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.checkstyle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.AutoConfigure;
import org.openrewrite.Formatting;
import org.openrewrite.Tree;
import org.openrewrite.checkstyle.CheckstyleRefactorVisitor;
import org.openrewrite.checkstyle.WhitespaceChecks;
import org.openrewrite.checkstyle.policy.PunctuationToken;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;

@AutoConfigure
public class NoWhitespaceBefore
extends CheckstyleRefactorVisitor {
    private static final Set<PunctuationToken> DEFAULT_TOKENS = Stream.of(PunctuationToken.COMMA, PunctuationToken.SEMI, PunctuationToken.POST_INC, PunctuationToken.POST_DEC, PunctuationToken.ELLIPSIS).collect(Collectors.toSet());
    private boolean allowLineBreaks;
    private Set<PunctuationToken> tokens;

    public NoWhitespaceBefore() {
        this.setCursoringOn();
    }

    @Override
    protected void configure(CheckstyleRefactorVisitor.Module m) {
        this.allowLineBreaks = m.prop("allowLineBreaks", false);
        this.tokens = m.propAsTokens(PunctuationToken.class, DEFAULT_TOKENS);
    }

    public J visitPackage(J.Package pkg) {
        return this.maybeStripSuffixBefore(pkg, x$0 -> super.visitPackage(x$0), PunctuationToken.SEMI);
    }

    public J visitImport(J.Import impoort) {
        return this.maybeStripSuffixBefore(impoort, x$0 -> super.visitImport(x$0), PunctuationToken.SEMI);
    }

    public J visitFieldAccess(J.FieldAccess fieldAccess) {
        J.FieldAccess f = (J.FieldAccess)this.refactor((Tree)fieldAccess, x$0 -> super.visitFieldAccess(x$0));
        if (this.tokens.contains((Object)PunctuationToken.DOT) && this.whitespaceInSuffix((Tree)fieldAccess.getTarget())) {
            f = f.withTarget((Expression)Formatting.stripSuffix((Tree)f.getTarget()));
        }
        return f;
    }

    public J visitMethod(J.MethodDecl method) {
        if (method.isAbstract()) {
            return this.maybeStripSuffixBefore(method, x$0 -> super.visitMethod(x$0), PunctuationToken.SEMI);
        }
        return super.visitMethod(method);
    }

    public J visitMethodInvocation(J.MethodInvocation method) {
        J.MethodInvocation m = (J.MethodInvocation)this.refactor((Tree)method, x$0 -> super.visitMethodInvocation(x$0));
        if (method.getSelect() != null && this.tokens.contains((Object)PunctuationToken.DOT) && this.whitespaceInSuffix((Tree)method.getSelect())) {
            m = m.withSelect((Expression)Formatting.stripSuffix((Tree)m.getSelect()));
        }
        if (this.tokens.contains((Object)PunctuationToken.COMMA) && method.getArgs().getArgs().stream().anyMatch(arg -> this.whitespaceInSuffix((Tree)arg) && !this.isLastArgumentInMethodInvocation((Expression)arg, method))) {
            m = m.withArgs(m.getArgs().withArgs(m.getArgs().getArgs().stream().map(arg -> this.isLastArgumentInMethodInvocation((Expression)arg, method) ? arg : (Expression)Formatting.stripSuffix((Tree)arg)).collect(Collectors.toList())));
        }
        return m;
    }

    private boolean isLastArgumentInMethodInvocation(Expression arg, J.MethodInvocation parent) {
        return parent.getArgs().getArgs().stream().reduce((r1, r2) -> r2).map(lastArg -> lastArg == arg).orElse(false);
    }

    public J visitStatement(Statement statement) {
        Tree parent = this.getCursor().getParentOrThrow().getTree();
        if (!(parent instanceof J.MethodInvocation || parent instanceof J.FieldAccess || parent instanceof J.ForEachLoop || parent instanceof J.Try || this.isLastArgumentInMethodDeclaration(statement, parent) || this.isStatementPrecedingTernaryConditionOrFalse(statement, parent) || this.isStatementPrecedingInstanceof(statement, parent) || !statement.isSemicolonTerminated())) {
            return this.maybeStripSuffixBefore(statement, x$0 -> super.visitStatement(x$0), PunctuationToken.SEMI);
        }
        return super.visitStatement(statement);
    }

    private boolean isLastArgumentInMethodDeclaration(Statement statement, Tree parent) {
        if (!(parent instanceof J.MethodDecl)) {
            return false;
        }
        return ((J.MethodDecl)parent).getParams().getParams().stream().reduce((r1, r2) -> r2).map(lastArg -> lastArg == statement).orElse(false);
    }

    private boolean isStatementPrecedingTernaryConditionOrFalse(Statement statement, Tree parent) {
        return parent instanceof J.Ternary && (((J.Ternary)parent).getCondition() == statement || ((J.Ternary)parent).getTruePart() == statement);
    }

    private boolean isStatementPrecedingInstanceof(Statement statement, Tree parent) {
        return parent instanceof J.InstanceOf && ((J.InstanceOf)parent).getExpr() == statement;
    }

    public J visitForLoop(J.ForLoop forLoop) {
        J.ForLoop f = (J.ForLoop)this.refactor((Tree)forLoop, x$0 -> super.visitForLoop(x$0));
        J.ForLoop.Control ctrl = forLoop.getControl();
        if (this.tokens.contains((Object)PunctuationToken.SEMI) && forLoop.getBody() instanceof J.Empty && this.whitespaceInPrefix((Tree)forLoop.getBody()) || this.tokens.contains((Object)PunctuationToken.SEMI) && (this.whitespaceInSuffix((Tree)ctrl.getInit()) || this.whitespaceInSuffix((Tree)ctrl.getCondition()) || this.whitespaceInSuffix((Tree)ctrl.getUpdate().get(ctrl.getUpdate().size() - 1))) || this.tokens.contains((Object)PunctuationToken.COMMA) && ctrl.getUpdate().stream().anyMatch(this::whitespaceInSuffix)) {
            J.ForLoop.Control fixCtrl = f.getControl();
            ArrayList<Statement> fixUpdate = new ArrayList<Statement>(fixCtrl.getUpdate());
            for (int i = 0; i < fixUpdate.size(); ++i) {
                Statement update = (Statement)fixUpdate.get(i);
                if (this.tokens.contains((Object)PunctuationToken.COMMA) && i != fixUpdate.size() - 1) {
                    fixUpdate.set(i, WhitespaceChecks.stripSuffixUpToLinebreak(update));
                    continue;
                }
                if (!this.tokens.contains((Object)PunctuationToken.SEMI) || i != fixUpdate.size() - 1) continue;
                fixUpdate.set(i, WhitespaceChecks.stripSuffixUpToLinebreak(update));
            }
            fixCtrl = fixCtrl.withInit(WhitespaceChecks.stripSuffixUpToLinebreak(fixCtrl.getInit())).withCondition(WhitespaceChecks.stripSuffixUpToLinebreak(fixCtrl.getCondition())).withUpdate(fixUpdate);
            f = f.withControl(fixCtrl).withBody(f.getBody() instanceof J.Empty ? WhitespaceChecks.stripPrefixUpToLinebreak(f.getBody()) : f.getBody());
        }
        return f;
    }

    public J visitMultiVariable(J.VariableDecls multiVariable) {
        J.VariableDecls m = (J.VariableDecls)this.refactor((Tree)multiVariable, x$0 -> super.visitMultiVariable(x$0));
        if (this.tokens.contains((Object)PunctuationToken.ELLIPSIS) && this.whitespaceInPrefix((Tree)multiVariable.getVarargs())) {
            m = m.withVarargs(WhitespaceChecks.stripPrefixUpToLinebreak(m.getVarargs()));
        }
        return m;
    }

    public J visitVariable(J.VariableDecls.NamedVar variable) {
        return this.maybeStripSuffixBefore(variable, x$0 -> super.visitVariable(x$0), PunctuationToken.COMMA);
    }

    public J visitUnary(J.Unary unary) {
        J.Unary u = (J.Unary)this.refactor((Tree)unary, x$0 -> super.visitUnary(x$0));
        if (this.whitespaceInPrefix((Tree)unary.getOperator()) && (unary.getOperator() instanceof J.Unary.Operator.PostDecrement || unary.getOperator() instanceof J.Unary.Operator.PostIncrement) && (this.tokens.contains((Object)PunctuationToken.POST_DEC) || this.tokens.contains((Object)PunctuationToken.POST_INC))) {
            u = u.withOperator(WhitespaceChecks.stripPrefixUpToLinebreak(u.getOperator()));
        }
        return u;
    }

    public J visitTypeParameters(J.TypeParameters typeParams) {
        return this.maybeStripPrefixBefore(typeParams, x$0 -> super.visitTypeParameters(x$0), PunctuationToken.GENERIC_START);
    }

    public J visitTypeParameter(J.TypeParameter typeParam) {
        J.TypeParameters typeParams = (J.TypeParameters)this.getCursor().getParentOrThrow().getTree();
        if (typeParams.getParams().get(typeParams.getParams().size() - 1) == typeParam) {
            return this.maybeStripSuffixBefore(typeParam, x$0 -> super.visitTypeParameter(x$0), PunctuationToken.GENERIC_END);
        }
        return super.visitTypeParameter(typeParam);
    }

    public J visitMemberReference(J.MemberReference memberRef) {
        J.MemberReference m = (J.MemberReference)this.refactor((Tree)memberRef, x$0 -> super.visitMemberReference(x$0));
        if (this.tokens.contains((Object)PunctuationToken.METHOD_REF) && this.whitespaceInSuffix((Tree)memberRef.getContaining())) {
            m = m.withContaining(WhitespaceChecks.stripSuffixUpToLinebreak(m.getContaining()));
        }
        return m;
    }

    public J visitForEachLoop(J.ForEachLoop forEachLoop) {
        J.ForEachLoop f = (J.ForEachLoop)this.refactor((Tree)forEachLoop, x$0 -> super.visitForEachLoop(x$0));
        if (this.tokens.contains((Object)PunctuationToken.SEMI) && forEachLoop.getBody() instanceof J.Empty && this.whitespaceInPrefix((Tree)forEachLoop.getBody())) {
            f = f.withBody(WhitespaceChecks.stripPrefixUpToLinebreak(f.getBody()));
        }
        return f;
    }

    public J visitWhileLoop(J.WhileLoop whileLoop) {
        J.WhileLoop w = (J.WhileLoop)this.refactor((Tree)whileLoop, x$0 -> super.visitWhileLoop(x$0));
        if (this.tokens.contains((Object)PunctuationToken.SEMI) && whileLoop.getBody() instanceof J.Empty && this.whitespaceInPrefix((Tree)whileLoop.getBody())) {
            w = w.withBody(WhitespaceChecks.stripPrefixUpToLinebreak(w.getBody()));
        }
        return w;
    }

    private <T extends J> T maybeStripSuffixBefore(T tree, Function<T, Tree> callSuper, PunctuationToken ... tokensToMatch) {
        J t = (J)this.refactor((Tree)tree, callSuper);
        if (Arrays.stream(tokensToMatch).anyMatch(this.tokens::contains) && this.whitespaceInSuffix((Tree)tree)) {
            t = WhitespaceChecks.stripSuffixUpToLinebreak(t);
        }
        return (T)t;
    }

    private <T extends J> T maybeStripPrefixBefore(T tree, Function<T, Tree> callSuper, PunctuationToken ... tokensToMatch) {
        J t = (J)this.refactor((Tree)tree, callSuper);
        if (Arrays.stream(tokensToMatch).anyMatch(this.tokens::contains) && this.whitespaceInPrefix((Tree)tree)) {
            t = WhitespaceChecks.stripPrefixUpToLinebreak(t);
        }
        return (T)t;
    }

    private boolean whitespaceInSuffix(@Nullable Tree t) {
        if (t == null) {
            return false;
        }
        String suffix = t.getFormatting().getSuffix();
        return !(!suffix.contains(" ") && !suffix.contains("\t") || this.allowLineBreaks && suffix.startsWith("\n"));
    }

    private boolean whitespaceInPrefix(@Nullable Tree t) {
        return t != null && (t.getFormatting().getPrefix().contains(" ") || t.getFormatting().getPrefix().contains("\t"));
    }
}

