/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.checkstyle;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.AutoConfigure;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.checkstyle.CheckstyleRefactorVisitor;
import org.openrewrite.checkstyle.SpansMultipleLines;
import org.openrewrite.checkstyle.policy.RightCurlyPolicy;
import org.openrewrite.checkstyle.policy.Token;
import org.openrewrite.java.tree.J;

@AutoConfigure
public class RightCurly
extends CheckstyleRefactorVisitor {
    private static final Set<Token> DEFAULT_TOKENS = Stream.of(Token.LITERAL_TRY, Token.LITERAL_CATCH, Token.LITERAL_FINALLY, Token.LITERAL_IF, Token.LITERAL_ELSE).collect(Collectors.toSet());
    private RightCurlyPolicy option;
    private Set<Token> tokens;

    public RightCurly() {
        this.setCursoringOn();
    }

    @Override
    protected void configure(CheckstyleRefactorVisitor.Module m) {
        this.option = m.propAsOptionValue(RightCurlyPolicy::valueOf, RightCurlyPolicy.SAME);
        this.tokens = m.propAsTokens(Token.class, DEFAULT_TOKENS);
    }

    public J visitBlock(J.Block<J> block) {
        boolean satisfiesPolicy;
        J.Block b = (J.Block)this.refactor((Tree)block, x$0 -> super.visitBlock(x$0));
        Cursor parentCursor = this.getCursor().getParentOrThrow();
        boolean tokenMatches = this.tokens.stream().anyMatch(t -> t.getMatcher().matches(this.getCursor())) || this.option != RightCurlyPolicy.ALONE_OR_SINGLELINE && this.tokens.stream().anyMatch(t -> t.getMatcher().matches(parentCursor)) || parentCursor.getTree() instanceof J.Block;
        boolean bl = satisfiesPolicy = block.getEnd().getPrefix().contains("\n") || this.option != RightCurlyPolicy.ALONE && (Boolean)new SpansMultipleLines((J)block, null).visit((Tree)block) == false;
        if (tokenMatches && !satisfiesPolicy && parentCursor.firstEnclosing(J.Block.class) != null) {
            String suffix = this.formatter.findIndent(((J.Block)this.getCursor().getParentOrThrow().firstEnclosing(J.Block.class)).getIndent(), new Tree[]{this.getCursor().getParentOrThrow().getTree()}).getPrefix();
            if ((b = b.withEnd((J.Block.End)b.getEnd().withPrefix(suffix))).getStatements().size() == 1) {
                b.getStatements().set(0, (J)((J)b.getStatements().get(0)).withFormatting(this.formatter.format((Tree)b)));
            }
        }
        return b;
    }

    public J visitElse(J.If.Else elze) {
        J.If.Else e = (J.If.Else)this.refactor((Tree)elze, x$0 -> super.visitElse(x$0));
        if (this.tokens.contains((Object)Token.LITERAL_ELSE) && !this.multiBlockSatisfiesPolicy((Tree)elze)) {
            e = this.formatMultiBlock(e);
        }
        return e;
    }

    public J visitFinally(J.Try.Finally finallie) {
        J.Try.Finally f = (J.Try.Finally)this.refactor((Tree)finallie, x$0 -> super.visitFinally(x$0));
        if (this.tokens.contains((Object)Token.LITERAL_FINALLY) && !this.multiBlockSatisfiesPolicy((Tree)finallie)) {
            f = this.formatMultiBlock(f);
        }
        return f;
    }

    public J visitCatch(J.Try.Catch catzh) {
        J.Try.Catch c = (J.Try.Catch)this.refactor((Tree)catzh, x$0 -> super.visitCatch(x$0));
        if (this.tokens.contains((Object)Token.LITERAL_CATCH) && !this.multiBlockSatisfiesPolicy((Tree)catzh)) {
            c = this.formatMultiBlock(c);
        }
        return c;
    }

    private boolean multiBlockSatisfiesPolicy(Tree blockFollower) {
        boolean isAlone = blockFollower.getFormatting().getPrefix().contains("\n");
        return this.option == RightCurlyPolicy.SAME != isAlone;
    }

    private <T extends J> T formatMultiBlock(T tree) {
        return (T)(this.option == RightCurlyPolicy.SAME ? (J)tree.withPrefix(" ") : (J)tree.withFormatting(this.formatter.format((Tree)this.enclosingBlock())));
    }
}

