/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.spring;

import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.openrewrite.Formatting;
import org.openrewrite.SourceVisitor;
import org.openrewrite.Tree;
import org.openrewrite.java.refactor.AddAnnotation;
import org.openrewrite.java.refactor.GenerateConstructorUsingFields;
import org.openrewrite.java.refactor.JavaRefactorVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.TypeUtils;

public class ConstructorInjection
extends JavaRefactorVisitor {
    private final boolean generateLombokRequiredArgsAnnotation;
    private final boolean generateJsr305Annotations;

    public ConstructorInjection(boolean generateLombokRequiredArgsAnnotation, boolean generateJsr305Annotations) {
        this.generateLombokRequiredArgsAnnotation = generateLombokRequiredArgsAnnotation;
        this.generateJsr305Annotations = generateJsr305Annotations;
    }

    public ConstructorInjection() {
        this(false, false);
    }

    public String getName() {
        return "spring.ConstructorInjection";
    }

    public J visitClassDecl(J.ClassDecl classDecl) {
        J.ClassDecl cd = (J.ClassDecl)this.refactor((Tree)classDecl, x$0 -> super.visitClassDecl(x$0));
        if (cd.getFields().stream().anyMatch(this::isFieldInjected)) {
            List statements = cd.getBody().getStatements().stream().map(stat -> stat.whenType(J.VariableDecls.class).filter(this::isFieldInjected).map(mv -> {
                J.VariableDecls fixedField = mv.withAnnotations(mv.getAnnotations().stream().filter(ann -> !this.isFieldInjectionAnnotation((J.Annotation)ann) || this.generateJsr305Annotations && ann.getArgs() != null && ann.getArgs().getArgs().stream().anyMatch(arg -> arg.whenType(J.Assign.class).map(assign -> ((J.Ident)assign.getVariable()).getSimpleName().equals("required")).orElse(false))).map(ann -> {
                    if (this.isFieldInjectionAnnotation((J.Annotation)ann)) {
                        this.maybeAddImport("javax.annotation.Nonnull");
                        JavaType.Class nonnullType = JavaType.Class.build((String)"javax.annotation.Nonnull");
                        return ann.withAnnotationType((NameTree)J.Ident.build((UUID)Tree.randomId(), (String)"Nonnull", (JavaType)nonnullType, (Formatting)ann.getAnnotationType().getFormatting())).withArgs(null).withType((JavaType)nonnullType);
                    }
                    return ann;
                }).collect(Collectors.toList())).withModifiers(new String[]{"private", "final"});
                this.maybeRemoveImport("org.springframework.beans.factory.annotation.Autowired");
                return fixedField.getAnnotations().isEmpty() && !mv.getAnnotations().isEmpty() ? fixedField.withModifiers(Formatting.formatFirstPrefix((List)fixedField.getModifiers(), (String)Formatting.firstPrefix((List)mv.getAnnotations()))) : fixedField;
            }).orElse((J)stat)).collect(Collectors.toList());
            if (!this.hasRequiredArgsConstructor(cd)) {
                this.andThen((SourceVisitor)(this.generateLombokRequiredArgsAnnotation ? new AddAnnotation(cd.getId(), "lombok.RequiredArgsConstructor", new Expression[0]) : new GenerateConstructorUsingFields(cd, this.getInjectedFields(cd))));
            }
            List setterNames = this.getInjectedFields(cd).stream().map(mv -> {
                String name = ((J.VariableDecls.NamedVar)mv.getVars().get(0)).getSimpleName();
                return "set" + name.substring(0, 1).toUpperCase() + name.substring(1);
            }).collect(Collectors.toList());
            cd = cd.withBody(cd.getBody().withStatements(statements.stream().filter(stat -> stat.whenType(J.MethodDecl.class).map(md -> !setterNames.contains(md.getSimpleName())).orElse(true)).collect(Collectors.toList())));
        }
        return cd;
    }

    private boolean hasRequiredArgsConstructor(J.ClassDecl cd) {
        Set injectedFieldNames = this.getInjectedFields(cd).stream().map(f -> ((J.VariableDecls.NamedVar)f.getVars().get(0)).getSimpleName()).collect(Collectors.toSet());
        return cd.getBody().getStatements().stream().anyMatch(stat -> stat.whenType(J.MethodDecl.class).filter(J.MethodDecl::isConstructor).map(md -> md.getParams().getParams().stream().map(p -> p.whenType(J.VariableDecls.class).map(mv -> ((J.VariableDecls.NamedVar)mv.getVars().get(0)).getSimpleName()).orElseThrow(() -> new RuntimeException("not possible to get here"))).allMatch(injectedFieldNames::contains)).orElse(false));
    }

    private List<J.VariableDecls> getInjectedFields(J.ClassDecl cd) {
        return cd.getBody().getStatements().stream().filter(stat -> stat.whenType(J.VariableDecls.class).map(this::isFieldInjected).orElse(false)).map(J.VariableDecls.class::cast).collect(Collectors.toList());
    }

    private boolean isFieldInjected(J.VariableDecls mv) {
        return mv.getAnnotations().stream().anyMatch(this::isFieldInjectionAnnotation);
    }

    private boolean isFieldInjectionAnnotation(J.Annotation ann) {
        return TypeUtils.isOfClassType((JavaType)ann.getType(), (String)"javax.inject.Inject") || TypeUtils.isOfClassType((JavaType)ann.getType(), (String)"org.springframework.beans.factory.annotation.Autowired");
    }
}

