/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.spring.xml;

import java.nio.file.Path;
import org.openrewrite.SourceVisitor;
import org.openrewrite.java.refactor.AddAnnotation;
import org.openrewrite.java.refactor.JavaRefactorVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.spring.xml.SpringMetadata;
import org.openrewrite.spring.xml.bean.AddBeanForClassNotInSourceSet;
import org.openrewrite.spring.xml.bean.AddComponentScan;
import org.openrewrite.spring.xml.bean.AddPropertySourcesPlaceholderConfigurer;
import org.openrewrite.spring.xml.parse.RewriteBeanDefinitionRegistry;

public class AddConfigurationClass
extends JavaRefactorVisitor {
    private final RewriteBeanDefinitionRegistry beanDefinitionRegistry;
    private final Path mainSourceSet;

    public AddConfigurationClass(RewriteBeanDefinitionRegistry beanDefinitionRegistry, Path mainSourceSet) {
        this.beanDefinitionRegistry = beanDefinitionRegistry;
        this.mainSourceSet = mainSourceSet;
    }

    public String getName() {
        return "spring.beans.AddBeansToConfiguration";
    }

    public boolean isIdempotent() {
        return false;
    }

    public J visitCompilationUnit(J.CompilationUnit cu) {
        if (cu.getMetadata().getOrDefault((Object)SpringMetadata.FILE_TYPE, "unknown").equals("ConfigurationClass")) {
            return super.visitCompilationUnit(cu);
        }
        return cu;
    }

    public J visitClassDecl(J.ClassDecl classDecl) {
        this.andThen((SourceVisitor)new AddAnnotation(classDecl.getId(), "org.springframework.context.annotation.Configuration", new Expression[0]));
        this.andThen((SourceVisitor)new AddComponentScan(classDecl, this.beanDefinitionRegistry));
        this.andThen((SourceVisitor)new AddBeanForClassNotInSourceSet(classDecl, this.beanDefinitionRegistry, this.mainSourceSet));
        this.andThen((SourceVisitor)new AddPropertySourcesPlaceholderConfigurer(classDecl, this.beanDefinitionRegistry));
        return super.visitClassDecl(classDecl);
    }
}

