/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.spring.xml;

import java.lang.constant.Constable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.openrewrite.Formatting;
import org.openrewrite.SourceVisitor;
import org.openrewrite.Tree;
import org.openrewrite.java.refactor.AddAnnotation;
import org.openrewrite.java.refactor.JavaRefactorVisitor;
import org.openrewrite.java.refactor.ScopedJavaRefactorVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TreeBuilder;
import org.openrewrite.java.tree.TypeUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;

class MakeComponentScannable
extends JavaRefactorVisitor {
    private final BeanDefinitionRegistry registry;

    public String getName() {
        return "spring.beans.AnnotationBasedBeanConfiguration";
    }

    public MakeComponentScannable(BeanDefinitionRegistry registry) {
        this.registry = registry;
    }

    public J visitCompilationUnit(J.CompilationUnit cu) {
        this.andThen((SourceVisitor)new AnnotateBeanClass(this.registry));
        return super.visitCompilationUnit(cu);
    }

    private static class AutowireFields
    extends ScopedJavaRefactorVisitor {
        private final BeanDefinition beanDefinition;

        public AutowireFields(J.ClassDecl classDecl, BeanDefinition beanDefinition) {
            super(classDecl.getId());
            this.beanDefinition = beanDefinition;
        }

        public J visitMultiVariable(J.VariableDecls multiVariable) {
            this.getCursor().getParentOrThrow().getParentOrThrow().getTree().whenType(J.ClassDecl.class).ifPresent(classDecl -> {
                StreamSupport.stream(this.beanDefinition.getPropertyValues().spliterator(), false).filter(prop -> prop.getName().equals(((J.VariableDecls.NamedVar)multiVariable.getVars().get(0)).getSimpleName())).findAny().ifPresent(beanProperty -> {
                    if (beanProperty.getValue() instanceof BeanReference) {
                        this.andThen((SourceVisitor)new AddAnnotation(multiVariable.getId(), "org.springframework.beans.factory.annotation.Autowired", new Expression[0]));
                    } else if (beanProperty.getValue() instanceof TypedStringValue) {
                        this.valueExpression(beanProperty.getValue(), multiVariable).ifPresent(valueTree -> this.andThen((SourceVisitor)new AddAnnotation(multiVariable.getId(), "org.springframework.beans.factory.annotation.Value", new Expression[]{valueTree})));
                    }
                });
                ConstructorArgumentValues constructorArgs = this.beanDefinition.getConstructorArgumentValues();
                if (constructorArgs.getArgumentCount() > 0) {
                    classDecl.getMethods().stream().filter(m -> m.isConstructor() && m.getParams().getParams().size() == constructorArgs.getArgumentCount()).findAny().ifPresent(injectableConstructor -> {
                        List indexedValues = Stream.concat(constructorArgs.getIndexedArgumentValues().entrySet().stream().sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue), constructorArgs.getGenericArgumentValues().stream().filter(valueHolder -> valueHolder.getType() == null && valueHolder.getName() == null)).collect(Collectors.toList());
                        for (int i = 0; i < indexedValues.size(); ++i) {
                            int param = i;
                            this.valueExpression(((ConstructorArgumentValues.ValueHolder)indexedValues.get(i)).getValue(), multiVariable).ifPresent(valueTree -> this.andThen((SourceVisitor)new AddAnnotation(((Statement)injectableConstructor.getParams().getParams().get(param)).getId(), "org.springframework.beans.factory.annotation.Value", new Expression[]{valueTree})));
                        }
                        List genericValues = constructorArgs.getGenericArgumentValues().stream().filter(valueHolder -> valueHolder.getType() != null || valueHolder.getName() != null).collect(Collectors.toList());
                        for (ConstructorArgumentValues.ValueHolder genericValue : genericValues) {
                            this.valueExpression(genericValue.getValue(), multiVariable).ifPresent(valueTree -> {
                                Statement param = genericValue.getType() != null ? (Statement)injectableConstructor.getParams().getParams().stream().filter(methodParam -> {
                                    JavaType genericValueType = Optional.ofNullable(JavaType.Primitive.fromKeyword((String)genericValue.getType())).orElseGet(() -> JavaType.Class.build((String)genericValue.getType()));
                                    return methodParam.whenType(J.VariableDecls.class).map(methodParamVar -> methodParamVar.getTypeExpr().getType().equals(genericValueType)).orElse(false);
                                }).findAny().orElse(null) : (Statement)injectableConstructor.getParams().getParams().stream().filter(methodParam -> methodParam.whenType(J.VariableDecls.class).map(methodParamVar -> ((J.VariableDecls.NamedVar)methodParamVar.getVars().get(0)).getSimpleName().equals(genericValue.getName())).orElse(false)).findAny().orElse(null);
                                if (param != null) {
                                    this.andThen((SourceVisitor)new AddAnnotation(param.getId(), "org.springframework.beans.factory.annotation.Value", new Expression[]{valueTree}));
                                }
                            });
                        }
                    });
                }
            });
            return super.visitMultiVariable(multiVariable);
        }

        private Optional<Expression> valueExpression(Object typedStringValue, J.VariableDecls multiVariable) {
            if (!(typedStringValue instanceof TypedStringValue) || multiVariable.getTypeExpr() == null) {
                return Optional.empty();
            }
            String value = ((TypedStringValue)typedStringValue).getValue();
            if (value == null) {
                return Optional.empty();
            }
            JavaType type = multiVariable.getTypeExpr().getType();
            JavaType.Primitive primitive = TypeUtils.asPrimitive((JavaType)type);
            if (TypeUtils.isString((JavaType)type) || value.contains("${") || value.contains("#{")) {
                return Optional.of(new J.Literal(Tree.randomId(), (Object)value, "\"" + value + "\"", JavaType.Primitive.String, Formatting.EMPTY));
            }
            if (primitive != null) {
                Constable primitiveValue;
                switch (primitive) {
                    case Int: {
                        primitiveValue = Integer.parseInt(value);
                        break;
                    }
                    case Boolean: {
                        primitiveValue = Boolean.valueOf(Boolean.parseBoolean(value));
                        break;
                    }
                    case Byte: 
                    case Char: {
                        primitiveValue = Character.valueOf(value.length() > 0 ? value.charAt(0) : (char)'\u0000');
                        break;
                    }
                    case Double: {
                        primitiveValue = Double.parseDouble(value);
                        break;
                    }
                    case Float: {
                        primitiveValue = Float.valueOf(Float.parseFloat(value));
                        break;
                    }
                    case Long: {
                        primitiveValue = Long.parseLong(value);
                        break;
                    }
                    case Short: {
                        primitiveValue = Short.parseShort(value);
                        break;
                    }
                    case Null: {
                        primitiveValue = null;
                        break;
                    }
                    default: {
                        return Optional.empty();
                    }
                }
                return Optional.of(new J.Literal(Tree.randomId(), (Object)primitiveValue, (String)(JavaType.Primitive.Char.equals((Object)primitive) ? "'" + value + "'" : value), primitive, Formatting.EMPTY));
            }
            return Optional.empty();
        }
    }

    private static class AnnotateBeanClass
    extends JavaRefactorVisitor {
        private final BeanDefinitionRegistry beanDefinitionRegistry;

        private AnnotateBeanClass(BeanDefinitionRegistry beanDefinitionRegistry) {
            this.beanDefinitionRegistry = beanDefinitionRegistry;
        }

        public boolean isCursored() {
            return true;
        }

        public J visitClassDecl(J.ClassDecl classDecl) {
            Arrays.stream(this.beanDefinitionRegistry.getBeanDefinitionNames()).map(arg_0 -> ((BeanDefinitionRegistry)this.beanDefinitionRegistry).getBeanDefinition(arg_0)).filter(bd -> TypeUtils.isOfClassType((JavaType)classDecl.getType(), (String)bd.getBeanClassName())).findAny().ifPresent(beanDefinition -> {
                this.andThen((SourceVisitor)new AddAnnotation(classDecl.getId(), "org.springframework.stereotype.Component", new Expression[0]));
                this.andThen((SourceVisitor)new AutowireFields(classDecl, (BeanDefinition)beanDefinition));
                if (beanDefinition.isLazyInit()) {
                    this.andThen((SourceVisitor)new AddAnnotation(classDecl.getId(), "org.springframework.context.annotation.Lazy", new Expression[0]));
                }
                if (beanDefinition.isPrototype()) {
                    JavaType.Class cbf = JavaType.Class.build((String)"org.springframework.beans.factory.config.ConfigurableBeanFactory");
                    this.maybeAddImport(cbf.getFullyQualifiedName());
                    this.andThen((SourceVisitor)new AddAnnotation(classDecl.getId(), "org.springframework.context.annotation.Scope", new Expression[]{(Expression)TreeBuilder.buildName((String)"ConfigurableBeanFactory.SCOPE_PROTOTYPE").withType((JavaType)cbf)}));
                }
                if (beanDefinition.getInitMethodName() != null) {
                    classDecl.getMethods().stream().filter(m -> m.getSimpleName().equals(beanDefinition.getInitMethodName())).findAny().ifPresent(m -> this.andThen((SourceVisitor)new AddAnnotation(m.getId(), "javax.annotation.PostConstruct", new Expression[0])));
                }
                if (beanDefinition.getDestroyMethodName() != null) {
                    classDecl.getMethods().stream().filter(m -> m.getSimpleName().equals(beanDefinition.getDestroyMethodName())).findAny().ifPresent(m -> this.andThen((SourceVisitor)new AddAnnotation(m.getId(), "javax.annotation.PreDestroy", new Expression[0])));
                }
            });
            return super.visitClassDecl(classDecl);
        }
    }
}

