/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.spring.xml;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.openrewrite.Refactor;
import org.openrewrite.RefactorModule;
import org.openrewrite.SourceVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.spring.xml.AddConfigurationClass;
import org.openrewrite.spring.xml.MakeComponentScannable;
import org.openrewrite.spring.xml.SpringMetadata;
import org.openrewrite.spring.xml.parse.RewriteBeanDefinition;
import org.openrewrite.spring.xml.parse.RewriteBeanDefinitionRegistry;
import org.openrewrite.spring.xml.parse.RewriteNamespaceHandler;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.DefaultNamespaceHandlerResolver;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.xml.sax.InputSource;

public class MigrateSpringXmlConfigurationJava
implements RefactorModule<J.CompilationUnit, J> {
    private final Path mainSourceSet;
    private final String configurationPackage;
    private final RewriteBeanDefinitionRegistry beanDefinitionRegistry = new RewriteBeanDefinitionRegistry();

    public MigrateSpringXmlConfigurationJava(Path mainSourceSet, String configurationPackage, List<Path> xmlConfigurations) {
        this.mainSourceSet = mainSourceSet;
        this.configurationPackage = configurationPackage;
        MigrateSpringXmlConfigurationJava.loadBeanDefinitions(xmlConfigurations, (BeanDefinitionRegistry)this.beanDefinitionRegistry);
    }

    static void loadBeanDefinitions(List<Path> xmlConfigurations, BeanDefinitionRegistry beanDefinitionRegistry) {
        XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader(beanDefinitionRegistry);
        reader.setValidating(false);
        DefaultNamespaceHandlerResolver namespaceHandlerResolver = (DefaultNamespaceHandlerResolver)reader.getNamespaceHandlerResolver();
        try {
            Method getHandlerMappings = DefaultNamespaceHandlerResolver.class.getDeclaredMethod("getHandlerMappings", new Class[0]);
            getHandlerMappings.setAccessible(true);
            Map handlerMappings = (Map)getHandlerMappings.invoke((Object)namespaceHandlerResolver, new Object[0]);
            handlerMappings.put("http://www.springframework.org/schema/context", new RewriteNamespaceHandler(Map.of("property-placeholder", RewriteBeanDefinition.Type.PropertyPlaceholder, "component-scan", RewriteBeanDefinition.Type.ComponentScan)));
            System.out.println(handlerMappings);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        for (Path xmlConfiguration : xmlConfigurations) {
            try {
                InputStream configInput = Files.newInputStream(xmlConfiguration, StandardOpenOption.READ);
                try {
                    reader.loadBeanDefinitions(new InputSource(configInput));
                }
                finally {
                    if (configInput == null) continue;
                    configInput.close();
                }
            }
            catch (IOException | BeanDefinitionStoreException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public Refactor<J.CompilationUnit, J> apply(Refactor<J.CompilationUnit, J> refactor) {
        return refactor.visit(new SourceVisitor[]{new MakeComponentScannable((BeanDefinitionRegistry)this.beanDefinitionRegistry)}).visit(new SourceVisitor[]{new AddConfigurationClass(this.beanDefinitionRegistry, this.mainSourceSet)});
    }

    public List<J.CompilationUnit> getDeclaredOutputs() {
        return Collections.singletonList(J.CompilationUnit.buildEmptyClass((Path)this.mainSourceSet, (String)this.configurationPackage, (String)"MyConfiguration").withMetadata(Map.of(SpringMetadata.FILE_TYPE, "ConfigurationClass")));
    }
}

