/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.spring.xml.bean;

import java.nio.file.Path;
import java.util.Map;
import org.openrewrite.SourceVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.spring.xml.bean.AddBeanMethod;
import org.openrewrite.spring.xml.bean.AddBeanMethodBody;
import org.openrewrite.spring.xml.bean.BeanDefinitionVisitor;
import org.openrewrite.spring.xml.parse.RewriteBeanDefinition;
import org.openrewrite.spring.xml.parse.RewriteBeanDefinitionRegistry;

public class AddBeanForClassNotInSourceSet
extends BeanDefinitionVisitor {
    private final Path mainSourceSet;

    public AddBeanForClassNotInSourceSet(J.ClassDecl profileConfigurationClass, RewriteBeanDefinitionRegistry registry, Path mainSourceSet) {
        super(profileConfigurationClass, registry);
        this.mainSourceSet = mainSourceSet;
    }

    public J visitClassDecl(J.ClassDecl classDecl) {
        if (this.isScope()) {
            for (Map.Entry<String, RewriteBeanDefinition> beanDefinitionByName : this.registry.getBeanDefinitions(null).entrySet()) {
                RewriteBeanDefinition bean = beanDefinitionByName.getValue();
                if (this.mainSourceSet.resolve(bean.getBeanClassName().replace(".", "/")).toFile().exists()) continue;
                AddBeanMethod beanMethod = new AddBeanMethod(classDecl, beanDefinitionByName.getKey(), bean, this.registry);
                this.andThen((SourceVisitor)beanMethod);
                this.andThen((SourceVisitor)new AddBeanMethodBody(beanMethod.getMethodId(), bean.getBeanDefinitionBody(), new JavaType.Class[0]));
            }
        }
        return super.visitClassDecl(classDecl);
    }
}

