/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.spring.xml.bean;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.openrewrite.Formatting;
import org.openrewrite.SourceVisitor;
import org.openrewrite.Tree;
import org.openrewrite.java.refactor.AddAnnotation;
import org.openrewrite.java.refactor.ScopedJavaRefactorVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TreeBuilder;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.spring.xml.parse.RewriteBeanDefinition;
import org.openrewrite.spring.xml.parse.RewriteBeanDefinitionRegistry;

class AddBeanMethod
extends ScopedJavaRefactorVisitor {
    private static final JavaType.Class BEAN_TYPE = JavaType.Class.build((String)"org.springframework.context.annotation.Bean");
    private final String name;
    private final JavaType.Class returnType;
    private final boolean statik;
    private final List<Statement> arguments;
    @Nullable
    private final String initMethod;
    @Nullable
    private final String destroyMethod;
    private final UUID methodId = Tree.randomId();

    public AddBeanMethod(J.ClassDecl scope, String beanName, RewriteBeanDefinition bean, RewriteBeanDefinitionRegistry registry) {
        this(scope, beanName, bean.getType(), false, Formatting.formatFirstPrefix(bean.getPropertyValues().stream().map(pv -> {
            RewriteBeanDefinition propertyBean = registry.getBeanDefinition(pv.getName());
            JavaType.Class propertyBeanType = JavaType.Class.build((String)propertyBean.getBeanClassName());
            return new J.VariableDecls(Tree.randomId(), Collections.emptyList(), Collections.emptyList(), (TypeTree)J.Ident.build((UUID)Tree.randomId(), (String)propertyBeanType.getClassName(), (JavaType)propertyBeanType, (Formatting)Formatting.EMPTY), null, Collections.emptyList(), Collections.singletonList(new J.VariableDecls.NamedVar(Tree.randomId(), J.Ident.build((UUID)Tree.randomId(), (String)pv.getName(), (JavaType)propertyBeanType, (Formatting)Formatting.format((String)" ")), Collections.emptyList(), null, (JavaType)propertyBeanType, Formatting.EMPTY)), Formatting.format((String)" "));
        }).collect(Collectors.toList()), (String)""), bean.isLazyInit(), bean.isPrototype(), bean.getInitMethodName(), bean.getDestroyMethodName());
    }

    public AddBeanMethod(J.ClassDecl scope, String name, JavaType.Class returnType, boolean statik, List<Statement> arguments) {
        this(scope, name, returnType, statik, arguments, false, false, null, null);
    }

    public AddBeanMethod(J.ClassDecl scope, String name, JavaType.Class returnType, boolean statik, List<Statement> arguments, boolean lazy, boolean prototype, @Nullable String initMethod, @Nullable String destroyMethod) {
        super(scope.getId());
        this.name = name;
        this.returnType = returnType;
        this.statik = statik;
        this.arguments = arguments;
        this.initMethod = initMethod;
        this.destroyMethod = destroyMethod;
        if (lazy) {
            this.andThen((SourceVisitor)new AddAnnotation(this.methodId, "org.springframework.context.annotation.Lazy", new Expression[0]));
        }
        if (prototype) {
            JavaType.Class cbf = JavaType.Class.build((String)"org.springframework.beans.factory.config.ConfigurableBeanFactory");
            this.maybeAddImport(cbf.getFullyQualifiedName());
            this.andThen((SourceVisitor)new AddAnnotation(this.methodId, "org.springframework.context.annotation.Scope", new Expression[]{(Expression)TreeBuilder.buildName((String)"ConfigurableBeanFactory.SCOPE_PROTOTYPE").withType((JavaType)cbf)}));
        }
    }

    public UUID getMethodId() {
        return this.methodId;
    }

    public J visitClassDecl(J.ClassDecl classDecl) {
        J.ClassDecl c = (J.ClassDecl)this.refactor((Tree)classDecl, x$0 -> super.visitClassDecl(x$0));
        if (this.isScope()) {
            ArrayList<J.MethodDecl> statements = new ArrayList<J.MethodDecl>(c.getBody().getStatements());
            int insertionIndex = statements.size();
            for (int i = 0; i < statements.size(); ++i) {
                J statement = (J)statements.get(i);
                if (!statement.whenType(J.MethodDecl.class).map(m -> !m.isConstructor() && m.hasModifier("public") && m.getSimpleName().compareTo(this.name) > 0).orElse(false).booleanValue()) continue;
                insertionIndex = i;
                break;
            }
            this.maybeAddImport(BEAN_TYPE.getFullyQualifiedName());
            this.maybeAddImport((JavaType.FullyQualified)this.returnType);
            Formatting format = this.formatter.format((Tree)classDecl.getBody());
            J.MethodDecl beanMethod = new J.MethodDecl(this.methodId, Collections.singletonList(this.buildBeanAnnotation()), Collections.emptyList(), null, (TypeTree)TreeBuilder.buildName((String)this.returnType.getClassName(), (Formatting)Formatting.EMPTY).withType((JavaType)this.returnType), (J.Ident)TreeBuilder.buildName((String)this.name, (Formatting)Formatting.format((String)" ")), new J.MethodDecl.Parameters(Tree.randomId(), this.arguments, Formatting.EMPTY), null, new J.Block(Tree.randomId(), null, Collections.emptyList(), Formatting.format((String)" "), format.getPrefix()), null, Formatting.EMPTY).withModifiers(new String[]{"public"});
            if (this.statik) {
                beanMethod = beanMethod.withModifiers(new String[]{"static"});
            }
            beanMethod = beanMethod.withFormatting(format.withPrefix("\n" + format.getPrefix()));
            beanMethod = beanMethod.withModifiers(Formatting.formatFirstPrefix((List)beanMethod.getModifiers(), (String)format.getPrefix()));
            statements.add(insertionIndex, beanMethod);
            c = c.withBody(c.getBody().withStatements(statements));
        }
        return c;
    }

    private J.Annotation buildBeanAnnotation() {
        ArrayList<J.Assign> arguments = new ArrayList<J.Assign>();
        if (this.initMethod != null) {
            arguments.add(new J.Assign(Tree.randomId(), (Expression)J.Ident.build((UUID)Tree.randomId(), (String)"initMethod", (JavaType)JavaType.Primitive.String, (Formatting)Formatting.EMPTY), (Expression)new J.Literal(Tree.randomId(), (Object)this.initMethod, "\"" + this.initMethod + "\"", JavaType.Primitive.String, Formatting.EMPTY), (JavaType)JavaType.Primitive.String, Formatting.EMPTY));
        }
        if (this.destroyMethod != null) {
            arguments.add(new J.Assign(Tree.randomId(), (Expression)J.Ident.build((UUID)Tree.randomId(), (String)"destroyMethod", (JavaType)JavaType.Primitive.String, (Formatting)Formatting.EMPTY), (Expression)new J.Literal(Tree.randomId(), (Object)this.destroyMethod, "\"" + this.destroyMethod + "\"", JavaType.Primitive.String, Formatting.EMPTY), (JavaType)JavaType.Primitive.String, this.initMethod != null ? Formatting.format((String)" ") : Formatting.EMPTY));
        }
        return new J.Annotation(Tree.randomId(), (NameTree)J.Ident.build((UUID)Tree.randomId(), (String)BEAN_TYPE.getClassName(), (JavaType)BEAN_TYPE, (Formatting)Formatting.EMPTY), arguments.isEmpty() ? null : new J.Annotation.Arguments(Tree.randomId(), arguments, Formatting.EMPTY), Formatting.EMPTY);
    }
}

