/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.spring.xml.bean;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.openrewrite.Formatting;
import org.openrewrite.SourceVisitor;
import org.openrewrite.Tree;
import org.openrewrite.java.refactor.AddAnnotation;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.refactor.Formatter;
import org.openrewrite.spring.xml.bean.BeanDefinitionVisitor;
import org.openrewrite.spring.xml.parse.RewriteBeanDefinition;
import org.openrewrite.spring.xml.parse.RewriteBeanDefinitionRegistry;

public class AddComponentScan
extends BeanDefinitionVisitor {
    public AddComponentScan(J.ClassDecl profileConfigurationClass, RewriteBeanDefinitionRegistry registry) {
        super(profileConfigurationClass, registry);
    }

    public J visitClassDecl(J.ClassDecl classDecl) {
        List basePackagesToComponentScan;
        if (this.isScope() && !(basePackagesToComponentScan = this.registry.getBeanDefinitions(RewriteBeanDefinition.Type.ComponentScan).values().stream().map(bd -> bd.getProperty("basePackage").orElse(null)).filter(Objects::nonNull).sorted((p1, p2) -> {
            String[] p1s = p1.split("\\.");
            String[] p2s = p2.split("\\.");
            for (int i = 0; i < p1s.length; ++i) {
                String s = p1s[i];
                if (p2s.length < i + 1) {
                    return 1;
                }
                if (s.equals(p2s[i])) continue;
                return s.compareTo(p2s[i]);
            }
            return p1s.length < p2s.length ? -1 : 0;
        }).collect(Collectors.toList())).isEmpty()) {
            J.Literal arguments;
            if (basePackagesToComponentScan.size() == 1) {
                String bp2 = (String)basePackagesToComponentScan.get(0);
                arguments = new J.Literal(Tree.randomId(), (Object)bp2, "\"" + bp2 + "\"", JavaType.Primitive.String, Formatting.EMPTY);
            } else {
                Formatter.Result classDeclIndent = this.formatter.findIndent(0, new Tree[]{classDecl});
                String prefix = classDeclIndent.getPrefix();
                List argExpressions = basePackagesToComponentScan.stream().map(bp -> new J.Literal(Tree.randomId(), bp, "\"" + bp + "\"", JavaType.Primitive.String, Formatting.format((String)prefix))).collect(Collectors.toList());
                argExpressions = Formatting.formatLastSuffix(argExpressions, (String)classDeclIndent.getPrefix(-1));
                arguments = new J.NewArray(Tree.randomId(), null, Collections.emptyList(), new J.NewArray.Initializer(Tree.randomId(), argExpressions, Formatting.EMPTY), (JavaType)JavaType.Class.build((String)"java.lang.String"), Formatting.EMPTY);
            }
            this.andThen((SourceVisitor)new AddAnnotation(classDecl.getId(), "org.springframework.context.annotation.ComponentScan", new Expression[]{arguments}));
        }
        return super.visitClassDecl(classDecl);
    }
}

