/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.spring.xml.bean;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.openrewrite.Formatting;
import org.openrewrite.SourceVisitor;
import org.openrewrite.Tree;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TreeBuilder;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.spring.xml.bean.AddBeanMethod;
import org.openrewrite.spring.xml.bean.AddBeanMethodBody;
import org.openrewrite.spring.xml.bean.BeanDefinitionVisitor;
import org.openrewrite.spring.xml.parse.RewriteBeanDefinition;
import org.openrewrite.spring.xml.parse.RewriteBeanDefinitionRegistry;

public class AddPropertySourcesPlaceholderConfigurer
extends BeanDefinitionVisitor {
    static final Pattern PROPERTY_PATTERN = Pattern.compile("\\$\\{([^:}]+):?[^}]*}");

    public AddPropertySourcesPlaceholderConfigurer(J.ClassDecl profileConfigurationClass, RewriteBeanDefinitionRegistry beanDefinitionRegistry) {
        super(profileConfigurationClass, beanDefinitionRegistry);
    }

    public J visitClassDecl(J.ClassDecl classDecl) {
        if (this.isScope()) {
            AtomicInteger seq = new AtomicInteger();
            List propertyPlaceholders = this.registry.getBeanDefinitions(RewriteBeanDefinition.Type.PropertyPlaceholder).values().stream().sorted(Comparator.comparingInt(bd -> bd.getIntegerProperty("order").orElseGet(seq::incrementAndGet))).collect(Collectors.toList());
            Map propertyNamesByReference = propertyPlaceholders.stream().flatMap(pp -> pp.getStringProperty("location").stream().flatMap(loc -> Arrays.stream(loc.split(",")))).flatMap(location -> PROPERTY_PATTERN.matcher((CharSequence)location).results()).collect(Collectors.toMap(res -> res.group(0), res -> res.group(1), (m1, m2) -> m1, LinkedHashMap::new));
            if (!propertyPlaceholders.isEmpty()) {
                AddBeanMethod addBeanMethod = new AddBeanMethod(classDecl, "properties", JavaType.Class.build((String)"org.springframework.context.support.PropertySourcesPlaceholderConfigurer"), true, Formatting.formatFirstPrefix(propertyNamesByReference.entrySet().stream().map(nameByRef -> (Statement)this.valueArgument((String)nameByRef.getValue(), (String)nameByRef.getKey()).withPrefix(" ")).collect(Collectors.toList()), (String)""));
                this.andThen((SourceVisitor)addBeanMethod);
                boolean ignoreResourceNotFound = propertyPlaceholders.stream().anyMatch(pp -> pp.getBooleanProperty("ignoreResourceNotFound").orElse(false));
                boolean ignoreUnresolvablePlaceholders = propertyPlaceholders.stream().anyMatch(pp -> pp.getBooleanProperty("ignoreUnresolvable").orElse(false));
                this.andThen((SourceVisitor)new AddBeanMethodBody(addBeanMethod.getMethodId(), "PropertySourcesPlaceholderConfigurer pspc = new PropertySourcesPlaceholderConfigurer();\nResource[] resources = new Resource[]{\n" + propertyPlaceholders.stream().flatMap(pp -> pp.getStringProperty("location").stream().flatMap(loc -> Arrays.stream(loc.split(",")))).map(location -> {
                    location = "\"" + propertyNamesByReference.entrySet().stream().reduce(location, (acc, nameByRef) -> acc.replace((CharSequence)nameByRef.getKey(), "\" + " + (String)nameByRef.getValue() + " + \""), (r1, r2) -> r1) + "\"";
                    location = ((String)location).replace("\"\" + ", "");
                    if (((String)(location = ((String)location).replace(" + \"\"", ""))).startsWith("\"classpath:")) {
                        this.addImport("org.springframework.core.io.ClassPathResource");
                        return "new ClassPathResource(\"" + ((String)location).substring("\"classpath:".length()) + ")";
                    }
                    this.addImport("org.springframework.core.io.FileSystemResource");
                    return "new FileSystemResource(" + (String)location + ")";
                }).collect(Collectors.joining(",\n    ", "    ", "\n")) + "};\npspc.setLocations(resources);\n" + (ignoreResourceNotFound ? "pspc.setIgnoreResourceNotFound(true);\n" : "") + (ignoreUnresolvablePlaceholders ? "pspc.setIgnoreUnresolvablePlaceholders(true);\n" : "") + "return pspc;", JavaType.Class.build((String)"org.springframework.core.io.ClassPathResource"), JavaType.Class.build((String)"org.springframework.core.io.FileSystemResource"), JavaType.Class.build((String)"org.springframework.core.io.Resource"), JavaType.Class.build((String)"org.springframework.context.support.PropertySourcesPlaceholderConfigurer")));
                this.addImport("org.springframework.core.io.Resource");
                this.maybeAddImport("org.springframework.beans.factory.annotation.Value");
            }
        }
        return super.visitClassDecl(classDecl);
    }

    private Statement valueArgument(String name, String value) {
        JavaType.Class valueType = JavaType.Class.build((String)"org.springframework.beans.factory.annotation.Value");
        J.Annotation valueAnnotation = new J.Annotation(Tree.randomId(), (NameTree)J.Ident.build((UUID)Tree.randomId(), (String)valueType.getClassName(), (JavaType)valueType, (Formatting)Formatting.EMPTY), new J.Annotation.Arguments(Tree.randomId(), Collections.singletonList(new J.Literal(Tree.randomId(), (Object)value, "\"" + value + "\"", JavaType.Primitive.String, Formatting.EMPTY)), Formatting.EMPTY), Formatting.EMPTY);
        return new J.VariableDecls(Tree.randomId(), Collections.singletonList(valueAnnotation), Collections.emptyList(), (TypeTree)TreeBuilder.buildName((String)"String").withType((JavaType)JavaType.Class.build((String)"java.lang.String")).withPrefix(" "), null, Collections.emptyList(), Collections.singletonList(new J.VariableDecls.NamedVar(Tree.randomId(), (J.Ident)TreeBuilder.buildName((String)name), Collections.emptyList(), null, (JavaType)JavaType.Class.build((String)"java.lang.String"), Formatting.format((String)" "))), Formatting.EMPTY);
    }
}

