/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.spring.xml.parse;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.tree.JavaType;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.core.ResolvableType;
import org.springframework.lang.Nullable;

public class RewriteBeanDefinition
implements BeanDefinition {
    public static final String TYPE_PROPERTY_KEY = "__rewrite_type";
    private final BeanDefinition delegate;

    public RewriteBeanDefinition(BeanDefinition delegate) {
        this.delegate = delegate;
    }

    public JavaType.Class getType() {
        return JavaType.Class.build((String)this.getBeanClassName());
    }

    public String getBeanDefinitionBody() {
        JavaType.Class beanType = this.getType();
        Object newClass = "new " + beanType.getClassName() + "(";
        ConstructorArgumentValues cav = this.getConstructorArgumentValues();
        if (!cav.isEmpty()) {
            if (!cav.getIndexedArgumentValues().isEmpty()) {
                newClass = cav.getIndexedArgumentValues().values().stream().map(ConstructorArgumentValues.ValueHolder::getName).collect(Collectors.joining(","));
            } else {
                List args = cav.getGenericArgumentValues();
                Optional<List> optional = beanType.getConstructors().stream().filter(c -> c.getParamNames().size() == args.size()).map(c -> {
                    ArrayList outOfOrder = new ArrayList(args);
                    ArrayList<ConstructorArgumentValues.ValueHolder> inOrder = new ArrayList<ConstructorArgumentValues.ValueHolder>();
                    block0: for (JavaType paramType : c.getGenericSignature().getParamTypes()) {
                        if (!(paramType instanceof JavaType.FullyQualified)) {
                            return null;
                        }
                        String paramTypeName = ((JavaType.FullyQualified)paramType).getFullyQualifiedName();
                        for (int i = 0; i < outOfOrder.size(); ++i) {
                            if (!paramTypeName.equals(((ConstructorArgumentValues.ValueHolder)outOfOrder.get(i)).getType())) continue;
                            inOrder.add((ConstructorArgumentValues.ValueHolder)outOfOrder.get(i));
                            outOfOrder.remove(i);
                            continue block0;
                        }
                    }
                    return outOfOrder.isEmpty() ? inOrder : null;
                }).filter(Objects::nonNull).findAny();
            }
        }
        newClass = (String)newClass + ")";
        if (this.getPropertyValues().isEmpty()) {
            return "return " + (String)newClass;
        }
        String variableName = beanType.getClassName().substring(0, 1).toLowerCase() + beanType.getClassName().substring(1);
        return beanType.getClassName() + " " + variableName + " = " + (String)newClass + ";" + this.getPropertyValues().getPropertyValueList().stream().map(pv -> variableName + ".set" + pv.getName().substring(0, 1).toUpperCase() + pv.getName().substring(1) + "(" + pv.getName() + ");").collect(Collectors.joining("\n", "\n", "\n")) + "return " + variableName + ";\n";
    }

    public final <T> Optional<T> getProperty(String property) {
        PropertyValue propertyValue = this.getPropertyValues().getPropertyValue(property);
        return propertyValue == null ? Optional.empty() : Optional.ofNullable(propertyValue.getValue());
    }

    public final Optional<String> getStringProperty(String property) {
        return this.getProperty(property);
    }

    public final Optional<Boolean> getBooleanProperty(String property) {
        return this.getProperty(property).map(value -> {
            if (value instanceof String) {
                return Boolean.parseBoolean((String)value);
            }
            return (Boolean)value;
        });
    }

    public final Optional<Integer> getIntegerProperty(String property) {
        return this.getProperty(property).map(value -> {
            if (value instanceof String) {
                return Integer.parseInt((String)value);
            }
            return (Integer)value;
        });
    }

    public final boolean isType(@Nullable Type type) {
        return this.isPropertyEqualTo(TYPE_PROPERTY_KEY, (Object)type);
    }

    public final boolean isPropertyEqualTo(String property, @org.openrewrite.internal.lang.Nullable Object value) {
        Object propertyValue = this.getProperty(property).orElse(null);
        return value == null && propertyValue == null || value != null && value.equals(propertyValue);
    }

    public void setParentName(String parentName) {
        this.delegate.setParentName(parentName);
    }

    @Nullable
    public String getParentName() {
        return this.delegate.getParentName();
    }

    public void setBeanClassName(String beanClassName) {
        this.delegate.setBeanClassName(beanClassName);
    }

    @NonNull
    public String getBeanClassName() {
        return this.delegate.getBeanClassName();
    }

    public void setScope(String scope) {
        this.delegate.setScope(scope);
    }

    @Nullable
    public String getScope() {
        return this.delegate.getScope();
    }

    public void setLazyInit(boolean lazyInit) {
        this.delegate.setLazyInit(lazyInit);
    }

    public boolean isLazyInit() {
        return this.delegate.isLazyInit();
    }

    public void setDependsOn(String ... dependsOn) {
        this.delegate.setDependsOn(dependsOn);
    }

    @Nullable
    public String[] getDependsOn() {
        return this.delegate.getDependsOn();
    }

    public void setAutowireCandidate(boolean autowireCandidate) {
        this.delegate.setAutowireCandidate(autowireCandidate);
    }

    public boolean isAutowireCandidate() {
        return this.delegate.isAutowireCandidate();
    }

    public void setPrimary(boolean primary) {
        this.delegate.setPrimary(primary);
    }

    public boolean isPrimary() {
        return this.delegate.isPrimary();
    }

    public void setFactoryBeanName(String factoryBeanName) {
        this.delegate.setFactoryBeanName(factoryBeanName);
    }

    @Nullable
    public String getFactoryBeanName() {
        return this.delegate.getFactoryBeanName();
    }

    public void setFactoryMethodName(String factoryMethodName) {
        this.delegate.setFactoryMethodName(factoryMethodName);
    }

    @Nullable
    public String getFactoryMethodName() {
        return this.delegate.getFactoryMethodName();
    }

    public ConstructorArgumentValues getConstructorArgumentValues() {
        return this.delegate.getConstructorArgumentValues();
    }

    public boolean hasConstructorArgumentValues() {
        return this.delegate.hasConstructorArgumentValues();
    }

    public MutablePropertyValues getPropertyValues() {
        return this.delegate.getPropertyValues();
    }

    public boolean hasPropertyValues() {
        return this.delegate.hasPropertyValues();
    }

    public void setInitMethodName(String initMethodName) {
        this.delegate.setInitMethodName(initMethodName);
    }

    @Nullable
    public String getInitMethodName() {
        return this.delegate.getInitMethodName();
    }

    public void setDestroyMethodName(String destroyMethodName) {
        this.delegate.setDestroyMethodName(destroyMethodName);
    }

    @Nullable
    public String getDestroyMethodName() {
        return this.delegate.getDestroyMethodName();
    }

    public void setRole(int role) {
        this.delegate.setRole(role);
    }

    public int getRole() {
        return this.delegate.getRole();
    }

    public void setDescription(String description) {
        this.delegate.setDescription(description);
    }

    @Nullable
    public String getDescription() {
        return this.delegate.getDescription();
    }

    public ResolvableType getResolvableType() {
        return this.delegate.getResolvableType();
    }

    public boolean isSingleton() {
        return this.delegate.isSingleton();
    }

    public boolean isPrototype() {
        return this.delegate.isPrototype();
    }

    public boolean isAbstract() {
        return this.delegate.isAbstract();
    }

    @Nullable
    public String getResourceDescription() {
        return this.delegate.getResourceDescription();
    }

    @Nullable
    public BeanDefinition getOriginatingBeanDefinition() {
        return this.delegate.getOriginatingBeanDefinition();
    }

    public void setAttribute(String name, Object value) {
        this.delegate.setAttribute(name, value);
    }

    @Nullable
    public Object getAttribute(String name) {
        return this.delegate.getAttribute(name);
    }

    @Nullable
    public Object removeAttribute(String name) {
        return this.delegate.removeAttribute(name);
    }

    public boolean hasAttribute(String name) {
        return this.delegate.hasAttribute(name);
    }

    public String[] attributeNames() {
        return this.delegate.attributeNames();
    }

    @Nullable
    public Object getSource() {
        return this.delegate.getSource();
    }

    public static enum Type {
        ComponentScan("context"),
        PropertyPlaceholder("context");

        private final String namespace;

        private Type(String namespace) {
            this.namespace = namespace;
        }

        public String getNamespace() {
            return this.namespace;
        }
    }
}

