/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.spring.xml.parse;

import java.util.Map;
import org.openrewrite.spring.xml.parse.RewriteBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSimpleBeanDefinitionParser;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;
import org.w3c.dom.Element;

public class RewriteNamespaceHandler
extends NamespaceHandlerSupport {
    private final Map<String, RewriteBeanDefinition.Type> types;

    public RewriteNamespaceHandler(Map<String, RewriteBeanDefinition.Type> types) {
        this.types = types;
        this.init();
    }

    public void init() {
        for (Map.Entry<String, RewriteBeanDefinition.Type> parserByElementName : this.types.entrySet()) {
            this.registerBeanDefinitionParser(parserByElementName.getKey(), (BeanDefinitionParser)new PropertyPreservingBeanDefinitionParser(parserByElementName.getValue()));
        }
    }

    private static class PropertyPreservingBeanDefinitionParser
    extends AbstractSimpleBeanDefinitionParser {
        private final RewriteBeanDefinition.Type type;

        private PropertyPreservingBeanDefinitionParser(RewriteBeanDefinition.Type type) {
            this.type = type;
        }

        protected boolean shouldGenerateId() {
            return true;
        }

        protected void postProcess(BeanDefinitionBuilder beanDefinition, Element element) {
            beanDefinition.getBeanDefinition().setBeanClassName(this.type.getNamespace() + ":" + this.type.name());
            beanDefinition.getBeanDefinition().getPropertyValues().addPropertyValue("__rewrite_type", (Object)this.type);
            super.postProcess(beanDefinition, element);
        }
    }
}

