/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.spring;

import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.openrewrite.AutoConfigure;
import org.openrewrite.Formatting;
import org.openrewrite.SourceVisitor;
import org.openrewrite.Tree;
import org.openrewrite.java.AddAnnotation;
import org.openrewrite.java.GenerateConstructorUsingFields;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRefactorVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.TypeUtils;

@AutoConfigure
public class ConstructorInjection
extends JavaRefactorVisitor {
    private boolean useLombokRequiredArgsAnnotation = false;
    private boolean useJsr305Annotations = false;
    private final JavaParser javaParser;

    public ConstructorInjection() {
        JavaParser.Builder javaParserBuilder;
        try {
            javaParserBuilder = System.getProperty("java.version").startsWith("1.8") ? (JavaParser.Builder)Class.forName("org.openrewrite.java.Java8Parser").getDeclaredMethod("builder", new Class[0]).invoke(null, new Object[0]) : (JavaParser.Builder)Class.forName("org.openrewrite.java.Java11Parser").getDeclaredMethod("builder", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to create a Java parser instance. `rewrite-java-8` or `rewrite-java-11` must be on the classpath.");
        }
        this.javaParser = javaParserBuilder.build();
    }

    public void setUseJsr305Annotations(boolean useJsr305Annotations) {
        this.useJsr305Annotations = useJsr305Annotations;
    }

    public void setUseLombokRequiredArgsAnnotation(boolean useLombokRequiredArgsAnnotation) {
        this.useLombokRequiredArgsAnnotation = useLombokRequiredArgsAnnotation;
    }

    public J visitClassDecl(J.ClassDecl classDecl) {
        J.ClassDecl cd = (J.ClassDecl)this.refactor((Tree)classDecl, x$0 -> super.visitClassDecl(x$0));
        if (cd.getFields().stream().anyMatch(this::isFieldInjected)) {
            List statements = cd.getBody().getStatements().stream().map(stat -> stat.whenType(J.VariableDecls.class).filter(this::isFieldInjected).map(mv -> {
                J.VariableDecls fixedField = mv.withAnnotations(mv.getAnnotations().stream().filter(ann -> !this.isFieldInjectionAnnotation((J.Annotation)ann) || this.useJsr305Annotations && ann.getArgs() != null && ann.getArgs().getArgs().stream().anyMatch(arg -> arg.whenType(J.Assign.class).map(assign -> ((J.Ident)assign.getVariable()).getSimpleName().equals("required")).orElse(false))).map(ann -> {
                    if (this.isFieldInjectionAnnotation((J.Annotation)ann)) {
                        this.maybeAddImport("javax.annotation.Nonnull");
                        JavaType.Class nonnullType = JavaType.Class.build((String)"javax.annotation.Nonnull");
                        return ann.withAnnotationType((NameTree)J.Ident.build((UUID)Tree.randomId(), (String)"Nonnull", (JavaType)nonnullType, (Formatting)ann.getAnnotationType().getFormatting())).withArgs(null).withType((JavaType)nonnullType);
                    }
                    return ann;
                }).collect(Collectors.toList())).withModifiers(new String[]{"private", "final"});
                this.maybeRemoveImport("org.springframework.beans.factory.annotation.Autowired");
                return fixedField.getAnnotations().isEmpty() && !mv.getAnnotations().isEmpty() ? fixedField.withModifiers(Formatting.formatFirstPrefix((List)fixedField.getModifiers(), (String)Formatting.firstPrefix((List)mv.getAnnotations()))) : fixedField;
            }).orElse((J)stat)).collect(Collectors.toList());
            if (!this.hasRequiredArgsConstructor(cd)) {
                this.andThen((SourceVisitor)(this.useLombokRequiredArgsAnnotation ? new AddAnnotation.Scoped((Tree)cd, "lombok.RequiredArgsConstructor", new Expression[0]) : new GenerateConstructorUsingFields(this.javaParser, cd, this.getInjectedFields(cd))));
            }
            List setterNames = this.getInjectedFields(cd).stream().map(mv -> {
                String name = ((J.VariableDecls.NamedVar)mv.getVars().get(0)).getSimpleName();
                return "set" + name.substring(0, 1).toUpperCase() + name.substring(1);
            }).collect(Collectors.toList());
            cd = cd.withBody(cd.getBody().withStatements(statements.stream().filter(stat -> stat.whenType(J.MethodDecl.class).map(md -> !setterNames.contains(md.getSimpleName())).orElse(true)).collect(Collectors.toList())));
        }
        return cd;
    }

    private boolean hasRequiredArgsConstructor(J.ClassDecl cd) {
        Set injectedFieldNames = this.getInjectedFields(cd).stream().map(f -> ((J.VariableDecls.NamedVar)f.getVars().get(0)).getSimpleName()).collect(Collectors.toSet());
        return cd.getBody().getStatements().stream().anyMatch(stat -> stat.whenType(J.MethodDecl.class).filter(J.MethodDecl::isConstructor).map(md -> md.getParams().getParams().stream().map(p -> p.whenType(J.VariableDecls.class).map(mv -> ((J.VariableDecls.NamedVar)mv.getVars().get(0)).getSimpleName()).orElseThrow(() -> new RuntimeException("not possible to get here"))).allMatch(injectedFieldNames::contains)).orElse(false));
    }

    private List<J.VariableDecls> getInjectedFields(J.ClassDecl cd) {
        return cd.getBody().getStatements().stream().filter(stat -> stat.whenType(J.VariableDecls.class).map(this::isFieldInjected).orElse(false)).map(J.VariableDecls.class::cast).collect(Collectors.toList());
    }

    private boolean isFieldInjected(J.VariableDecls mv) {
        return mv.getAnnotations().stream().anyMatch(this::isFieldInjectionAnnotation);
    }

    private boolean isFieldInjectionAnnotation(J.Annotation ann) {
        return TypeUtils.isOfClassType((JavaType)ann.getType(), (String)"javax.inject.Inject") || TypeUtils.isOfClassType((JavaType)ann.getType(), (String)"org.springframework.beans.factory.annotation.Autowired");
    }
}

