/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.spring;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.AutoConfigure;
import org.openrewrite.Formatting;
import org.openrewrite.SourceVisitor;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaRefactorVisitor;
import org.openrewrite.java.RenameVariable;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

@AutoConfigure
public class ImplicitWebAnnotationNames
extends JavaRefactorVisitor {
    private static final Set<String> PARAM_ANNOTATIONS = Stream.of("PathVariable", "RequestParam", "RequestHeader", "RequestAttribute", "CookieValue", "ModelAttribute", "SessionAttribute").map(className -> "org.springframework.web.bind.annotation." + className).collect(Collectors.toSet());

    public ImplicitWebAnnotationNames() {
        this.setCursoringOn();
    }

    public J visitAnnotation(J.Annotation annotation) {
        J.Annotation a = (J.Annotation)this.refactor((Tree)annotation, x$0 -> super.visitAnnotation(x$0));
        if (PARAM_ANNOTATIONS.stream().anyMatch(annClass -> TypeUtils.isOfClassType((JavaType)annotation.getType(), (String)annClass)) && annotation.getArgs() != null && this.nameArgumentValue(annotation).isPresent()) {
            J.Annotation.Arguments args = a.getArgs();
            if (args == null) {
                return a;
            }
            args = args.withArgs(args.getArgs().stream().filter(arg -> arg.whenType(J.Assign.class).map(assign -> !assign.getVariable().whenType(J.Ident.class).filter(key -> key.getSimpleName().equals("value") || key.getSimpleName().equals("name")).isPresent()).orElse(false)).collect(Collectors.toList()));
            if ((args = args.withArgs(Formatting.formatFirstPrefix((List)args.getArgs(), (String)""))).getArgs().isEmpty()) {
                args = null;
            }
            this.nameArgumentValue(a).ifPresent(value -> this.andThen((SourceVisitor)new RenameVariable((J.VariableDecls.NamedVar)((J.VariableDecls)this.getCursor().getParentOrThrow().getTree()).getVars().get(0), (String)value.getValue())));
            a = a.withArgs(args);
        }
        return a;
    }

    private Optional<J.Literal> nameArgumentValue(J.Annotation annotation) {
        J.Annotation.Arguments args = annotation.getArgs();
        return args == null ? Optional.empty() : args.getArgs().stream().filter(arg -> arg.whenType(J.Assign.class).filter(assign -> assign.getVariable().whenType(J.Ident.class).map(key -> key.getSimpleName().equals("value") || key.getSimpleName().equals("name")).orElse(false)).map(assign -> (J.Literal)assign.getAssignment()).isPresent() || arg.whenType(J.Literal.class).isPresent()).findAny().flatMap(arg -> arg.whenType(J.Assign.class).map(assign -> assign.getAssignment().whenType(J.Literal.class)).orElse(arg.whenType(J.Literal.class)));
    }
}

